﻿---
title: Explore mobile sessions with Discover
description: Elastic Mobile APM provides session tracking by attaching a session.id, a guid, to every span and event. This allows for the recall of the activities...
url: https://www.elastic.co/docs/solutions/observability/apm/explore-mobile-sessions
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Explore mobile sessions with Discover
Elastic Mobile APM provides session tracking by attaching a `session.id`, a guid, to every span and event. This allows for the recall of the activities of a specific user during a specific period of time. The best way recall these data points is using [Discover](https://www.elastic.co/docs/explore-analyze/discover/document-explorer). This guide will explain how to do that.

## Viewing sessions with Discover

The first step is to find the relevant `session.id`. In this example, we’ll walk through investigating a crash. Since all events and spans have `session.id` attributes, a crash is no different.
The steps to follow are:
- copy the `session.id` from the relevant document.
- Open the Discover page.
- Select the appropriate data view (use `APM` to search all data streams)
- set filter to the copied `session.id`

Here we can see the `session.id` guid in the metadata viewer in the error detail view:
![Example of session.id in error details](https://www.elastic.co/docs/solutions/images/observability-mobile-session-error-details.png)

Copy this value and open the Discover page:
![Example view of navigation to Discover](https://www.elastic.co/docs/solutions/images/observability-mobile-session-explorer-nav.png)

Set the data view. `APM` selected in the example:
![Example view of Explorer selecting APM data view](https://www.elastic.co/docs/solutions/images/observability-mobile-session-explorer-apm.png)

Filter using the `session.id`: `session.id: "<copied session id guid>"`:
![Filter Explor using session.id](https://www.elastic.co/docs/solutions/images/observability-mobile-session-filter-discover.png)

Explore all the documents associated with that session id including crashes, lifecycle events, network requests, errors, and other custom events!