﻿---
title: Delete sensitive data
description: If you accidentally ingest sensitive data, follow these steps to remove or redact the offending data: Stop collecting the sensitive data. Use the remedy...
url: https://www.elastic.co/docs/solutions/observability/apm/delete-sensitive-data
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Delete sensitive data
If you accidentally ingest sensitive data, follow these steps to remove or redact the offending data:
1. Stop collecting the sensitive data. Use the **remedy** column of the [sensitive fields](/docs/solutions/observability/apm/secure-data#apm-sensitive-fields) table to determine how to stop collecting the offending data.
2. Delete or redact the ingested data. With data collection fixed, you can now delete or redact the offending data:
   - [Redact specific fields](#apm-redact-field-data)
- [Delete Elasticsearch documents](#apm-delete-doc-data)


## Redact specific fields

To redact sensitive data in a specific field, use the [update by query API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-update-by-query).
For example, the following query removes the `client.ip` address from APM documents in the `logs-apm.error-default` data stream:
```json

{
  "query": {
    "exists": {
      "field": "client.ip"
    }
  }
  "script": {
    "source": "ctx._source.client.ip = params.redacted",
    "params": {
      "redacted": "[redacted]"
    }
  }
}
```

Or, perhaps you only want to redact IP addresses from European users:
```json

{
  "query": {
    "term": {
      "client.geo.continent_name": {
        "value": "Europe"
      }
    }
  },
  "script": {
    "source": "ctx._source.client.ip = params.redacted",
    "params": {
      "redacted": "[redacted]"
    }
  }
}
```

See [update by query API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-update-by-query) for more information and examples.

## Delete Elasticsearch documents

<warning>
  This will permanently delete your data. You should test your queries with the [search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) prior to deleting data.
</warning>

To delete an Elasticsearch document, you can use the [delete by query API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-delete-by-query).
For example, to delete all documents in the `apm-traces-*` data stream with a `user.email` value, run the following query:
```json

{
  "query": {
    "exists": {
      "field": "user.email"
    }
  }
}
```

See [delete by query API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-delete-by-query) for more information and examples.