﻿---
title: Cross-cluster search with application data
description: Elastic APM utilizes Elasticsearch's cross-cluster search functionality. Cross-cluster search lets you run a single search request against one or more...
url: https://www.elastic.co/docs/solutions/observability/apm/cross-cluster-search
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Cross-cluster search with application data
Elastic APM utilizes Elasticsearch's cross-cluster search functionality. Cross-cluster search lets you run a single search request against one or more [remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-self-managed) — making it easy to search APM data across multiple sources. This means you can also have deployments per data type, making sizing and scaling more predictable, and allowing for better performance while managing multiple observability use cases.

## Set up cross-cluster search

**Step 1. Set up remote clusters.**
If you’re using the Elastic Cloud Hosted, see [Enable cross-cluster search](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-enable-ccs).
To add remote clusters directly in Kibana, find `Remote Clusters` in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). All you need is a name for the remote cluster and the seed node(s). Remember the names of your remote clusters, you’ll need them in step two. See [managing remote clusters](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/set-up-cross-cluster-replication) for detailed information on the setup process.
Alternatively, you can [configure remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-self-managed) in Elasticsearch's [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) file.
**Step 2. Edit the default Applications UI data views.**
Applications UI data views determine which clusters and indices to display data from. Data views follow this convention: `<cluster-name>:<index-pattern>`.
To display data from all remote clusters and the local cluster, duplicate and prepend the defaults with `*:`. For example, the default data view for Error indices is `logs-apm*,apm*`. To add all remote clusters, change this to `*:logs-apm*,*:apm*,logs-apm*,apm*`
You can also specify certain clusters to display data from, for example, `cluster-one:logs-apm*,cluster-one:apm*,logs-apm*,apm*`.
There are two ways to edit the default data view:
- In the Applications UI — Find **Applications** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Go to **Settings** → **Indices** and change all `xpack.apm.indices.*` values to include remote clusters.
- In [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) — Update the [`xpack.apm.indices.*`](https://www.elastic.co/docs/reference/kibana/configuration-reference/apm-settings) configuration values to include remote clusters.

<tip>
  In a cross-cluster search (CCS) environment, it’s possible for different clusters to serve different data tiers in responses. If one of the requested clusters responds slowly, it can cause a timeout at the proxy after 320 seconds. This results in 502 Bad Gateway server error responses presented as failure toast messages in the UI, and no data loaded.To prevent this, you can exclude [data tiers](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers) that might slow down responses from search: the `data_frozen` and `data_cold` tiers. To exclude data tiers from search in the APM UI:
  1. To open the **Advanced settings** management page, find it in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
  2. In the **Observability** section, update the **Excluded data tiers from search** option with a list of data tiers.
</tip>