﻿---
title: Create APM rules and alerts
description: The Applications UI allows you to define rules to detect complex conditions within your APM data and trigger built-in actions when those conditions are...
url: https://www.elastic.co/docs/solutions/observability/apm/create-apm-rules-alerts
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create APM rules and alerts
The Applications UI allows you to define **rules** to detect complex conditions within your APM data and trigger built-in **actions** when those conditions are met.

## APM rules

The following APM rules are supported:

|                                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
|---------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **APM Anomaly**                       | Alert when either the latency, throughput, or failed transaction rate of a service is anomalous.Anomaly rules can be set at the environment level, service level, and/or transaction type level. Read more in [APM Anomaly rule →](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-apm-anomaly-rule)                                                                                                                    |
| **Error count threshold**             | Alert when the number of errors in a service exceeds a defined threshold. Error count rules can be set at theenvironment level, service level, and error group level. Read more in [Error count threshold rule →](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-error-count-threshold-rule)                                                                                                                           |
| **Failed transaction rate threshold** | Alert when the rate of transaction errors in a service exceeds a defined threshold. Read more in [Failed transaction rate threshold rule →](https://www.elastic.co/docs/solutions/observability/incident-management/create-failed-transaction-rate-threshold-rule)                                                                                                                                                                                        |
| **Latency threshold**                 | Alert when the latency or failed transaction rate is abnormal.Threshold rules can be as broad or as granular as you’d like, enabling you to define exactly when you want to be alerted—whether that’s at the environment level, service name level, transaction type level, and/or transaction name level. Read more in [Latency threshold rule →](https://www.elastic.co/docs/solutions/observability/incident-management/create-latency-threshold-rule) |

<tip>
  For a complete walkthrough of the **Create rule** flyout panel, including detailed information on each configurable property, see Kibana’s [Create and manage rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules).
</tip>


## Rules and alerts in the Applications UI

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

View and manage rules and alerts in the Applications UI.

### View active alerts

Active alerts are displayed and grouped in multiple ways in the Applications UI.

#### View alerts by service group

If you’re using the [service groups](/docs/solutions/observability/apm/services#service-groups) feature, you can view alerts by service group. From the service group overview page, click the red alert indicator to open the **Alerts** tab with a predefined filter that matches the filter used when creating the service group.
![Example view of service group in the Applications UI in Kibana](https://www.elastic.co/docs/solutions/images/observability-apm-service-group.png)


#### View alerts by service

Alerts can be viewed within the context of any service. After selecting a service, go to the **Alerts** tab to view any alerts that are active for the selected service.
![View active alerts by service](https://www.elastic.co/docs/solutions/images/observability-active-alert-service.png)


### Manage alerts and rules

From the Applications UI, select **Alerts and rules** → **Manage rules** to be taken to the Kibana **Rules** page. From this page, you can disable, mute, and delete APM alerts.

### More information

See [Alerting](https://www.elastic.co/docs/explore-analyze/alerts-cases) for more information.
<note>
  If you are using an **on-premise** Elastic Stack deployment with security, communication between Elasticsearch and Kibana must have TLS configured. More information is in the alerting [prerequisites](/docs/explore-analyze/alerts-cases/alerts/alerting-setup#alerting-prerequisites).
</note>