﻿---
title: Applications UI settings
description: You can adjust Application settings to fine-tune your experience in the Applications UI. To change APM settings, select Settings from any Applications...
url: https://www.elastic.co/docs/solutions/observability/apm/applications-ui-settings
products:
  - APM
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Applications UI settings
<note>
  The **Editor** role or higher is required to modify settings. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
</note>

You can adjust Application settings to fine-tune your experience in the Applications UI.

## General settings

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

To change APM settings, select **Settings** from any **Applications** page. The following settings are available.
<definitions>
  <definition term="observability:apmAgentExplorerView Elastic Stack: Beta">
    Enables the Agent explorer view.
  </definition>
  <definition term="observability:apmAWSLambdaPriceFactor">
    Set the price per Gb-second for your AWS Lambda functions.
  </definition>
  <definition term="observability:apmAWSLambdaRequestCostPerMillion">
    Set the AWS Lambda cost per million requests.
  </definition>
  <definition term="observability:apmEnableContinuousRollups Elastic Stack: Beta">
    When continuous rollups are enabled, the UI will select metrics with the appropriate resolution. On larger time ranges, lower resolution metrics will be used, which will improve loading times.
  </definition>
  <definition term="observability:apmEnableServiceMetrics Elastic Stack: Beta">
    Enables the usage of service transaction metrics, which are low cardinality metrics that can be used by certain views like the service inventory for faster loading times.
  </definition>
  <definition term="observability:apmLabsButton">
    Enable or disable the APM Labs button — a quick way to enable and disable technical preview features in APM.
  </definition>
  <definition term="observability:apmServiceGroupMaxNumberOfServices">
    Limit the number of services in a given service group.
  </definition>
  <definition term="observability:apmDefaultServiceEnvironment">
    Set the default environment for APM. When left empty, data from all environments will be displayed by default.
  </definition>
  <definition term="observability:apmEnableProfilingIntegration">
    Enable the Universal Profiling integration in APM.
  </definition>
  <definition term="observability:enableComparisonByDefault">
    Enable the comparison feature by default.
  </definition>
  <definition term="observability:enableInspectEsQueries">
    When enabled, allows you to inspect Elasticsearch queries in API responses.
  </definition>
</definitions>


## APM Indices

The Applications UI uses data views to query APM indices. In non-serverless versions, change the default APM indices that the Applications UI queries by opening the Applications UI and select **Settings** → **Indices**. Index settings in the Applications UI take precedence over those set in [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings).
APM indices are Kibana Spaces-aware; Changes to APM index settings will only apply to the currently enabled space. See [Control access to APM data](https://www.elastic.co/docs/solutions/observability/apm/control-access-to-apm-data) for more information.

## APM Labs

**APM Labs** allows you to easily try out new features that are technical preview.
To enable APM labs, go to **Applications** → **Settings** → **General settings** and toggle **Enable labs button in APM**. Select **Save changes** and refresh the page.
After enabling **APM Labs** select **Labs** in the toolbar to see the technical preview features available to try out.