﻿---
title: Use the select metrics emitted directly to your monitoring cluster
description: In 8.11 and later, we emit a selected set of metrics directly to the monitoring cluster. The benefit of using local collection instead of internal collection...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/use-select-metrics-emitted-directly-to-monitoring-cluster
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Use the select metrics emitted directly to your monitoring cluster
In 8.11 and later, we emit a selected set of metrics directly to the monitoring cluster. The benefit of using local collection instead of internal collection is that the metrics are sent directly to your main monitoring index, making it easier to view shared data.

## The select metrics

We only ship a select list of metrics, to avoid overwhelming your monitoring cluster. If you need the entire set of metrics and traces we can expose, you should use [Self Instrumentation](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-apm-instrumentation) instead of local collection.
Here is the list of every metrics we currently expose:
- http.server.request.count
- http.server.request.duration
- http.server.response.valid.count
- http.server.response.errors.count
- http.server.errors.timeout
- http.server.errors.ratelimit
- grpc.server.request.count
- grpc.server.request.duration
- grpc.server.response.valid.count
- grpc.server.response.errors.count
- grpc.server.errors.timeout
- grpc.server.errors.ratelimit