﻿---
title: Set up APM Server
description: APM Server receives performance data from your APM agents and Elastic Distribution of OpenTelemetry (EDOT) SDKs, validates and processes it, and then...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/setup
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Set up APM Server
<tip>
  Just getting started?
  The fastest way to get started with Elastic APM is with Elastic Cloud Serverless.
  Read more in [Get started with traces and APM](https://www.elastic.co/docs/solutions/observability/apm/get-started).
</tip>

APM Server receives performance data from your APM agents and Elastic Distribution of OpenTelemetry (EDOT) SDKs, validates and processes it, and then transforms the data into Elasticsearch documents. If you’re on this page, then you’ve chosen to self-manage the Elastic Stack, and you now must decide how to run and configure the APM Server. There are two options, and the components required are different for each:
- [Fleet-managed APM Server](#apm-setup-fleet-managed-apm)
- [APM Server binary](#apm-setup-apm-server-binary)


## Fleet-managed APM Server

Fleet is a web-based UI in Kibana that is used to centrally manage Elastic Agents. In this deployment model, use Elastic Agent to spin up APM Server instances that can be centrally-managed in a custom-curated user interface.
![APM Server fleet overview](https://www.elastic.co/docs/solutions/images/observability-fm-ov.png)

**Pros**:
- Conveniently manage one, some, or many different integrations from one central Fleet UI.
- Centrally manage multiple APM Servers running on edge machines.

**Supported outputs**:
- Elasticsearch
- Elastic Cloud Hosted

<note>
  Fleet-managed APM Server does *not* support all the outputs that are supported by the APM Server binary method of running Elastic APM.
</note>

**Required components**:
- EDOT SDKs or APM agents
- Elastic Agent (which runs multiple subprocesses including APM Server, Fleet Server, and Elastic Stack)

**Configuration method**: Kibana UI

## APM Server binary

Install, configure, and run the APM Server binary wherever you need it.
![APM Server binary overview](https://www.elastic.co/docs/solutions/images/observability-bin-ov.png)

**Pros**:
- Simplest self-managed option
- No addition component knowledge required
- YAML configuration simplifies automation

**Supported outputs**:
- Elasticsearch
- Elastic Cloud Hosted
- Logstash
- Kafka
- Redis
- File
- Console

**Required components**:
- EDOT SDKs or APM agents
- APM Server
- Elastic Stack

**Configuration method**: YAML

## Help me decide

This decision tree highlights key factors to help you make an informed decision about implementing Elastic APM. It provides practical guidance and is not intended to serve as a comprehensive reference of all possible implementations and capabilities.
![APM decision tree](https://www.elastic.co/docs/solutions/images/observability-apm-help-me-decide.svg)