﻿---
title: Installation layout for Elastic APM Server
description: View the installation layout and default paths for both Fleet-managed APM Server and the APM Server binary. Elastic Agent files are installed in the following...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/installation-layout
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Installation layout for Elastic APM Server
View the installation layout and default paths for both Fleet-managed APM Server and the APM Server binary.

## Fleet-managed

Elastic Agent files are installed in the following locations. You cannot override these installation paths because they are required for upgrades.
<tab-set>
  <tab-item title="macOS">
    <definitions>
      <definition term="/Library/Elastic/Agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/Library/Elastic/Agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/Library/Elastic/Agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/Library/Elastic/Agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
    You can install Elastic Agent in a custom base path other than `/Library`.  When installing Elastic Agent with the `./elastic-agent install` command, use the `--base-path` CLI option to specify the custom base path.
  </tab-item>

  <tab-item title="Linux">
    <definitions>
      <definition term="/opt/Elastic/Agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/opt/Elastic/Agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/opt/Elastic/Agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/opt/Elastic/Agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
    You can install Elastic Agent in a custom base path other than `/opt`.  When installing Elastic Agent with the `./elastic-agent install` command, use the `--base-path` CLI option to specify the custom base path.
  </tab-item>

  <tab-item title="Windows">
    <definitions>
      <definition term="C:\Program Files\Elastic\Agent*">
        Elastic Agent program files
      </definition>
      <definition term="C:\Program Files\Elastic\Agent\elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="C:\Program Files\Elastic\Agent\fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="C:\Program Files\Elastic\Agent\data\elastic-agent-*\logs\elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
    </definitions>
    You can install Elastic Agent in a custom base path other than `C:\Program Files`.  When installing Elastic Agent with the `.\elastic-agent.exe install` command, use the `--base-path` CLI option to specify the custom base path.
  </tab-item>

  <tab-item title="DEB">
    <definitions>
      <definition term="/usr/share/elastic-agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/etc/elastic-agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/etc/elastic-agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/var/lib/elastic-agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
  </tab-item>

  <tab-item title="RPM">
    <definitions>
      <definition term="/usr/share/elastic-agent/*">
        Elastic Agent program files
      </definition>
      <definition term="/etc/elastic-agent/elastic-agent.yml">
        Main Elastic Agent configuration
      </definition>
      <definition term="/etc/elastic-agent/fleet.enc">
        Main Elastic Agent Fleet encrypted configuration
      </definition>
      <definition term="/var/lib/elastic-agent/data/elastic-agent-*/logs/elastic-agent.ndjson">
        Log files for Elastic Agent and Beats shippers[^1^](#footnote-1)
      </definition>
      <definition term="/usr/bin/elastic-agent">
        Shell wrapper installed into PATH
      </definition>
    </definitions>
  </tab-item>
</tab-set>


## APM Server binary

APM Server uses the following default paths unless you explicitly change them.
<tab-set>
  <tab-item title="ZIP, tar.gz, or TGZ">
    | Type   | Description                                      | Location              |
    |--------|--------------------------------------------------|-----------------------|
    | home   | Home of the APM Server installation.             | `{extract.path}`      |
    | bin    | The location for the binary files.               | `{extract.path}`      |
    | config | The location for configuration files.            | `{extract.path}`      |
    | data   | The location for persistent data files.          | `{extract.path}/data` |
    | logs   | The location for the logs created by APM Server. | `{extract.path}/logs` |
    For the ZIP, tar.gz, or TGZ distributions, these paths are based on the location of the extracted binary file. This means that if you start APM Server with the following simple command, all paths are set correctly:
    ```sh
    ./apm-server
    ```
  </tab-item>

  <tab-item title="Docker">
    | Type   | Description                                      | Location                     |
    |--------|--------------------------------------------------|------------------------------|
    | home   | Home of the APM Server installation.             | `/usr/share/apm-server`      |
    | bin    | The location for the binary files.               | `/usr/share/apm-server`      |
    | config | The location for configuration files.            | `/usr/share/apm-server`      |
    | data   | The location for persistent data files.          | `/usr/share/apm-server/data` |
    | logs   | The location for the logs created by APM Server. | `/usr/share/apm-server/logs` |
  </tab-item>

  <tab-item title="DEB & RPM">
    | Type   | Description                                      | Location                    |
    |--------|--------------------------------------------------|-----------------------------|
    | home   | Home of the APM Server installation.             | `/usr/share/apm-server`     |
    | bin    | The location for the binary files.               | `/usr/share/apm-server/bin` |
    | config | The location for configuration files.            | `/etc/apm-server`           |
    | data   | The location for persistent data files.          | `/var/lib/apm-server`       |
    | logs   | The location for the logs created by APM Server. | `/var/log/apm-server`       |
    For the deb and rpm distributions, these paths are set in the init script or in the systemd unit file.  Make sure that you start the APM Server service by using the preferred operating system method (init scripts or `systemctl`). Otherwise the paths might be set incorrectly.
  </tab-item>
</tab-set>

^1^  Logs file names end with a date (`YYYYMMDD`) and optional number: `elastic-agent-YYYYMMDD.ndjson`, `elastic-agent-YYYYMMDD-1.ndjson`, and so on as new files are created during rotation.