﻿---
title: APM Server information API
description: The APM Server exposes an API endpoint to query general server information. This lightweight endpoint is useful as a server up/down health check. This...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/information-api
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# APM Server information API
The APM Server exposes an API endpoint to query general server information. This lightweight endpoint is useful as a server up/down health check.

## Server Information endpoint

This is the server information endpoint:
```bash
http(s)://{hostname}:{port}/
```

Sending an `HTTP GET` request to the server information endpoint will return an HTTP 200, indicating that the server is up.
To configure authenticated access to the APM server, the instructions at [APM API key](https://www.elastic.co/docs/solutions/observability/apm/api-keys) or [APM Secret Token](https://www.elastic.co/docs/solutions/observability/apm/secret-token), must be followed to configure the correct permissions for APM access.
If an [API keys](https://www.elastic.co/docs/solutions/observability/apm/api-keys) or a [Secret token](https://www.elastic.co/docs/solutions/observability/apm/secret-token) is passed along with the `HTTP GET` request, in addition to an HTTP 200, the response payload will include some information about the APM server.

### Example: GET, without credentials

Example APM Server status request with GET, without credentials:
```sh
curl --verbose -X GET http://127.0.0.1:8200

*   Trying 127.0.0.1:8200...
* TCP_NODELAY set
* Connected to 127.0.0.1 (10.244.3.40) port 8200 (#0)
> GET / HTTP/1.1
> Host: 127.0.0.1:8200
> User-Agent: curl/7.68.0
> Accept: */*
>
* Mark bundle as not supporting multiuse
< HTTP/1.1 200 OK
< X-Content-Type-Options: nosniff
< Date: Tue, 17 Oct 2023 22:04:05 GMT
< Content-Length: 0
<
* Connection #0 to host 127.0.0.1 left intact
```


### Example: GET, with secret token

Example APM Server information request with GET, with a [Secret token](https://www.elastic.co/docs/solutions/observability/apm/secret-token):
```sh
curl -X GET http://127.0.0.1:8200/ \
  -H "Authorization: Bearer secret_token"

{
  "build_date": "2021-12-18T19:59:06Z",
  "build_sha": "24fe620eeff5a19e2133c940c7e5ce1ceddb1445",
  "publish_ready": true,
  "version": "9.0.0"
}
```