﻿---
title: High Availability
description: To achieve high availability you can place multiple instances of APM Server behind a regular HTTP load balancer, for example HAProxy or Nginx. The endpoint...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/high-availability
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# High Availability
To achieve high availability you can place multiple instances of APM Server behind a regular HTTP load balancer, for example HAProxy or Nginx.
The endpoint `/` always returns an `HTTP 200`. You can configure your load balancer to send HTTP requests to this endpoint to determine if an APM Server is running. See [APM Server information API](https://www.elastic.co/docs/solutions/observability/apm/apm-server/information-api) for more information on that endpoint.
In case of temporal issues, like unavailable Elasticsearch or a sudden high workload, APM Server does not have an internal queue to buffer requests, but instead leverages an HTTP request timeout to act as back-pressure.
If Elasticsearch goes down, the APM Server will eventually deny incoming requests. Both the APM Server and APM agent(s) will issue logs accordingly.
<tip>
  Fleet-managed APM Server users might also be interested in [Fleet/Agent proxy support](https://www.elastic.co/docs/reference/fleet/fleet-agent-proxy-support).
</tip>