﻿---
title: Configure Real User Monitoring (RUM)
description: The Real User Monitoring (RUM) agent captures user interactions with clients such as web browsers. These interactions are sent as events to the APM Server...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-real-user-monitoring-rum
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Configure Real User Monitoring (RUM)
<note>
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-yes.svg)Most options in this section are supported by all APM Server deployment methods.
</note>

The [Real User Monitoring (RUM) agent](https://www.elastic.co/docs/reference/apm/agents/rum-js) captures user interactions with clients such as web browsers. These interactions are sent as events to the APM Server. Because the RUM agent runs on the client side, the connection between agent and server is unauthenticated. As a security precaution, RUM is therefore disabled by default.
<important>
  To use RUM, you need a centralized APM Server, either running as standalone binary or managed through Fleet.
</important>

<tab-set>
  <tab-item title="APM Server binary">
    To enable RUM support, set `apm-server.rum.enabled` to `true` in your APM Server configuration file.Example config:
    ```yaml
    apm-server.rum.enabled: true
    apm-server.auth.anonymous.rate_limit.event_limit: 300
    apm-server.auth.anonymous.rate_limit.ip_limit: 1000
    apm-server.auth.anonymous.allow_service: [your_service_name]
    apm-server.rum.allow_origins: ['*']
    apm-server.rum.allow_headers: ["header1", "header2"]
    apm-server.rum.library_pattern: "node_modules|bower_components|~"
    apm-server.rum.exclude_from_grouping: "^/webpack"
    apm-server.rum.source_mapping.enabled: true
    apm-server.rum.source_mapping.cache.expiration: 5m
    apm-server.rum.source_mapping.elasticsearch.api_key: TiNAGG4BaaMdaH1tRfuU:KnR6yE41RrSowb0kQ0HWoA
    ```
  </tab-item>

  <tab-item title="Fleet-managed">
    To enable RUM, set [Enable RUM](#apm-rum-enable) to `true`.Configure and customize Fleet-managed APM settings directly in Kibana:
    1. In Kibana, find **Fleet** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Under the **Agent policies** tab, select the policy you would like to configure.
    3. Find the Elastic APM integration and select **Actions** > **Edit integration**.
    4. Look for these options under **Real User Monitoring**.
  </tab-item>
</tab-set>

In addition, if APM Server is deployed in an origin different than the page’s origin, you will need to configure [Cross-Origin Resource Sharing (CORS)](https://www.elastic.co/docs/reference/apm/agents/rum-js/configuring-cors) in the Agent.

## Configuration reference


### Enable RUM

To enable RUM support, set to `true`. By default this is disabled. (bool)

|                   |                          |
|-------------------|--------------------------|
| APM Server binary | `apm-server.rum.enabled` |
| Fleet-managed     | `Enable RUM`             |

<note>
  If an [API key](https://www.elastic.co/docs/solutions/observability/apm/api-keys) or [secret token](https://www.elastic.co/docs/solutions/observability/apm/secret-token) is configured, enabling RUM support will automatically enable [Anonymous authentication](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-anonymous-authentication). Anonymous authentication is required as the RUM agent runs in the browser.
</note>


### Allowed Origins

A list of permitted origins for RUM support. User-agents send an Origin header that will be validated against this list. This is done automatically by modern browsers as part of the [CORS specification](https://www.w3.org/TR/cors/). An origin is made of a protocol scheme, host and port, without the URL path.
Default: `['*']` (allows everything). (text)

|                   |                                |
|-------------------|--------------------------------|
| APM Server binary | `apm-server.rum.allow_origins` |
| Fleet-managed     | `Allowed Origins`              |


### Access-Control-Allow-Headers

HTTP requests made from the RUM agent to the APM Server are limited in the HTTP headers they are allowed to have. If any other headers are added, the request will be rejected by the browser due to Cross-Origin Resource Sharing (CORS) restrictions. Use this setting to allow additional headers. The default list of allowed headers includes "Content-Type", "Content-Encoding", and "Accept"; custom values configured here are appended to the default list and used as the value for the `Access-Control-Allow-Headers` header.
Default: `[]`. (text)

|                   |                                |
|-------------------|--------------------------------|
| APM Server binary | `apm-server.rum.allow_headers` |
| Fleet-managed     | `Access-Control-Allow-Headers` |


### Custom HTTP response headers

Custom HTTP headers to add to RUM responses. This can be useful for security policy compliance.
Values set for the same key will be concatenated.
Default: none. (text)

|                   |                                   |
|-------------------|-----------------------------------|
| APM Server binary | `apm-server.rum.response_headers` |
| Fleet-managed     | `Custom HTTP response headers`    |


### Library Frame Pattern

RegExp to be matched against a stack trace frame’s `file_name` and `abs_path` attributes. If the RegExp matches, the stack trace frame is considered to be a library frame. When source mapping is applied, the `error.culprit` is set to reflect the *function* and the *filename* of the first non library frame. This aims to provide an entry point for identifying issues.
Default: `"node_modules|bower_components|~"`. (text)

|                   |                                  |
|-------------------|----------------------------------|
| APM Server binary | `apm-server.rum.library_pattern` |
| Fleet-managed     | `Library Frame Pattern`          |


### Exclude from grouping

RegExp to be matched against a stack trace frame’s `file_name`. If the RegExp matches, the stack trace frame is excluded from being used for calculating error groups.
Default: `"^/webpack"` (excludes stack trace frames that have a filename starting with `/webpack`). (text)

|                   |                                        |
|-------------------|----------------------------------------|
| APM Server binary | `apm-server.rum.exclude_from_grouping` |
| Fleet-managed     | `Exclude from grouping`                |


## Source map configuration options

<admonition title="Admonition">
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-no.svg)Source maps are supported by all APM Server deployment methods, however, the options in this section are only supported by the APM Server binary.
</admonition>


### `source_mapping.enabled`

Used to enable/disable [source mapping](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/create-upload-source-maps-rum) for RUM events. When enabled, the APM Server needs additional privileges to read source maps. See [Use feature roles](/docs/solutions/observability/apm/create-assign-feature-roles-to-apm-server-users#apm-privileges-rum-source-mapping) for more details.
Default: `true`

### `source_mapping.elasticsearch`

Configure the Elasticsearch source map retrieval location, taking the same options as [output.elasticsearch](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-elasticsearch-output). This must be set when using an output other than Elasticsearch, and that output is writing to Elasticsearch. Otherwise leave this section empty.

### `source_mapping.cache.expiration`

If a source map has been uploaded to the APM Server, [source mapping](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/create-upload-source-maps-rum) is automatically applied to documents sent to the RUM endpoint. Source maps are fetched from Elasticsearch and then kept in an in-memory cache for the configured time. Values configured without a time unit are treated as seconds.
Default: `5m` (5 minutes)

### `source_mapping.index_pattern`

Previous versions of APM Server stored source maps in `apm-%{[observer.version]}-sourcemap` indices. Search source maps stored in an older version with this setting.
Default: `"apm-*-sourcemap*"`

## Ingest pipelines

The default APM Server pipeline includes processors that enrich RUM data prior to indexing in Elasticsearch. See [Parse data using ingest pipelines](https://www.elastic.co/docs/solutions/observability/apm/parse-data-using-ingest-pipelines) for details on how to locate, edit, or disable this preprocessing.