﻿---
title: Configure project paths
description: The path section of the apm-server.yml config file contains configuration options that define where APM Server looks for its files. For example, APM Server...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-project-paths
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Configure project paths
<note>
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-no.svg)This documentation is only relevant for APM Server binary users. Fleet-managed paths are defined in [Installation layout](https://www.elastic.co/docs/solutions/observability/apm/apm-server/installation-layout).
</note>

The `path` section of the `apm-server.yml` config file contains configuration options that define where APM Server looks for its files. For example, APM Server looks for the Elasticsearch template file in the configuration path and writes log files in the logs path.
See the [Installation layout](https://www.elastic.co/docs/solutions/observability/apm/apm-server/installation-layout) section for more details.
Here is an example configuration:
```yaml
path.home: /usr/share/beat
path.config: /etc/beat
path.data: /var/lib/beat
path.logs: /var/log/
```

Note that it is possible to override these options by using command line flags.

## Configuration options

You can specify the following options in the `path` section of the `apm-server.yml` config file:

### `home`

The home path for the APM Server installation. This is the default base path for all other path settings and for miscellaneous files that come with the distribution (for example, the sample dashboards). If not set by a CLI flag or in the configuration file, the default for the home path is the location of the APM Server binary.
Example:
```yaml
path.home: /usr/share/beats
```


### `config`

The configuration path for the APM Server installation. This is the default base path for configuration files, including the main YAML configuration file and the Elasticsearch template file. If not set by a CLI flag or in the configuration file, the default for the configuration path is the home path.
Example:
```yaml
path.config: /usr/share/beats/config
```


### `data`

The data path for the APM Server installation. This is the default base path for all the files in which APM Server needs to store its data. If not set by a CLI flag or in the configuration file, the default for the data path is a `data` subdirectory inside the home path.
Example:
```yaml
path.data: /var/lib/beats
```

<tip>
  When running multiple APM Server instances on the same host, make sure they each have a distinct `path.data` value.
</tip>


### `logs`

The logs path for a APM Server installation. This is the default location for APM Server’s log files. If not set by a CLI flag or in the configuration file, the default for the logs path is a `logs` subdirectory inside the home path.
Example:
```yaml
path.logs: /var/log/beats
```


### `system.hostfs`

Specifies the mount point of the host’s file system for use in monitoring a host. This can either be set in the config, or with the `--system.hostfs` CLI flag. This is used for cgroup self-monitoring.
Example:
```yaml
system.hostfs: /mount/rootfs
```