﻿---
title: Configure the output
description: Output configuration options. Elastic Cloud Hosted, Elasticsearch, Logstash, Kafka, Redis, Console. Source maps can be uploaded through all outputs but...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-output
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Configure the output
Output configuration options.
- [Elastic Cloud Hosted](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-output-for-elasticsearch-service-on-elastic-cloud)
- [Elasticsearch](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-elasticsearch-output)
- [Logstash](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-logstash-output)
- [Kafka](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-kafka-output)
- [Redis](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-redis-output)
- [Console](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-console-output)


## Source maps

Source maps can be uploaded through all outputs but must eventually be stored in Elasticsearch. When using outputs other than Elasticsearch, `source_mapping.elasticsearch` must be set for source maps to be applied. Be sure to update `source_mapping.index_pattern` if source maps are stored in the non-default location. See [`source_mapping.elasticsearch`](/docs/solutions/observability/apm/apm-server/configure-real-user-monitoring-rum#apm-config-sourcemapping-elasticsearch) for more details.