﻿---
title: Configure the output for Elastic Cloud Hosted
description: APM Server comes with two settings that simplify the output configuration when used together with Elastic Cloud Hosted. When defined, these setting overwrite...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-output-for-elasticsearch-service-on-elastic-cloud
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Configure the output for Elastic Cloud Hosted
<note>
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-no.svg)This documentation only applies to APM Server binary users.
</note>

<note>
  This page refers to using a separate instance of APM Server with an existing [Elastic Cloud Hosted deployment](https://www.elastic.co/cloud/elasticsearch-service?page=docs&placement=docs-body). If you want to use APM on Elastic Cloud Hosted, see: [Create your deployment](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/create-an-elastic-cloud-hosted-deployment) and [Add APM user settings](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure).
</note>

APM Server comes with two settings that simplify the output configuration when used together with [Elastic Cloud Hosted](https://www.elastic.co/cloud/elasticsearch-service?page=docs&placement=docs-body). When defined, these setting overwrite settings from other parts in the configuration.
Example:
```yaml
cloud.id: "staging:dXMtZWFzdC0xLmF3cy5mb3VuZC5pbyRjZWM2ZjI2MWE3NGJmMjRjZTMzYmI4ODExYjg0Mjk0ZiRjNmMyY2E2ZDA0MjI0OWFmMGNjN2Q3YTllOTYyNTc0Mw=="
cloud.auth: "elastic:YOUR_PASSWORD"
```

These settings can be also specified at the command line, like this:
```sh
apm-server -e -E cloud.id="<cloud-id>" -E cloud.auth="<cloud.auth>"
```


## `cloud.id`

The Cloud ID, which can be found in the Elastic Cloud Console, is used by APM Server to resolve the Elasticsearch and Kibana URLs. This setting overwrites the `output.elasticsearch.hosts` and `setup.kibana.host` settings.

## `cloud.auth`

When specified, the `cloud.auth` overwrites the `output.elasticsearch.username` and `output.elasticsearch.password` settings. Because the Kibana settings inherit the username and password from the Elasticsearch output, this can also be used to set the `setup.kibana.username` and `setup.kibana.password` options.