﻿---
title: Configure APM instrumentation
description: APM Server uses the Elastic APM Go Agent to instrument its publishing pipeline. To gain insight into the performance of APM Server, you can enable this...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-apm-instrumentation
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Configure APM instrumentation
<note>
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-no.svg)Instrumentation of APM Server is not yet supported for Fleet-managed APM.
</note>

APM Server uses the Elastic APM Go Agent to instrument its publishing pipeline. To gain insight into the performance of APM Server, you can enable this instrumentation and send trace data to APM Server. Currently, only the Elasticsearch output is instrumented.
Example configuration with instrumentation enabled:
```yaml
instrumentation:
  enabled: true
  environment: production
  hosts:
    - "http://localhost:8200"
  api_key: L5ER6FEvjkmlfalBealQ3f3fLqf03fazfOV
```


## Configuration options

You can specify the following options in the `instrumentation` section of the `apm-server.yml` config file:

### `enabled`

Set to `true` to enable instrumentation of APM Server. Defaults to `false`.

### `environment`

Set the environment in which APM Server is running, for example, `staging`, `production`, `dev`, etc. Environments can be filtered in the [Kibana Applications UI](https://www.elastic.co/docs/solutions/observability/apm/overviews).

### `hosts`

The [APM Server](https://www.elastic.co/docs/solutions/observability/apm/get-started) hosts to report instrumentation data to. Defaults to `http://localhost:8200`.

### `api_key`

[API key](https://www.elastic.co/docs/solutions/observability/apm/api-keys) used to secure communication with the APM Server(s). If `api_key` is set then `secret_token` will be ignored.

### `secret_token`

[Secret token](https://www.elastic.co/docs/solutions/observability/apm/secret-token) used to secure communication with the APM Server(s).