﻿---
title: Configure APM Agent Central Configuration
description: APM Agent Central Configuration allows you to fine-tune your APM agents from within the Applications UI. Changes are automatically propagated to your...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-central-configuration
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Configure APM Agent Central Configuration
<note>
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-yes.svg)APM agent central configuration is supported by all APM Server deployment methods, but some options are only supported for APM Server binary users.
</note>

APM Agent Central Configuration allows you to fine-tune your APM agents from within the Applications UI. Changes are automatically propagated to your agents, so there’s no need to redeploy your applications.
To learn more about this feature, see [APM Agent Central Configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/central-configuration).
<note>
  To configure EDOT SDKs through APM Agent Central Configuration, refer to [EDOT SDKs Central Configuration](https://www.elastic.co/docs/reference/opentelemetry/central-configuration).
</note>


## APM agent configuration options

**The following options are only supported for APM Server binary users**.
You can specify APM agent configuration options in the `apm-server.agent.config` section of the `apm-server.yml` config file. Here’s a sample configuration:
```yaml
apm-server.agent.config.cache.expiration: 45s
apm-server.agent.config.elasticsearch.api_key: TiNAGG4BaaMdaH1tRfuU:KnR6yE41RrSowb0kQ0HWoA 
```


### `apm-server.agent.config.cache.expiration`

When using APM agent central configuration, information fetched from Elasticsearch will be cached in memory for some time. Specify the cache expiration time via this setting. Defaults to `30s` (30 seconds).

### `apm-server.agent.config.elasticsearch`

Takes the same options as [output.elasticsearch](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure-elasticsearch-output).
For APM Server binary users and Elastic Agent standalone-managed APM Server, APM agent central configuration is automatically fetched from Elasticsearch using the `output.elasticsearch` configuration. If `output.elasticsearch` isn’t set or doesn’t have sufficient privileges, use these Elasticsearch options to provide Elasticsearch access.

### Common problems


#### HTTP 403 errors

You may see either of the following HTTP 403 errors from APM Server when it attempts to fetch the APM agent central configuration:
APM agent log:
```txt
"Your Elasticsearch configuration does not support agent config queries. Check your configurations at `output.elasticsearch` or `apm-server.agent.config.elasticsearch`."
```

APM Server log:
```txt
rejecting fetch request: no valid elasticsearch config
```

This occurs because the user or API key set in either `apm-server.agent.config.elasticsearch` or `output.elasticsearch` (if `apm-server.agent.config.elasticsearch` is not set) does not have adequate permissions to read source maps from Elasticsearch.
To fix this error, ensure that APM Server has all the required privileges. For more details, refer to [Create a *central configuration management* role](/docs/solutions/observability/apm/create-assign-feature-roles-to-apm-server-users#apm-privileges-agent-central-config-server).

#### HTTP 401 errors

If you get an HTTP 401 error from APM Server, make sure that you’re using an API key that is configured to **Beats**. For details on how to create and configure a compatible API key, refer to [Create an API key for writing events](/docs/solutions/observability/apm/grant-access-using-api-keys#apm-beats-api-key-publish).