﻿---
title: APM agent authorization
description: Agent authorization APM Server configuration options. These settings apply to API key communication between the APM Server and APM Agents. Enable API...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-authorization
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# APM agent authorization
<note>
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-yes.svg)Most options in this section are supported by all APM Server deployment methods.
</note>

Agent authorization APM Server configuration options.
<tab-set>
  <tab-item title="APM Server binary">
    **Example config file:**
    ```yaml
    apm-server:
      auth:
        api_key:
          enabled: true
          limit: 100
          token: "your_secret_token"
    ```
  </tab-item>

  <tab-item title="Fleet-managed">
    Configure and customize Fleet-managed APM settings directly in Kibana:
    1. In Kibana, find **Fleet** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Under the **Agent policies** tab, select the policy you would like to configure.
    3. Find the Elastic APM integration and select **Actions** > **Edit integration**.
    4. Look for these settings under **Agent authorization**.
  </tab-item>
</tab-set>


## API key authentication options

These settings apply to API key communication between the APM Server and APM Agents.
<note>
  These settings are different from the API key settings used for Elasticsearch output and monitoring.
</note>


### API key for agent authentication

Enable API key authorization by setting `enabled` to `true`. By default, `enabled` is set to `false`, and API key support is disabled. (bool)

|                   |                                    |
|-------------------|------------------------------------|
| APM Server binary | `apm-server.auth.api_key.enabled`  |
| Fleet-managed     | `API key for agent authentication` |

<tip>
  Not using Elastic APM agents? When enabled, third-party APM agents must include a valid API key in the following format: `Authorization: ApiKey <token>`. The key must be the base64 encoded representation of the API key’s `id:name`.
</tip>


### API key limit

Each unique API key triggers one request to Elasticsearch. This setting restricts the number of unique API keys are allowed per minute. The minimum value for this setting should be the number of API keys configured in your monitored services. The default `limit` is `100`. (int)

|                   |                                 |
|-------------------|---------------------------------|
| APM Server binary | `apm-server.auth.api_key.limit` |
| Fleet-managed     | `Number of keys`                |


### Secret token

Authorization token for sending APM data. The same token must also be set in each APM agent. This token is not used for RUM endpoints. (text)

|                   |                                 |
|-------------------|---------------------------------|
| APM Server binary | `apm-server.auth.api_key.token` |
| Fleet-managed     | `Secret token`                  |


## `apm-server.auth.api_key.elasticsearch.*` configuration options

<note>
  ![supported deployment methods](https://www.elastic.co/docs/solutions/images/observability-binary-yes-fm-no.svg)The below options are only supported by the APM Server binary.All of the `apm-server.auth.api_key.elasticsearch.*` configurations are optional. If none are set, configuration settings from the `apm-server.output` section will be reused.
</note>


### `elasticsearch.hosts`

API keys are fetched from Elasticsearch. This configuration needs to point to a secured Elasticsearch cluster that is able to serve API key requests.

### `elasticsearch.protocol`

The name of the protocol Elasticsearch is reachable on. The options are: `http` or `https`. The default is `http`. If nothing is configured, configuration settings from the `output` section will be reused.

### `elasticsearch.path`

An optional HTTP path prefix that is prepended to the HTTP API calls. If nothing is configured, configuration settings from the `output` section will be reused.

### `elasticsearch.proxy_url`

The URL of the proxy to use when connecting to the Elasticsearch servers. The value may be either a complete URL or a "host[:port]", in which case the "http"scheme is assumed. If nothing is configured, configuration settings from the `output` section will be reused.

### `elasticsearch.timeout`

The HTTP request timeout in seconds for the Elasticsearch request. If nothing is configured, configuration settings from the `output` section will be reused.

## `apm-server.auth.api_key.elasticsearch.ssl.*` configuration options

SSL is off by default. Set `elasticsearch.protocol` to `https` if you want to enable `https`.

### `elasticsearch.ssl.enabled`

Enable custom SSL settings. Set to false to ignore custom SSL settings for secure communication.

### `elasticsearch.ssl.verification_mode`

Configure SSL verification mode. If `none` is configured, all server hosts and certificates will be accepted. In this mode, SSL based connections are susceptible to man-in-the-middle attacks. **Use only for testing**. Default is `full`.

### `elasticsearch.ssl.supported_protocols`

List of supported/valid TLS versions. The default value is `[TLSv1.1, TLSv1.2, TLSv1.3]`.

### `elasticsearch.ssl.certificate_authorities`

List of root certificates for HTTPS server verifications.

### `elasticsearch.ssl.certificate`

The path to the certificate for SSL client authentication.

### `elasticsearch.ssl.key`

The client certificate key used for client authentication. This option is required if certificate is specified.

### `elasticsearch.ssl.key_passphrase`

An optional passphrase used to decrypt an encrypted key stored in the configured key file.

### `elasticsearch.ssl.cipher_suites`

The list of cipher suites to use. The first entry has the highest priority. If this option is omitted, the Go crypto library’s default suites are used (recommended).

### `elasticsearch.ssl.curve_types`

The list of curve types for ECDHE (Elliptic Curve Diffie-Hellman ephemeral key exchange).

### `elasticsearch.ssl.renegotiation`

Configure what types of renegotiation are supported. Valid options are `never`, `once`, and `freely`. Default is `never`.
- `never` - Disables renegotiation.
- `once` - Allows a remote server to request renegotiation once per connection.
- `freely` - Allows a remote server to repeatedly request renegotiation.