﻿---
title: Work with APM Server
description: When self-managing the Elastic Stack, APM Server receives performance data from APM agents, validates and processes it, and transforms the data into Elasticsearch...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-server
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Work with APM Server
When self-managing the Elastic Stack, APM Server receives performance data from APM agents,
validates and processes it, and transforms the data into Elasticsearch documents.
This section contains information on working with APM Server including:
- Learning how to [set up APM Server](https://www.elastic.co/docs/solutions/observability/apm/apm-server/setup)
- Browsing all available [APM Server configuration options](https://www.elastic.co/docs/solutions/observability/apm/apm-server/configure)
- [Monitoring the real-time health and performance](https://www.elastic.co/docs/solutions/observability/apm/apm-server/monitor) of your APM Server

<tip>
  If you're using Elastic Cloud Serverless, there is no APM Server running. Instead the _managed intake service_ receives and transforms data. Read more in [Get started with traces and APM](https://www.elastic.co/docs/solutions/observability/apm/get-started).
</tip>