﻿---
title: APM Agent Central Configuration
description: APM Agent Central Configuration allows you to fine-tune your APM agents from within the Applications UI. Changes are automatically propagated to your...
url: https://www.elastic.co/docs/solutions/observability/apm/apm-agents/central-configuration
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# APM Agent Central Configuration
APM Agent Central Configuration allows you to fine-tune your APM agents from within the Applications UI. Changes are automatically propagated to your agents, so there’s no need to redeploy.
To get started, select the services and environments you want to configure. The Applications UI lets you know when your APM agents have applied your configurations.
![APM central configuration in Kibana](https://www.elastic.co/docs/solutions/images/observability-apm-agent-configuration.png)

<important>
  To configure EDOT SDKs through APM Agent Central Configuration, refer to [EDOT SDKs Central Configuration](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/edot-sdks-central-configuration).
</important>


## Precedence

Configurations set from the Applications UI take precedence over configurations set locally in each APM agent or EDOT SDK. However, if APM Server is slow to respond, is offline, reports an error, etc., agents and SDKs will use local defaults until they’re able to update the configuration. For this reason, it is still essential to set custom default configurations locally in each of your APM agents and EDOT SDKs.

## Supported configurations

Each APM agent has a list of supported configurations. After selecting a Service name and environment in the Applications UI, a list of all supported configuration options, including descriptions and default values, will be displayed.
Supported configurations are also tagged with the ![dynamic config](https://www.elastic.co/docs/solutions/images/observability-dynamic-config.svg) badge in each APM agent’s configuration reference:
<definitions>
  <definition term="Android agent">
    [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android/configuration)
  </definition>
  <definition term="Go agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/go/configuration)
  </definition>
  <definition term="iOS agent">
    [Configuration reference](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios/configuration)
  </definition>
  <definition term="Java agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/java/configuration)
  </definition>
  <definition term=".NET agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/dotnet/configuration)
  </definition>
  <definition term="Node.js agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/nodejs/configuration)
  </definition>
  <definition term="PHP agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/php/configuration)
  </definition>
  <definition term="Python agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/python/configuration)
  </definition>
  <definition term="Ruby agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/ruby/configuration)
  </definition>
  <definition term="Real User Monitoring (RUM) agent">
    [Configuration reference](https://www.elastic.co/docs/reference/apm/agents/rum-js/configuration)
  </definition>
</definitions>


## APM Server configuration

For most users, APM agent configuration should work out-of-the-box. If you run into trouble, it may be because you’re not using the Elasticsearch output, or because your Elasticsearch credentials don’t have sufficient privileges.
Refer to [configure APM agent configuration](https://www.elastic.co/docs/solutions/observability/apm/apm-server/apm-agent-central-configuration) to learn how to configure APM Server to avoid these problems.
<note>
  You can't configure APM agents through the EDOT Collector. Use APM Server for that purpose.
</note>