﻿---
title: APM APIs
description: There are two kinds of APIs related to Elastic APM: 
url: https://www.elastic.co/docs/solutions/observability/apm/apis
products:
  - APM
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# APM APIs
<admonition title="APM Server vs managed intake service">
  In Elastic Cloud Hosted, the _APM Server_ receives data from Elastic APM agents and transforms it into Elasticsearch documents. In Elastic Cloud Serverless there is in fact no APM Server running, instead the _managed intake service_ receives and transforms data.
</admonition>

There are two kinds of APIs related to Elastic APM:

|                                                                                                                                 |                                                                                                                                                                                                                 |
|---------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [APM UI API](https://www.elastic.co/docs/solutions/observability/apm/apm-ui-api)                                                | Kibana APIs specific to working with the Applications UI including updating configuration options,  uploading real user monitoring (RUM) source maps, adding annotations, and more.                             |
| [APM Server API](https://www.elastic.co/docs/solutions/observability/apm/apm-server/api)                                        | APIs for working with APM Server. These are mainly intake APIs that accept data from APM agents and are used primarily by APM agent developers.                                                                 |
| [Observability Intake Serverless API](https://www.elastic.co/docs/solutions/observability/apm/managed-intake-service-event-api) | The managed intake service exposes an API endpoint to query general server information. This lightweight endpoint is useful as a server up/down health check. This API is exclusively for APM agent developers. |