﻿---
title: Agent Builder for Observability
description: Learn how Elastic Agent Builder works with Elastic Observability
url: https://www.elastic.co/docs/solutions/observability/ai/agent-builder-observability
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Preview
  - Elastic Stack: Preview since 9.3
---

# Agent Builder for Observability
[Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder) is Elastic's AI platform which includes a natural language chat interface, built-in agents and Elastic tools, and allows creating custom agents and tools for your use case. You can manage and interact with your agents using the Kibana UI or work programmatically.
Agent Builder integrates tightly with Observability, shipping with built-in agents and tools designed for observability use cases, and you can create your own custom agents and tools to fit your specific needs. Combine your agents with [Elastic Workflows](https://www.elastic.co/docs/explore-analyze/workflows) to automatically isolate hosts, create cases, send notification messages to external platforms, and more.
<note applies-to="Elastic Cloud Serverless: Preview, Elastic Stack: Preview since 9.3">
  To use Agent Builder in Observability, you need to [opt in](https://www.elastic.co/docs/explore-analyze/ai-features/ai-chat-experiences/ai-agent-or-ai-assistant).
</note>


## Observability agent

Agent Builder features a built-in [Observability agent](/docs/explore-analyze/ai-features/agent-builder/builtin-agents-reference#observability-agent) designed to assist with infrastructure monitoring and application performance troubleshooting.
By default it includes the [platform core tools](/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference#platform-core-tools) and [Observability tools](/docs/explore-analyze/ai-features/agent-builder/tools/builtin-tools-reference#observability-tools). You can [clone the agent](/docs/explore-analyze/ai-features/agent-builder/custom-agents#create-a-new-agent) to create a version with access to additional built-in or custom tools. To learn more about the available tools, refer to [Create and manage custom tools in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/custom-tools).

## Use Agent Builder and Workflows together

[Workflows](https://www.elastic.co/docs/explore-analyze/workflows) is an automation engine built into the Elastic platform. You can define workflows declaratively in YAML to create deterministic, event-driven automation, without building custom integrations or switching context from your Elastic environment. Combined with Agent Builder, Workflows enable you to:
- Reduce alert fatigue by automating responses to reduce manual triage
- Automate routine tasks
- Eliminate the need for external automation tools

Workflows are tightly integrated with Agent Builder functionalities:
- **Agents can trigger workflows** to take reliable, repeatable actions. For more information, refer to [Workflow tools in Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/tools/workflow-tools).
- **Workflows can call agents** when a step benefits from reasoning, language understanding, or other LLM capabilities. For more information, refer to [Steps](https://www.elastic.co/docs/explore-analyze/workflows/steps).


## Examples: Agent Builder and Elastic Workflows

For specific examples of workflows, including complete annotated code samples, refer to the [elastic/workflows/observability](https://github.com/elastic/workflows/tree/main/workflows/observability) GitHub repo.

## Related resources

- [AI chat experiences](https://www.elastic.co/docs/explore-analyze/ai-features/ai-chat-experiences)
- [Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder)
- [Workflows](https://www.elastic.co/docs/explore-analyze/workflows)