﻿---
title: Find connection details
description: To connect to your Elasticsearch deployment, you need either a Cloud ID or an Elasticsearch endpoint, depending on your deployment type. For secure connections,...
url: https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-connection-details
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Find connection details
To connect to your Elasticsearch deployment, you need either a Cloud ID or an Elasticsearch endpoint, depending on your deployment type. For secure connections, we recommend using an API key for authentication.
The following sections describe how to find your Cloud ID and create API keys in both Elastic Cloud and Serverless deployments.

## Elastic Cloud and self-hosted deployments


### Find your Cloud ID

1. Go to the Elastic Cloud home page.
2. In the main menu, select **Manage this deployment**.
   ![manage deployment](https://www.elastic.co/docs/solutions/images/kibana-manage-deployment.png)
3. The Cloud ID is displayed on the right side of the page.
   ![cloud id](https://www.elastic.co/docs/solutions/images/kibana-cloud-id.png)


### Create an API key

1. To navigate to **API keys**, use the [**global search bar**](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
   ![api keys search bar](https://www.elastic.co/docs/solutions/images/kibana-api-keys-search-bar.png)
2. Select **Create API key**.
   ![click create api key](https://www.elastic.co/docs/solutions/images/kibana-click-create-api-key.png)
3. Enter the API key details, and select **Create API key**.
4. Copy and securely store the API key, because it only appears once.


## Serverless deployments


### Find your Elasticsearch endpoint

1. Select the Help icon in the top right corner and then select **Connection Details**.
2. Copy the **Elasticsearch endpoint** from the **Endpoints** tab.
   ![serverless connection details](https://www.elastic.co/docs/solutions/images/kibana-serverless-connection-details.png)

<note>
  The **Cloud ID** is also available in the **Connection Details** section. Toggle the **Show Cloud ID** option to view it.
</note>


### Create an API key

1. Go to the serverless project’s home page.
2. Select **Create API key**.
   ![serverless create an api key](https://www.elastic.co/docs/solutions/images/kibana-serverless-create-an-api-key.png)
3. Enter the API key details, and select **Create API key**.
4. Copy and securely store the API key, because it only appears once.


### Test connection

Use [`curl`](https://curl.se) to verify your connection to Elasticsearch.
In a terminal, assign the Elasticsearch endpoint and `encoded` API key to the `ES_URL` and `API_KEY` environment variables respectively. `curl` needs access to these values.
For example:
```bash
export ES_URL="https://dda7de7f1d264286a8fc9741c7741690.es.us-east-1.aws.elastic.cloud:443"
export API_KEY="ZFZRbF9Jb0JDMEoxaVhoR2pSa3Q6dExwdmJSaldRTHFXWEp4TFFlR19Hdw=="
```

Next, run the following command to test your connection:
```bash
curl "${ES_URL}" \
  -H "Authorization: ApiKey ${API_KEY}" \
  -H "Content-Type: application/json"
```

You should receive a response similar to the following:
```json
{
  "name" : "serverless",
  "cluster_name" : "dda7de7f1d264286a8fc9741c7741690",
  "cluster_uuid" : "ws0IbTBUQfigmYAVMztkZQ",
  "version" : { ... },
  "tagline" : "You Know, for Search"
}
```

Now you’re ready to start adding data to your Elasticsearch Serverless project.