﻿---
title: Search Applications
description: Search Applications enable users to build search-powered applications that leverage the full power of Elasticsearch and its Query DSL, with a simplified...
url: https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-applications
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Beta
  - Elastic Stack: Beta
---

# Search Applications
<important>
  Search Applications is a beta feature and is not recommended for new users in Elasticsearch 9.x. Beta features are subject to change and are not covered by the support SLA of general release (GA) features.
</important>

*Search Applications* enable users to build search-powered applications that leverage the full power of Elasticsearch and its Query DSL, with a simplified user experience. Create search applications based on your Elasticsearch indices, build queries using search templates, and easily preview your results directly in the Kibana Search UI.
You can also interact with your search applications using the [Search Application APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-search_application). Search Applications are designed to simplify building unified search experiences across a range of enterprise search use cases, using the Elastic platform.
<admonition title="Search Applications documentation">
  Documentation for the Search Applications feature lives in two places:
  - The documentation in this section covers the basics of Search Applications, information about working with Search Applications in the Kibana UI, and use case examples.
  - The [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-search_application) contains the API references for working with Search Applications programmatically. Jump there if you’re only interested in the APIs.
</admonition>


## Availability and prerequisites

The Search Applications feature was introduced in Elastic version **8.8.0**.
This feature is available to all **Elastic Cloud Hosted** deployments.
This feature is also available to **self-managed** deployments when Elastic subscription requirements are satisfied. View the requirements for this feature under the **Elastic Search** section of the [Elastic Stack subscriptions](https://www.elastic.co/subscriptions) page.
For Serverless users, this is an API-only feature. You can create and manage search applications using the [Search Application APIs](https://www.elastic.co/docs/api/doc/elasticsearch-serverless/group/endpoint-search_application).
Your deployment must include the Elasticsearch and Kibana services.
Managing search applications requires the `manage_search_application` cluster privilege, and also requires the `manage` [index privilege](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices) on all indices associated with the search application.

## Overview

The Elasticsearch [Query DSL](https://www.elastic.co/docs/explore-analyze/query-filter/languages/querydsl) is powerful and flexible, but it comes with a steep learning curve. Complex queries are verbose and hard to understand for non-experts. We’ve designed search applications to be easier to search over, but with the flexibility of working with an Elasticsearch index.
Search Applications use [search templates](https://www.elastic.co/docs/solutions/search/search-templates) to simplify the process of building queries. Templates are defined when creating a search application, and can be customized according to your needs. Read [Search API and templates](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-applications/search-application-api) for the details.

## Get started


### Option 1: Get started in the UI

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

<warning applies-to="Elastic Stack: Unavailable since 9.2">
  This feature is unavailable for new users and is hidden from the navigation menu. It remains accessible for users who started using the feature before 9.2.
</warning>

You can create build, and manage your search applications directly in the Kibana UI under **Search**. Make sure you have at least one Elasticsearch index to work with on your deployment. The indices underlying your search application are searched together, similar to how an [alias](https://www.elastic.co/docs/manage-data/data-store/aliases) searches over multiple indices.
To create a new search application in Kibana:
1. Go to **Search > Search Applications**.
2. Select **Create**.
3. Select the Elasticsearch indices you want to use for your search application.
4. Name your search application.
5. Select **Create**.

Your search application should now be available in the list.
Once created, you can explore the documents in your search application under **Search > Search Applications >** *your-search-application* > **Docs Explorer**. From there, you can expand a matching Elasticsearch document to see its full contents.

### Option 2: Get started with the API

Use the Elasticsearch [Put Search Application API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search-application-put) to create a search application.
The following example creates a search application named `my_search_application` that searches over the `my_search_index1` and `my_search_index2` indices, along with defining a basic search template (Refer to [Default template example](/docs/solutions/elasticsearch-solution-project/search-applications/search-application-api#search-application-api-default-template)).
```json

{
  "indices": [ "my_search_index1", "my_search_index2" ],
  "template": {
    "script": {
      "source": {
        "query": {
          "query_string": {
            "query": "{{query_string}}",
            "default_field": "{{default_field}}"
          }
        }
      },
      "params": {
        "query_string": "*",
        "default_field": "*"
      }
    }
  }
}
```


### Search templates

Search templates are the heart of your search applications. The [default template](/docs/solutions/elasticsearch-solution-project/search-applications/search-application-api#search-application-api-default-template) created for a search application is minimal, and you'll want to customize it to suit your needs. [Search API and templates](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/search-applications/search-application-api) contains a number of examples to get you started, including the default template, as well as templates for text search, semantic search and hybrid search.