﻿---
title: Troubleshooting RAG Playground
description: 
url: https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground-troubleshooting
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Beta
  - Elastic Stack: Beta since 9.1, Preview in 9.0
---

# Troubleshooting RAG Playground
<definitions>
  <definition term="Dense vectors are not searchable">
    Embeddings must be generated using the [inference processor](https://www.elastic.co/docs/reference/enrich-processor/inference-processor) with an ML node.
  </definition>
  <definition term="Context length error">
    You’ll need to adjust the size of the context you’re sending to the model. Refer to [Optimize model context](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground-context).
  </definition>
  <definition term="LLM credentials not working">
    Under **LLM settings**, use the `wrench` button to edit your GenAI connector settings.
  </definition>
  <definition term="Poor answer quality">
    Check the retrieved documents to verify if they are valid. Adjust your Elasticsearch queries to improve the relevance of the documents retrieved. Refer to [View and modify queries](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground-query).
    You can update the initial instructions to be more detailed. This is called *prompt engineering*. Refer to this [OpenAI guide](https://platform.openai.com/docs/guides/prompt-engineering) for more information.
    You might need to click **⟳ Clear chat** to clear chat history and start a new conversation. If you mix topics, the model will find it harder to generate relevant responses.
  </definition>
</definitions>