﻿---
title: View and modify queries
description: Once you've set up your chat interface, you can start chatting with the model. Playground automatically generates Elasticsearch queries based on your...
url: https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground-query
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Beta
  - Elastic Stack: Beta since 9.1, Preview in 9.0
---

# View and modify queries
Once you've set up your chat interface, you can start chatting with the model. Playground automatically generates Elasticsearch queries based on your questions, and retrieves the most relevant documents from your Elasticsearch indices. The Playground UI enables you to view and modify these queries.
- Select the **Query** tab to open the visual query editor.
- Modify the query by selecting fields to query per index.

<tip>
  The `{{query}}` variable represents the user’s question, rewritten as an Elasticsearch query.
</tip>

The following screenshot shows the query editor in the Playground UI. In this basic example, the `books` index has two fields: `author` and `name`. Selecting a field adds it to the `fields` array in the query.
![View and modify queries](https://www.elastic.co/docs/solutions/images/kibana-query-interface.png)

Certain fields in your documents might be hidden. Learn more about [hidden fields](#playground-hidden-fields).

## Improving relevance

The fields you select in the query editor determine the relevance of the retrieved documents.
Remember that the next step in the workflow is to send the retrieved documents to the LLM to answer the question. Context length is an important factor in ensuring the model has enough information to generate a relevant answer. Refer to [Optimize context](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground-context) for more information.
[Troubleshooting](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground-troubleshooting) provides tips on how to diagnose and fix relevance issues.
<note>
  Playground uses the [`retriever`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#operation-search-body-application-json-retriever) syntax for Elasticsearch queries. Retrievers make it easier to compose and test different retrieval strategies in your search pipelines. Refer to [Retrievers](https://www.elastic.co/docs/solutions/search/retrievers-overview) for a high level overview of retrievers.
</note>


## Hidden fields

The query editor shows fields which make sense for the user to search on, but not all fields in your documents are visible from the editor.
Available field types:
- Semantic fields like `sparse_vector` or `dense_vector` fields where the embeddings have been created from a inference processor
- `text` fields

Hidden Field Types:
- non `text` fields like `keyword` fields
- fields that are not indexed
- semantic fields where the embeddings have not been created from a inference processor
- nested fields