﻿---
title: Elasticsearch solution overview
description: The Elasticsearch solution and serverless project type provide specialized UI tools that help you build search-powered applications faster. These tools...
url: https://www.elastic.co/docs/solutions/elasticsearch-solution-project
products:
  - Elastic Cloud Serverless
  - Elasticsearch
  - Kibana
applies_to:
  - Serverless Elasticsearch projects: Generally available
  - Elastic Stack: Generally available
---

# Elasticsearch solution overview
The Elasticsearch solution and serverless project type provide specialized UI tools that help you build search-powered applications faster. These tools build on top of core Elasticsearch [search capabilities](https://www.elastic.co/docs/solutions/search) that are available across all deployment types, solutions, and project types.
These UI affordances are exclusive to the Elasticsearch solution and serverless project type.
<tip>
  Not sure which deployment type is right for you? Use the following resources to help you decide:
  - Read the Elastic [deployment types overview](https://www.elastic.co/docs/deploy-manage/deploy)
  - Compare [serverless and Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/deployment-comparison)
    - Compare pricing models between [Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/cloud-hosted-deployment-billing-dimensions) and [Serverless](https://www.elastic.co/docs/deploy-manage/cloud-organization/billing/serverless-project-billing-dimensions)
</tip>


## Features and tools

The Elasticsearch solution provides the following specialized UI tools and features to help you build search-powered applications faster:

### Agent Builder

[Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder) enables you to create AI agents that can interact with your Elasticsearch data, run queries, and provide intelligent responses. It provides a complete framework for building conversational AI experiences on top of your search infrastructure.

### Playground

[Playground](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/playground) lets you use large language models (LLMs) to understand, explore, and analyze your Elasticsearch data using retrieval augmented generation (RAG), via a chat interface. Playground is also useful for testing and debugging your Elasticsearch queries using the [retrievers](https://www.elastic.co/docs/solutions/search/retrievers-overview) syntax.

### Synonyms UI

The [synonyms UI](/docs/solutions/search/full-text/search-with-synonyms#method-1-kib-ui) enables managing synonym sets directly within Kibana. This makes it easier to improve search relevance without editing configuration files.

### Query Rules UI

The [Query Rules UI](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/query-rules-ui) enables you to create and manage query rules that modify search behavior based on specific conditions, helping you deliver more relevant results for common queries.

## Get started

Ready to start using the Elasticsearch solution? Refer to [Get started](https://www.elastic.co/docs/solutions/elasticsearch-solution-project/get-started) for setup instructions and quickstart guides.
For a deeper understanding of search concepts and techniques, refer to the [Search use case](https://www.elastic.co/docs/solutions/search) documentation.

## Related pages

- [Search use case documentation](https://www.elastic.co/docs/solutions/search)
- [Elasticsearch reference documentation](https://www.elastic.co/docs/reference/elasticsearch)
- [Elasticsearch API documentation](https://www.elastic.co/docs/api/doc/elasticsearch/)