﻿---
title: Solutions and use cases
description: Learn about Elastic solutions for search, observability, and security use cases. Get started with ready-to-use implementations and discover how to build custom applications.
url: https://www.elastic.co/docs/solutions
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Solutions and use cases
<tip>
  New to Elastic? Refer to [Elastic Fundamentals](https://www.elastic.co/docs/get-started) to understand the Elastic Stack, its components, and your deployment options.
</tip>

Elastic helps you build applications for three main use cases: search, observability, and security. You can work directly with platform capabilities through APIs, use pre-built solutions with integrated UIs, or combine both approaches.

## Choose your path


| Your use case                             | What to use                                                                                                                                                                   | Description                                                                                                                                                              |
|-------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Building search-powered applications      | 1. [Core search capabilities](https://www.elastic.co/docs/solutions/search) 2. [Elasticsearch solution](https://www.elastic.co/docs/solutions/elasticsearch-solution-project) | 1. Core Elasticsearch search features available across all deployment types, solutions, and project types2. Additional UI tools that complement the core search features |
| Monitoring applications or infrastructure | [Observability solution](https://www.elastic.co/docs/solutions/observability)                                                                                                 | Monitor and troubleshoot with logs, metrics, and traces                                                                                                                  |
| Protecting against threats                | [Security solution](https://www.elastic.co/docs/solutions/security)                                                                                                           | Detect and respond to security threats                                                                                                                                   |

<tip>
  Not sure which to choose? Start with the Elasticsearch solution, if you don't need the additional features in Elastic Observability or Elastic Security.
</tip>


## About solutions and project types

- On Elastic Cloud Serverless, select a solution as your project type when creating a project.
- On Elastic Cloud Hosted, ECE, ECK, and self-managed clusters, select a default solution view when creating a deployment, or configure per [space](https://www.elastic.co/docs/deploy-manage/manage-spaces).