﻿---
title: Elastic Security known issues
description: Known issues are significant defects or limitations that may impact your implementation. These issues are actively being worked on and will be addressed...
url: https://www.elastic.co/docs/release-notes/security/known-issues
---

# Elastic Security known issues
Known issues are significant defects or limitations that may impact your implementation. These issues are actively being worked on and will be addressed in a future release. Review the Elastic Security known issues to help you make informed decisions, such as upgrading to a new version.
<dropdown title="Details about gap fills aren't properly updated">
  Applies to: 9.3**Impact**After upgrading to 9.3 from a Elastic Stack version earlier than 8.9, you might encounter the following issues with gap fill functionality:
  - **Gap fills**: Manual runs are scheduled to fill gaps, but gap statuses aren't updated to `Filled` after the manual runs complete.
  - **Rule deletion**: If a rule has gaps and you delete the rule, the rule is removed but the gaps are not marked as deleted. You may see incorrect numbers when viewing total rules with gaps.
  **Root cause**When upgrading from Elastic Stack versions earlier than 8.9, the old event log index is reindexed with a new name:
  - Old index: `.reindexed-v8-kibana-event-log-{version}-000001`
  - Aliases: `.kibana-event-log-{version}`, `.kibana-event-log-{version}-000001`
  Starting in Elastic Stack 8.9.0, a new data stream (`.kibana-event-log-ds`) was introduced for event log storage.The `elastic/kibana` service account has permissions to access the new data stream but does not have permissions to access the old reindexed indices. When Kibana queries `.kibana-event-log-*`, it matches both the new data stream and the old reindexed index, causing Point-in-Time (PIT) operations to fail.**Workaround**Migrate data from the old reindexed index to the new data stream, then delete the old index.
  1. **Identify the old index**:
     ```json
     ```
     Look for indices with names like `.reindexed-v8-kibana-event-log-{version}-*`.
  2. **Reindex data to the new data stream**:
     ```json

     {
       "source": {
         "index": ".reindexed-v8-kibana-event-log-7.17.29-000001" <1>
       },
       "dest": {
         "index": ".kibana-event-log-ds",
         "op_type": "create"
       }
     }
     ```
  3. **Delete the old index**:
     ```json
     ```
  4. **Verify**:
     ```json
     ```
     Only the data stream (`.kibana-event-log-ds`) and its backing indices (`.ds-.kibana-event-log-ds-*`) should remain.

  <important>
    - **Backup**: Consider backing up your data before performing these operations in production environments.
    - **Event log retention**: Event log data has a default retention of 90 days. If you don't need historical data, you can skip the reindex step and simply delete the old index and its aliases.
  </important>
</dropdown>

<dropdown title="Intermittent blue screen due to conflict with Windows ODX in Elastic Defend">
  Applies to: 8.19.8, 8.19.9, 9.1.8, 9.1.9, 9.2.2, and 9.2.3**Impact**
  An issue in Elastic Defend on Windows can result in `KERNEL_AUTO_BOOST_LOCK_ACQUISITION_WITH_RAISED_IRQL` or `PAGE_FAULT_IN_NONPAGED_AREA` bug checks (blue screens) when [Offloaded Data Transfer (ODX)](https://learn.microsoft.com/en-us/windows-hardware/drivers/storage/offloaded-data-transfer) is used to copy files.**Workaround**If you're unable to upgrade to a fixed version, you can disable the affected code by setting the `windows.advanced.kernel.filewrite` [advanced setting](https://www.elastic.co/docs/reference/security/defend-advanced-settings) to `false` in your Elastic Defend integration policy.**Resolved**Resolved in Elastic Agent 8.19.10, 9.1.10 and 9.2.4
  <tip>
    As long as the major and minor versions match, you can run a newer patch version of Elastic Agent than the Elastic Stack. For example, you can use 9.1.10 Elastic Agent with 9.1.8 Elastic Stack.
  </tip>
</dropdown>

<dropdown title="Deploying integrations using AWS CloudFormation doesn't work">
  Applies to: 9.2.0 and 9.2.1**Impact**
  New deployments of integrations that collect data from cloud service providers, such as Asset Discovery and Cloud Security Posture Management, do not work when deployed to AWS using agent-based deployment and the AWS CloudFormation deployment option. The problem results from a malformed CloudFormation parameter: `ElasticAgentVersion`. The default value for `ElasticAgentVersion` has a space instead of a `+`. This produces an invalid agent version value.For more information, check [#14627](https://github.com/elastic/kibana/pull/242365).**Workaround**To work around this issue, update the default CloudFormation template by replacing the space in the `ElasticAgentVersion` parameter with a `+`.**Resolved**Resolved in Elastic Stack 9.2.2.
</dropdown>

<dropdown title="Entity store transform is unavailable">
  Applies to: 9.2.0**Impact**A new feature introduced to the entity store in 9.2.0 caused the transform to scan for nonexistent indices.**Workaround**Restart the entity store:
  1. Find **Entity Store** in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
  2. On the **Entity Store** page, turn the toggle off.
  3. Turn the toggle back on.
  **Resolved**Resolved in Elastic Stack 9.2.1
</dropdown>

<dropdown title="CSPM and Asset Management integrations don't ingest data when deployed using agent-based technology if Kibana is hosted on AWS">
  Applies to: ECH 9.2.0 deployments hosted on AWS**Impact**If your ECH deployment is hosted on AWS, new Cloud Security Posture Management (CSPM) and Asset Inventory integrations will fail to produce findings when deployed using agent-based deployment. ECH deployments hosted on GCP or Azure are not affected. Integrations that use agentless deployment are not affected.**Workaround**Two workarounds are available:
  1. Turn off the **Enable Cloud Connector** advanced setting.
     1. Go to the **Advanced Settings** menu using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
  2. In the **Security Solution** section, turn off the **Enable Cloud Connector** option.
  3. Your agent-based integration deployments will work as expected.
  2. Use agentless deployment.
     1. Instead of using agent-based deployment, use agentless deployment. Agentless deployment works as expected.
  **Resolved**Resolved in Elastic Stack 9.2.1
</dropdown>

<dropdown title="Filters may not apply correctly on the Alerts page">
  Applies to: 9.1.0, 9.1.1, 9.1.2, and 9.1.3**Impact**After upgrading to 9.1.0 and later, some users may experience inconsistent results when applying filters to the Alerts page.**Workaround**You can turn off the Kibana `courier:ignoreFilterIfFieldNotInIndex` [advanced setting](https://www.elastic.co/docs/reference/kibana/advanced-settings#kibana-search-settings), which only applies to the current space. However, turning off this setting might prevent dashboards and visualizations with applied filters from displaying properly. If you have important dashboards that this will impact, you can temporarily move them to a new space by doing the following:
  1. Create a [new space](/docs/deploy-manage/manage-spaces#spaces-managing).
  2. Turn on the Kibana `courier:ignoreFilterIfFieldNotInIndex` [advanced setting](https://www.elastic.co/docs/reference/kibana/advanced-settings#kibana-search-settings) so that filters  apply to visualizations only if the index contains the filtering field.
  3. Use the [import saved objects tool](/docs/explore-analyze/find-and-organize/saved-objects#saved-objects-import-and-export) to move the dashboards or visualizations to the space you just created.

  <note>
    Ensure you give any users who will need access to the new space the appropriate permissions.
  </note>
  **Resolved**Resolved in Elastic Stack 9.1.4
</dropdown>

<dropdown title="The Elastic Agent Docker image is not available at `docker.elastic.co/beats/elastic-agent:9.0.0`">
  Applies to: 9.0.0**Impact**The Elastic Agent image is not available from `docker.elastic.co/beats/elastic-agent:9.0.0`. The default manifests for integrations that run Elastic Agent on Kubernetes—such as CSPM or CNVM—use this image location, resulting in an error.**Workaround**Instead of trying to pull the image from `docker.elastic.co/beats/elastic-agent:9.0.0`, edit the manifests to pull it from `docker.elastic.co/elastic-agent/elastic-agent:9.0.0`.**Resolved**Resolved in Elastic Stack 9.0.1
</dropdown>

<dropdown title="Elastic Defend's Network driver may lead to bug checks">
  **Applies to: Elastic Agent 8.17.8, 8.18.3, and 9.0.3**On July 8, 2025, a known issue was discovered in Elastic Defend's network driver that may lead to kernel pool corruption, resulting in bug checks (BSODs) on Windows systems with a large number of long-lived network connections that remain inactive for 30+ minutes.The system may bug check with any of a variety of codes such as `SYSTEM_SERVICE_EXCEPTION` or `PAGE_FAULT_IN_NONPAGED_AREA`.For more information, check [elastic/endpoint#90](https://github.com/elastic/endpoint/issues/90).**Workaround**If you're on 9.0.3, upgrade to the fixed version: [9.0.3+build202507110136](https://www.elastic.co/downloads/past-releases/elastic-agent-9-0-3+build202507110136).If you're on 8.18.3, upgrade to the fixed version: [8.18.3+build202507101319](https://www.elastic.co/downloads/past-releases/elastic-agent-8-18-3+build202507101319).If you're on 8.17.8, downgrade to 8.17.7 or install 8.17.9 once it becomes available.If you're unable to upgrade or downgrade, set `advanced.kernel.network: false` in your Defend advanced policy.**Resolved**Resolved in Elastic Stack 9.0.4
</dropdown>

<dropdown title="Security AI Assistant Knowledge Base settings UI not displaying">
  Applies to: 9.0.3On June 24, 2025, an error was discovered that prevents the AI Assistant Knowledge Base settings UI from displaying, including the **Setup Knowledge Base** button and alert configuration options. As a result, the Knowledge Base cannot be set up or configured through the Knowledge Base settings UI.**Workaround**While the UI for configuring the Knowledge Base is blocked, you can still enable it
  [from an AI Assistant conversation](/docs/solutions/security/ai/ai-assistant-knowledge-base#_option_1_enable_knowledge_base_from_an_ai_assistant_conversation).After enabling the Knowledge Base, you can manage entries using the AI Assistant API:
  - List Knowledge Base entries using the [find knowledge base entry API](https://www.elastic.co/docs/api/doc/kibana//operation/operation-findknowledgebaseentries):
    ```json
    ```
  - Create a Knowledge Base index entry using the [create knowledge base entry API](https://www.elastic.co/docs/api/doc/kibana//operation/operation-createknowledgebaseentry):
    ```json

    {
      "type": "index",
      "name": "test",
      "index": "test-index",
      "field": "mock",
      "outputFields": ["example"],
      "description": "test description",
      "queryDescription": "test query description"
    }
    ```
  - Create a Knowledge Base document entry using the [create knowledge base entry API](https://www.elastic.co/docs/api/doc/kibana//operation/operation-createknowledgebaseentry):
    ```json

    {
      "type": "document",
      "kbResource": "user",
      "source": "user",
      "name": "doc"
    }
    ```
  **Resolved**Resolved in Elastic Stack 9.0.4
</dropdown>

<dropdown title="The entity risk score feature may stop persisting risk score documents">
  Applies to: Elastic Stack 9.0.0, 9.0.1, 9.0.2On May 30, 2025, it was discovered that the entity risk score feature may stop persisting risk score documents if risk scoring was turned on before you upgraded to Elastic Stack 8.18.0+ or 9.0.0+. This is due to a bug that prevents the `entity_analytics_create_eventIngest_from_timestamp-pipeline-<space_name>` ingest pipeline (which is set as a default pipeline for the risk scoring index in Elastic Stack 8.18.0) from being created when Kibana starts up.While document persistence may initially succeed, it will eventually fail after 0 to 30 days. This is how long it takes for the risk score data stream to roll over and apply its underlying index settings to the new default pipeline.**NOTE:** This bug does not affect Elasticsearch clusters created in Elastic Stack 8.18.0 or 9.0.0 and higher. It also won't affect you if you only turned on entity risk scoring in Elastic Stack 8.18.0 or 9.0.0 and higher.**Workaround**To resolve this issue, apply the following workaround before or after upgrading to Elastic Stack 9.0.0 or higher.First, manually create the ingest pipeline in each space that has entity risk scoring turned on. You can do this using a PUT request, which is described in the example below. When reviewing the example, note that `default` in the example ingest pipeline name below is the Kibana space ID.
  ```
  PUT /_ingest/pipeline/entity_analytics_create_eventIngest_from_timestamp-pipeline-default
  {
    "_meta": {
      "managed_by": "entity_analytics",
      "managed": true
    },
    "description": "Pipeline for adding timestamp value to event.ingested",
    "processors": [
      {
        "set": {
          "field": "event.ingested",
          "value": "{{_ingest.timestamp}}"
        }
      }
    ]
  }
  ```
  After you complete this step, risk scores should automatically begin to successfully persist during the entity risk engine's next run. Details for the next run time are described on the **Entity risk score** page, where you can also manually run the risk score by clicking **Run Engine**.**Resolved**Resolved in Elastic Stack 9.0.3
</dropdown>

<dropdown title="Installing an Elastic Defend integration or a new agent policy upgrades installed prebuilt rules, reverting user customizations and overwriting user-added actions and exceptions">
  Applies to: Elastic Stack 9.0.0On April 10, 2025, it was discovered that when you install a new Elastic Defend integration or agent policy, the installed prebuilt detection rules upgrade to their latest versions (if any new versions are available). The upgraded rules lose any user-added rule actions, exceptions, and customizations.**Workaround**To resolve this issue, before you add an Elastic Defend integration to a policy in Fleet, apply any pending prebuilt rule updates. This will prevent rule actions, exceptions, and customizations from being overwritten.**Resolved**Resolved in Elastic Stack 9.0.1
</dropdown>

<dropdown title="The technical preview badge incorrectly displays on the alert suppression fields for event correlation rules">
  Applies to: Elastic Stack 9.0.0 and 9.0.1On April 8, 2025, it was discovered that alert suppression for event correlation rules is incorrectly shown as being in technical preview when you create a new rule. For more information, check [#1021](https://github.com/elastic/docs-content/issues/1021).**Resolved**Resolved in Elastic Stack 9.0.2
</dropdown>

<dropdown title="Interaction between Elastic Defend and Trellix Access Protection causes IRQL_NOT_LESS_EQUAL bugcheck">
  Applies to: Elastic Defend 9.0.0An `IRQL_NOT_LESS_EQUAL` [bugcheck](https://learn.microsoft.com/en-us/windows-hardware/drivers/debugger/bug-checks--blue-screens-) in the Elastic Defend driver happens due to an interaction with Trellix Access Protection (`mfehidk.sys`). This issue can occur when `elastic-endpoint-driver.sys` calls [`FwpmTransactionBegin0`](https://learn.microsoft.com/en-us/windows/win32/api/fwpmu/nf-fwpmu-fwpmtransactionbegin0) to initialize its network driver. `FwpmTransactionBegin0` performs a synchronous RPC call to the user-mode Base Filtering Engine service. Trellix's driver intercepts this service's operations, causing `FwpmTransactionBegin0` to hang or slow significantly. This delay prevents Elastic Defend driver from properly initializing in a timely manner. Subsequent system activity can invoke Elastic Defend's driver before it has fully initialized, leading to a `IRQL_NOT_LESS_EQUAL` bugcheck. This issue affects Elastic Defend versions 8.16.0-8.16.6, 8.17.0-8.17.5, 8.18.0, and 9.0.0.**Workaround**If you can't upgrade, either disable Trellix Access Protection or add a [Trellix Access Protection exclusion](https://docs.trellix.com/bundle/endpoint-security-10.6.0-threat-prevention-client-interface-reference-guide-windows/page/GUID-6AC245A1-5E5D-4BAF-93B0-FE7FD33571E6.html) for the Base Filtering Engine service (`C:\Windows\System32\svchost.exe`).**Resolved**Resolved in Elastic Defend 9.0.1
</dropdown>

<dropdown title="Unbounded kernel non-paged memory growth issue in Elastic Defend's kernal driver causes slow down on Windows systems">
  Applies to: Elastic Defend 9.0.0An unbounded kernel non-paged memory growth issue in Elastic Defend's kernel driver occurs during extremely high event load situations on Windows. Systems affected by this issue will slow down or become unresponsive until the triggering event load (for example, network activity) subsides. We are only aware of this issue occurring on busy Windows Server systems running Elastic Defend versions 8.16.0-8.16.6, 8.17.0-8.17.5, 8.18.0, and 9.0.0**Workaround**If you can't upgrade, turn off the relevant event source at the kernel level using your Elastic Defend [advanced policy settings (optional)](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#adv-policy-settings):
  - Network Events - Set the `windows.advanced.kernel.network` advanced setting to `false`.
  - Registry Events - Set the `windows.advanced.kernel.registry` advanced setting to `false`.
  Clearing the corresponding checkbox under [event collection](/docs/solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend#event-collection) is insufficient, as Elastic Defend may still process these event sources internally to support other features.**Resolved**Resolved in Elastic Defend 9.0.1
</dropdown>