﻿---
title: Elastic Security deprecations
description: Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for...
url: https://www.elastic.co/docs/release-notes/security/deprecations
---

# Elastic Security deprecations
Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for a period before removal, giving you time to update your applications.
Review the deprecated functionality for Elastic Security. While deprecations have no immediate impact, we strongly encourage you update your implementation after you upgrade. To learn how to upgrade, check out [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade).

## 9.3.0


<dropdown title="Removes evaluation of Endpoint exceptions during detection rule execution">
  Endpoint exceptions are no longer evaluated during detection rule execution.
  For more information, refer to [#233289](https://github.com/elastic/kibana/pull/233289).
</dropdown>


## 9.1.0

<dropdown title="Removes default quick prompts">
  Removes default quick prompts from the Security AI Assistant.
  For more information, refer to [#225536](https://github.com/elastic/kibana/pull/225536).
</dropdown>


## 9.0.0

<dropdown title="Removes Defend for Containers (D4C)">
  Defend for Containers is no longer supported starting with Elastic Stack 9.0.
</dropdown>

<dropdown title="Renames the integration-assistant plugin">
  Renames the `integration-assistant` plugin to `automatic-import` to match the associated feature.
  For more information, refer to [#207325](https://github.com/elastic/kibana/pull/207325).
</dropdown>

<dropdown title="Removes legacy risk engine">
  Removes all legacy risk engine code and features.
  For more information, refer to [#201810](https://github.com/elastic/kibana/pull/201810).
</dropdown>

<dropdown title="Removes Elastic Defend API endoints">
  Removes deprecated API endpoints for Elastic Defend.
  For more information, refer to [#199598](https://github.com/elastic/kibana/pull/199598).
</dropdown>

<dropdown title="Deprecates SIEM signals migration APIs">
  Removes the SIEM signals migration APIs.
  For more information, refer to [#202662](https://github.com/elastic/kibana/pull/202662).
</dropdown>