﻿---
title: Elastic Observability release notes
description: Review the changes, fixes, and more in each version of Elastic Observability. To check for security updates, go to Security announcements for the Elastic...
url: https://www.elastic.co/docs/release-notes/observability
products:
  - Elastic Observability
---

# Elastic Observability release notes
Review the changes, fixes, and more in each version of Elastic Observability.
To check for security updates, go to [Security announcements for the Elastic stack](https://discuss.elastic.co/c/announcements/security-announcements/31).

## 9.3.0


### Features and enhancements

- Adds the math, replace, drop, and convert processors [#246050](https://github.com/elastic/kibana/pull/246050), [#242310](https://github.com/elastic/kibana/pull/242310), [#242161](https://github.com/elastic/kibana/pull/242161), [#240023](https://github.com/elastic/kibana/pull/240023).
- Adds **Suggest ingest pipeline** feature [#243950](https://github.com/elastic/kibana/pull/243950).
- Enforces field name spacing in wired streams and detects type mismatches in processor configurations [#244221](https://github.com/elastic/kibana/pull/244221).
- Allows users to configure Streams visibility on a space-by-space basis [#244285](https://github.com/elastic/kibana/pull/244285).
- Adds AI pattern suggestions for the Streams dissect processor [#242377](https://github.com/elastic/kibana/pull/242377).
- Improves processing warnings with truncation logic and wrapped text [#239188](https://github.com/elastic/kibana/pull/239188).
- Adds support for `geo_point` fields to classic streams [#244356](https://github.com/elastic/kibana/pull/244356).
- Allows users to add custom description for processors [#243998](https://github.com/elastic/kibana/pull/243998).
- Adds a tour of the Streams UI [#244808](https://github.com/elastic/kibana/pull/244808).
- Adds a message to tell users when a stream is missing [#244366](https://github.com/elastic/kibana/pull/244366).
- Prevents conflicts in **Processing** tab when editing and reordering streams [#244228](https://github.com/elastic/kibana/pull/244228).
- Adds field type icons to the **Processing** UI [#242134](https://github.com/elastic/kibana/pull/242134), [#241825](https://github.com/elastic/kibana/pull/241825).
- Adds timezone and locale parameters to Streamlang [#241369](https://github.com/elastic/kibana/pull/241369).
- Adds an empty state for **Processing** tab when no data is available [#244893](https://github.com/elastic/kibana/pull/244893).
- Adds specific error messaging to the Streams schema editor when expensive queries are turned off [#243406](https://github.com/elastic/kibana/pull/243406).
- Adds autoscroll to **Review partitioning suggestions** panels [#242891](https://github.com/elastic/kibana/pull/242891).
- Adds space ownership validation for unlink operations, preventing users from unlinking attachments that belong to a different space [#245250](https://github.com/elastic/kibana/pull/245250).
- Improves Streams attachment filters with multi-type selection, server-side filtering, and suggestions limit [#245248](https://github.com/elastic/kibana/pull/245248).
- Adds details flyout and improved UX to the Streams attachment feature [#244880](https://github.com/elastic/kibana/pull/244880).
- Hides document match filter controls in the processing preview for users without manage privileges [#242119](https://github.com/elastic/kibana/pull/242119).
- Adds messaging to show nested processors and conditions [#240778](https://github.com/elastic/kibana/pull/240778).
- Adds abort capabilities and silent mode when generating stream descriptions [#247082](https://github.com/elastic/kibana/pull/247082).
- Allows users to bulk mute and unmute alerts [#245690](https://github.com/elastic/kibana/pull/245690).
- Adds a **Find Alert Rule Templates** API that shows installed templates in the **Create new rule** modal [#245373](https://github.com/elastic/kibana/pull/245373).
- Adds a unified rules list [#242208](https://github.com/elastic/kibana/pull/242208).
- Adds **View in discover** button to alert details for Infrastructure rules [#236880](https://github.com/elastic/kibana/pull/236880).
- Adds new pre-configured connectors and updates existing ones [#242791](https://github.com/elastic/kibana/pull/242791).
- Allows users to view and filter by manually added workflow tags [#244251](https://github.com/elastic/kibana/pull/244251).
- Shows alert workflow tags on the **Overview** tab of the alert details flyout [#246440](https://github.com/elastic/kibana/pull/246440).
- Adds a warning when deleting API keys currently in use by alerting rules [#243353](https://github.com/elastic/kibana/pull/243353).
- Allows users to configure custom global ingest pipelines on SLO rollup data [#245025](https://github.com/elastic/kibana/pull/245025).
- Adds index sorting to SLI index settings [#244978](https://github.com/elastic/kibana/pull/244978).
- Allows users to view the SLO associated with a burn rate rule from the rule details page [#240535](https://github.com/elastic/kibana/pull/240535).
- Adds SLO attachments and migrates UI to attachments API [#244092](https://github.com/elastic/kibana/pull/244092).
- Adds new sub-feature privileges for Synthetics global parameters [#243821](https://github.com/elastic/kibana/pull/243821).
- Adds badge sync to **Trace timeline** [#246510](https://github.com/elastic/kibana/pull/246510).
- Adds errors to **Trace timeline** [#245161](https://github.com/elastic/kibana/pull/245161).
- Replaces current document count chart with RED metrics [#236635](https://github.com/elastic/kibana/pull/236635).
- Adds **Span links** badge to **Trace timeline** [#244389](https://github.com/elastic/kibana/pull/244389).
- Adds `deactivate_all_instrumentations`, `deactivate_instrumentations`, `send_logs`, `send_metrics`, and `send_traces` agent configuration settings for EDOT PHP [#246021](https://github.com/elastic/kibana/pull/246021).
- Adds dashboard suggestions for **ECS**, **K8s**, and **OTel** dashboards when selecting **Pods** in Infra Inventory UI [#245784](https://github.com/elastic/kibana/pull/245784).
- Ensures Infra Inventory UIs reflect supported schemas [#244481](https://github.com/elastic/kibana/pull/244481).
- Adds metrics dashboard for non-EDOT agents in the OTEL native ingestion path [#236978](https://github.com/elastic/kibana/pull/236978).
- Adds `sampling_rate` central configuration to EDOT PHP [#241908](https://github.com/elastic/kibana/pull/241908).
- Adds `opamp_polling_interval` and `sampling_rate` central configuration to EDOT Node.js [#241048](https://github.com/elastic/kibana/pull/241048).
- Adds **Edit tags** to alert actions [#243792](https://github.com/elastic/kibana/pull/243792).
- Adds the **ELSER in EIS** model option for the Observability and Search AI Assistant Knowledge Base [#243298](https://github.com/elastic/kibana/pull/243298).
- Removes the `AI Assistants Settings` privilege [#239144](https://github.com/elastic/kibana/pull/239144).
- Observability Agent for Agent Builder is released in 9.3. This includes Observability related tools and AI Insights for alerts, logs in Discover, and errors in APM.
- Adds **Similar errors** section with Occurrences chart [#244665](https://github.com/elastic/kibana/pull/244665).
- Updates Observability Serverless side navigation [#235984](https://github.com/elastic/kibana/pull/235984).


### Fixes

- Decouples Streams AI features from the AI Assistant [#242019](https://github.com/elastic/kibana/pull/242019).
- Fixes stale query value being used when saving significant events and adds debouncing to preview chart [#249833](https://github.com/elastic/kibana/pull/249833).
- Taking bulk actions on Streams features now requires the `manage` permission [#246129](https://github.com/elastic/kibana/pull/246129).
- Fixes the simulation of geo points [#241824](https://github.com/elastic/kibana/pull/241824).
- Fixes processing field name autocomplete that wasn't working on new fields [#246934](https://github.com/elastic/kibana/pull/246934).
- Turns off geopoint mapping in the processing preview [#245506](https://github.com/elastic/kibana/pull/245506).
- Fixes manual ingest pipeline script validation [#245439](https://github.com/elastic/kibana/pull/245439).
- Fixes cell actions populating as undefined with empty cells [#243766](https://github.com/elastic/kibana/pull/243766).
- Removes mentions of template snippets (mustache templates) from descriptions [#243656](https://github.com/elastic/kibana/pull/243656).
- Speeds up field simulation [#241313](https://github.com/elastic/kibana/pull/241313).
- Fixes child stream input validation [#242581](https://github.com/elastic/kibana/pull/242581).
- Fixes invalid state for wired streams toggle [#241266](https://github.com/elastic/kibana/pull/241266).
- Fixes wrapping issues in AI suggestions [#240883](https://github.com/elastic/kibana/pull/240883).
- Fixes related dashboards for ES Query and other stack rules supported in observability [#247564](https://github.com/elastic/kibana/pull/247564).
- Fixes default alerts flow when default rules are not defined [#245736](https://github.com/elastic/kibana/pull/245736).
- Adds managed field to `dataViewSpecSchema` [#244134](https://github.com/elastic/kibana/pull/244134).
- Fixes empty **Related dashboards** meu when linking dashboards to a rule [#243496](https://github.com/elastic/kibana/pull/243496).
- Prevents default alerts from being created when connectors are not defined [#237504](https://github.com/elastic/kibana/pull/237504).
- Copies alert states to payload [#240411](https://github.com/elastic/kibana/pull/240411).
- Replaces metric names inside filter values [#238849](https://github.com/elastic/kibana/pull/238849).
- Provides users with more granular control over how alerts behave when data stops being reported for metric threshold rules [#247669](https://github.com/elastic/kibana/pull/247669).
- Reverts show transform errors across all SLO pages [#243013](https://github.com/elastic/kibana/pull/243013).
- Reverts fix issue where filters do not apply to overview stats [#242978](https://github.com/elastic/kibana/pull/242978).
- Fixes inconsistent browser back button behavior on SLO page [#242761](https://github.com/elastic/kibana/pull/242761).
- Fixes layout of the **SLO management** page filters [#239418](https://github.com/elastic/kibana/pull/239418).
- Excludes stale SLOs from "group by" stats [#240077](https://github.com/elastic/kibana/pull/240077).
- Fixes alerts being incorrectly triggered when a monitor is down [#237479](https://github.com/elastic/kibana/pull/237479).
- Creates default rules when creating or editing a monitor, not from navigation-based events [#245441](https://github.com/elastic/kibana/pull/245441).
- Uses monitor query id for project monitors package policies [#248762](https://github.com/elastic/kibana/pull/248762).
- Fixes duplicate test results on monitor status heatmap [#248761](https://github.com/elastic/kibana/pull/248761).
- Fixes validation error with maintenance windows on lightweight Synthetics monitors [#247880](https://github.com/elastic/kibana/pull/247880).
- Fixes console state from persisting across journey steps [#247376](https://github.com/elastic/kibana/pull/247376).
- Fixes Elastic Agent from interpreting JS template literals as policy variables  [#247284](https://github.com/elastic/kibana/pull/247284).
- Fixes Synthetics tasks to only update relevant monitors when maintenance windows exist [#246088](https://github.com/elastic/kibana/pull/246088).
- Turns off max attempts for the private locations sync task [#237784](https://github.com/elastic/kibana/pull/237784).
- Fixes creating and updating private location monitors [#238326](https://github.com/elastic/kibana/pull/238326).
- Fixes the icon in the "Elastic documentation not available" callout in AI Assistant settings [#247885](https://github.com/elastic/kibana/pull/247885).
- Fixes issue with the `Authorization` header when  making calls through the Kibana tool [#244017](https://github.com/elastic/kibana/pull/244017).
- Updates system prompt title for generic deployments [#243266](https://github.com/elastic/kibana/pull/243266).
- Fixes the AI Assistant button tooltip from persisting when not being hovered over [#237202](https://github.com/elastic/kibana/pull/237202).
- Fixes error when the AI Assistant is off [#238811](https://github.com/elastic/kibana/pull/238811).
- Fixes Knowledge base model label in the AI Assistant settings [#239824](https://github.com/elastic/kibana/pull/239824).
- Fixes Kibana tool from failing when using a proxy [#236653](https://github.com/elastic/kibana/pull/236653).
- Fixes overlapping components in the Observability AI Assistant flyout on small screens [#241026](https://github.com/elastic/kibana/pull/241026).
- Fixes error handling for tool response [#241425](https://github.com/elastic/kibana/pull/241425).
- Fixes **AI Assistant visibility** setting syncing issues [#239555](https://github.com/elastic/kibana/pull/239555).
- Updates the AI agent used for Observability AI insights [#249776](https://github.com/elastic/kibana/pull/249776).
- Fixes alias resolution when checking lock index mappings [#244559](https://github.com/elastic/kibana/pull/244559).
- Adds `maxQueue` backpressure to anonymization regex worker pool [#249108](https://github.com/elastic/kibana/pull/249108).
- Fixes ESQL query execution timeout issues[#238200](https://github.com/elastic/kibana/pull/238200).
- Fixes handling of missing `error.id` [#243638](https://github.com/elastic/kibana/pull/243638).
- Hides non-trace services in **Service Inventory** and **Service Map** [#241080](https://github.com/elastic/kibana/pull/241080), [#240104](https://github.com/elastic/kibana/pull/240104).
- Updates `useAnyOfApmParams` to include mobile services [#237500](https://github.com/elastic/kibana/pull/237500).
- Fixes dependencies and service map for `txn == exit-span` use cases [#235392](https://github.com/elastic/kibana/pull/235392).
- Fixes AI insights with fallback message fields [#243437](https://github.com/elastic/kibana/pull/243437).
- Fixes missing service environment in custom links [#248631](https://github.com/elastic/kibana/pull/248631).
- Updates the **Open in Discover** query in the **Related logs** section of the **Overview** tab [#240409](https://github.com/elastic/kibana/pull/240409).
- Fixes missing spans in discover traces view [#247689](https://github.com/elastic/kibana/pull/247689).
- Fixes **Trace timeline** tests [#247252](https://github.com/elastic/kibana/pull/247252).
- Fixes traces duplicate spans in Discover [#244984](https://github.com/elastic/kibana/pull/244984).
- Fixes trace links calculating date range incorrectly [#247531](https://github.com/elastic/kibana/pull/247531).
- Fixes error rate chart warning on first load [#247052](https://github.com/elastic/kibana/pull/247052).
- Fixes broken links from **View In Context** Discover modal [#248939](https://github.com/elastic/kibana/pull/248939).
- Fixes loss of UI state in signal-specific Discover fly-out tabs when refreshing a query [#248203](https://github.com/elastic/kibana/pull/248203).
- Fixes **Metrics explorer** search bar issue on some screen sizes [#246945](https://github.com/elastic/kibana/pull/246945).
- Replaces `host.hostname` with `host.name` in Infrastructure tab [#246386](https://github.com/elastic/kibana/pull/246386).
- Fixes charts not filtering by `host.name` [#242673](https://github.com/elastic/kibana/pull/242673).
- Removes filtering capabilities in host metrics [#239724](https://github.com/elastic/kibana/pull/239724).
- Fixes broken metadata filtering when typing "OR" in host flyouts [#233836](https://github.com/elastic/kibana/pull/233836).
- Fixes CPU query by changing the gap policy to include zeros [#239596](https://github.com/elastic/kibana/pull/239596).
- Fixes the incorrectly formatted **Values** dropdown in Storybook [#241812](https://github.com/elastic/kibana/pull/241812).
- Escapes special characters when creating ESQL query for Lens charts [#241662](https://github.com/elastic/kibana/pull/241662).
- Adds missing transaction action links [#241336](https://github.com/elastic/kibana/pull/241336).
- Updates metrics experience API routes to delegate authorization to Elasticsearch [#241195](https://github.com/elastic/kibana/pull/241195).
- Fixes error when clearing custom link filters [#241164](https://github.com/elastic/kibana/pull/241164).
- Improves metrics profile resolution by removing index pattern and time series validation [#241047](https://github.com/elastic/kibana/pull/241047).
- Fixes KPIs subtitle logic [#243217](https://github.com/elastic/kibana/pull/243217).
- Fixes JVM metric conflicts with explicit cast [#244151](https://github.com/elastic/kibana/pull/244151).
- Removes unnecessary `_source` from queries [#239205](https://github.com/elastic/kibana/pull/239205).
- Fixes onboarding issues [#246208](https://github.com/elastic/kibana/pull/246208).
- Adds **Background Search** to the ECH Observability navigation menu [#237494](https://github.com/elastic/kibana/pull/237494).
- Aligns **Members** link across solutions [#240992](https://github.com/elastic/kibana/pull/240992).
- Fixes icon colors for navigation menu [#237970](https://github.com/elastic/kibana/pull/237970).
- Fixes gap while loading data [#238879](https://github.com/elastic/kibana/pull/238879).
- Fixes **Dataset Quality** flyout rendering [#237840](https://github.com/elastic/kibana/pull/237840).


## 9.2.5


### Fixes

- Fixes incorrect dependencies stats [#249434](https://github.com/elastic/kibana/pull/249434).
- Adds `maxQueue` backpressure to anonymization regex worker pool [#249108](https://github.com/elastic/kibana/pull/249108).
- Fixes broken links from **View In Context** Discover modal [#248939](https://github.com/elastic/kibana/pull/248939).
- Uses monitor query id for project monitors package policies [#248762](https://github.com/elastic/kibana/pull/248762).
- Fixes an issue where synthetics test results showed up as duplicated on the monitor status heat map, for higher granularity columns [#248761](https://github.com/elastic/kibana/pull/248761).
- Fixes loss of UI state in signal-specific Discover fly-out tabs when refreshing a query [#248203](https://github.com/elastic/kibana/pull/248203).
- Fixes missing spans in Discover's traces view [#247689](https://github.com/elastic/kibana/pull/247689).
- Adds more granular control over how alerts behave when data stops being reported for metric threshold rules [#247669](https://github.com/elastic/kibana/pull/247669).
- Fixes Synthetics tasks to only update relevant monitors when maintenance windows exist [#246088](https://github.com/elastic/kibana/pull/246088).
- 


## 9.2.4


### Fixes

- Fixes the icon in the "Elastic documentation not available" callout in AI Assistant Settings [#247885](https://github.com/elastic/kibana/pull/247885).
- Fixes validation error with maintenance windows on lightweight Synthetics monitors [#247880](https://github.com/elastic/kibana/pull/247880).
- Fixes related dashboards for ES Query and other stack rules supported in Observability [#247564](https://github.com/elastic/kibana/pull/247564).
- Fixes console state from persisting across journey steps [#247376](https://github.com/elastic/kibana/pull/247376).
- Fixes Elastic Agent from interpreting JS template literals as policy variables  [#247284](https://github.com/elastic/kibana/pull/247284).
- Fixes Synthetics tasks to only update relevant monitors when maintenance windows exist [#246088](https://github.com/elastic/kibana/pull/246088).
- Fixes default alerts flow from breaking when default rules are not defined [#245736](https://github.com/elastic/kibana/pull/245736).
- Fixes error handling for tool response [#241425](https://github.com/elastic/kibana/pull/241425).


## 9.2.3


### Features and enhancements

- Adds a message to tell users when a stream is missing [#244366](https://github.com/elastic/kibana/pull/244366).
- Adds a warning when deleting API keys that are currently in use by alerting rules [#243353](https://github.com/elastic/kibana/pull/243353).
- Shows supported schemas in the Infrastructure inventory [#244481](https://github.com/elastic/kibana/pull/244481).


### Fixes

- Fixes alias resolution when checking lock index mappings [#244559](https://github.com/elastic/kibana/pull/244559).
- Adds managed field to `dataViewSpecSchema` [#244134](https://github.com/elastic/kibana/pull/244134).
- Removes mentions of template snippets from descriptions [#243656](https://github.com/elastic/kibana/pull/243656).


## 9.2.2


### Features and enhancements

- Adds new sub-feature privileges for Synthetics global parameters [#243821](https://github.com/elastic/kibana/pull/243821).


### Fixes

- Fixes issue with the `Authorization` header when  making calls through the Kibana tool [#244017](https://github.com/elastic/kibana/pull/244017).
- Stops UI from breaking when the `error.id` field is missing [#243638](https://github.com/elastic/kibana/pull/243638).
- Updates system prompt title for generic deployments [#243266](https://github.com/elastic/kibana/pull/243266).
- Fixes KPIs subtitle logic [#243217](https://github.com/elastic/kibana/pull/243217).
- Reverts the PR that introduced transform errors across all SLO pages [#243013](https://github.com/elastic/kibana/pull/243013).
- Reverts the "Fix issue where filters do not apply to overview stats" PR [#242978](https://github.com/elastic/kibana/pull/242978).
- Fixes charts not filtering by `host.name` [#242673](https://github.com/elastic/kibana/pull/242673).
- Fixes issue with custom links clearing filter views when a new field is selected or deleted [#241164](https://github.com/elastic/kibana/pull/241164).
- Fixes CPU query by changing the gap policy to include zeros [#239596](https://github.com/elastic/kibana/pull/239596).


## 9.2.1


### Fixes

- Fixes simulation of geo points in Streams [#241824](https://github.com/elastic/kibana/pull/241824).
- Speeds up field simulation in Streams [#241313](https://github.com/elastic/kibana/pull/241313).
- Fixes the incorrectly formatted **Values** dropdown in Storybook [#241812](https://github.com/elastic/kibana/pull/241812).
- Escapes special characters when creating ESQL query for Lens charts [#241662](https://github.com/elastic/kibana/pull/241662).


## 9.2.0


### Features and enhancements

- Lets you create routing conditions directly from preview table in Streams. [#235560](https://github.com/elastic/kibana/pull/235560).
- Allows Streams users to manually map new fields from the **Schema** tab [#235919](https://github.com/elastic/kibana/pull/235919).
- Adds AI suggestion partitioning to Streams [#235759](https://github.com/elastic/kibana/pull/235759).
- Improves processing warnings in Streams [#239188](https://github.com/elastic/kibana/pull/239188).
- Adds ingest pipeline processor template suggestions to the Streams manual ingest pipeline processor editor [#236919](https://github.com/elastic/kibana/pull/236919).
- Add triple quotes support to the Streams manual ingest pipeline processor editor [#236595](https://github.com/elastic/kibana/pull/236595).
- Adds persistent field mappings for Streams processors [#233799](https://github.com/elastic/kibana/pull/233799).
- Updates the Observability navigation menu [#233784](https://github.com/elastic/kibana/pull/233784), [#236808](https://github.com/elastic/kibana/pull/236808).
- Adds functional tests for Logs Essentials tier to cover tier-specific behavior [#234904](https://github.com/elastic/kibana/pull/234904).
- Enables Observability onboarding Playwright tests for the Logs Essentials tier [#234644](https://github.com/elastic/kibana/pull/234644).
- Adds **View in Discover** to the alerts details page for Synthetics Monitor Status and TLS alert rules. [#234104](https://github.com/elastic/kibana/pull/234104).
- Adds **View in discover** to the alerts details page for SLO burn rate and ES query rules [#233855](https://github.com/elastic/kibana/pull/233855).
- Adds **View in discover** button to alert details header [#233259](https://github.com/elastic/kibana/pull/233259).
- Adds time range filter to links from alert details to related dashboards [#230601](https://github.com/elastic/kibana/pull/230601).
- Adds rules callout in metric, logs, and inventory rules [#237085](https://github.com/elastic/kibana/pull/237085).
- Enables filters and saved queries in custom threshold rules [#229453](https://github.com/elastic/kibana/pull/229453).
- Adds option to recover alerts when the monitor is back up or when the condition is no longer met. [#229962](https://github.com/elastic/kibana/pull/229962).
- Adds the **Trace timeline** to Discover flyout [#234072](https://github.com/elastic/kibana/pull/234072).
- Adds `send_traces`, `send_metrics`, and `send_logs` agent configuration settings for EDOT Node.js [#233798](https://github.com/elastic/kibana/pull/233798).
- Shows errors in context of traces [#234178](https://github.com/elastic/kibana/pull/234178)
- Adds option to link dashboards to SLOs [#233265](https://github.com/elastic/kibana/pull/233265).
- Adds dashboard references to SLO saved objects [#232583](https://github.com/elastic/kibana/pull/232583).
- Adds dashboard tags for linked dashboards and suggested dashboards on the alert details page's **Related dashboards** tab [#228902](https://github.com/elastic/kibana/pull/228902).
- Fetches referenced panels when fetching dashboards [#228811](https://github.com/elastic/kibana/pull/228811).
- Moves the installation settings for AI Assistant's Knowledge Base and Product Docs components into a single location [#232559](https://github.com/elastic/kibana/pull/232559), [#228695](https://github.com/elastic/kibana/pull/228695).
- Makes AI Assistant aware of LLM-facing documentation for integrations installed in your cluster [#237085](https://github.com/elastic/kibana/pull/237085).
- Adds `raw_request` to traces for `.gen-ai`, `.gemini`, and `.bedrock` connectors [#232229](https://github.com/elastic/kibana/pull/232229).
- Adds manual test for bulk import functionality for AI Assistant [#225497](https://github.com/elastic/kibana/pull/225497).
- Improves the AI Assistant Settings page by updating the logos to be solution-specific [#224906](https://github.com/elastic/kibana/pull/224906).
- Adds native function calling schema change to the OpenAI connector when the API provider is set to `other` [#232097](https://github.com/elastic/kibana/pull/232097).
- Adds native function calling for self-managed LLMs [#232109](https://github.com/elastic/kibana/pull/232109).
- Improves Gemini prompts [#223476](https://github.com/elastic/kibana/pull/223476).
- Adds **GenAI Settings** to **Stack management** [#227289](https://github.com/elastic/kibana/pull/227289).
- Moves the **AI Assistant visibility** setting to **GenAI Settings** page [#233727](https://github.com/elastic/kibana/pull/233727).
- Adds UI tests to validate the onboarding page [#232363](https://github.com/elastic/kibana/pull/232363).
- Shows span links when APM indices are available [#232135](https://github.com/elastic/kibana/pull/232135).
- Adds error count and badge and support for span types to trace samples [#227413](https://github.com/elastic/kibana/pull/227413) [#227208](https://github.com/elastic/kibana/pull/227208).
- Disables add-to-case functionality when all selected alerts are already added to a case [#231877](https://github.com/elastic/kibana/pull/231877).
- Allows users to paste screenshots into markdown comment fields for cases [#226077](https://github.com/elastic/kibana/pull/226077).
- Extracts case observables automatically when attaching alerts to a case [#233027](https://github.com/elastic/kibana/pull/233027).
- Allows attaching any event to a case, not only alert events [#230970](https://github.com/elastic/kibana/pull/230970).
- Adds `opamp_polling_interval` and `sampling_rate` to central config for EDOT application agents [#231835](https://github.com/elastic/kibana/pull/231835).
- Adds `kibana.alert.grouping` field to Synthetics monitor status rule [#230513](https://github.com/elastic/kibana/pull/230513).
- Adds a public endpoint for manually testing synthetic monitors [#227760](https://github.com/elastic/kibana/pull/227760).
- Adds error param to agent config API [#230298](https://github.com/elastic/kibana/pull/230298).
- Creates an API to detect existing schemas [#226597](https://github.com/elastic/kibana/pull/226597).
- Adds option to the shared logs overview to see all available log events even when ML features are not available [#225785](https://github.com/elastic/kibana/pull/225785).


### Fixes

- Fixes layout of SLO management page combo box filter [#239418](https://github.com/elastic/kibana/pull/239418).
- Fixes icon colors for navigation menu [#237970](https://github.com/elastic/kibana/pull/237970).
- Updates `useAnyOfApmParams` to include mobile services [#237500](https://github.com/elastic/kibana/pull/237500).
- Adds background search to Observability navigation [#237494](https://github.com/elastic/kibana/pull/237494).
- Fixes the multiselect issue inside the toolbar selector when search is used [#237494](https://github.com/elastic/kibana/pull/237494).
- Fixes the page height of the AI Assistant page [#233924](https://github.com/elastic/kibana/pull/233924).
- Fixes knowledge base model label in AI Assistant settings [#239824](https://github.com/elastic/kibana/pull/239824).
- Fixes **Show alert details** actions button [#233113](https://github.com/elastic/kibana/pull/233113).
- Fixes `get_alerts_dataset_info` to fail completely if any parallel `select_relevant_fields` request fails [#232281](https://github.com/elastic/kibana/pull/232281).
- Adjusts Kubernetes OTel test to work in serverless nightly workflow [#231462](https://github.com/elastic/kibana/pull/231462).
- Fixes title generation for conversations in the Observability AI Assistant with self-managed LLMs  [#231198](https://github.com/elastic/kibana/pull/231198).
- Fixes inventory date picker state [#231141](https://github.com/elastic/kibana/pull/231141).
- Enables recovery strategy switch for monitor status rules [#231091](https://github.com/elastic/kibana/pull/231091).
- Includes `ContentManagement` plugin to allow linked dashboards [#237085](https://github.com/elastic/kibana/pull/229685).
- Improves performance of clustering [#238394](https://github.com/elastic/kibana/pull/238394).
- Fixes multiselect issue in Discover toolbar [#236091](https://github.com/elastic/kibana/pull/236091).
- Improves accessibility for Streams badges [#235625](https://github.com/elastic/kibana/pull/235625).
- Fixes code area responsiveness in Stream management [#232630](https://github.com/elastic/kibana/pull/232630).


## 9.1.10


### Features and enhancements

- Adds API to enable auto-syncing of global parameters to private locations [#239284](https://github.com/elastic/kibana/pull/239284).


### Fixes

- Fixes validation error with maintenance windows on lightweight Synthetics monitors [#247880](https://github.com/elastic/kibana/pull/247880).
- Fixes related dashboards for ES Query and other stack rules supported in Observability [#247564](https://github.com/elastic/kibana/pull/247564).
- Fixes console state from persisting across journey steps [#247376](https://github.com/elastic/kibana/pull/247376).
- Fixes Elastic Agent from interpreting JS template literals as policy variables [#247284](https://github.com/elastic/kibana/pull/247284).
- Fixes Synthetics tasks to only update relevant monitors when maintenance windows exist [#246088](https://github.com/elastic/kibana/pull/246088).
- Fixes trace links to correctly calculate date range [#247531](https://github.com/elastic/kibana/pull/247531).


## 9.1.9


### Features and enhancements

- Adds a warning when deleting API keys that are currently in use by alerting rules [#243353](https://github.com/elastic/kibana/pull/243353).


### Fixes

- Fixes alias resolution when checking lock index mappings [#244559](https://github.com/elastic/kibana/pull/244559).


## 9.1.8


### Features and enhancements

- Adds new sub-feature privileges for Synthetics global parameters [#243821](https://github.com/elastic/kibana/pull/243821).


### Fixes

- Stops UI from breaking when the `error.id` field is missing [#243638](https://github.com/elastic/kibana/pull/243638).
- Reverts the PR that introduced transform errors across all SLO pages [#243013](https://github.com/elastic/kibana/pull/243013).
- Fixes issue with custom links clearing filter views when a new field is selected or deleted [#241164](https://github.com/elastic/kibana/pull/241164).
- Fixes CPU query by changing the gap policy to include zeros [#239596](https://github.com/elastic/kibana/pull/239596).


## 9.1.7


### Fixes

- Adds missing transaction action links [#241336](https://github.com/elastic/kibana/pull/241336).
- Fixes overlapping components in the Observability AI Assistant flyout on small screens [#241026](https://github.com/elastic/kibana/pull/241026).
- Excludes stale SLOs from "group by" stats [#240077](https://github.com/elastic/kibana/pull/240077).
- Fixes Kibana tool from failing when using a proxy [#236653](https://github.com/elastic/kibana/pull/236653).
- Hides non-trace services from APM service inventory [#241080](https://github.com/elastic/kibana/pull/241080).


## 9.1.6


### Fixes

- Fixes layout of SLO management page combo box filter [#239418](https://github.com/elastic/kibana/pull/239418).
- Removes Elasticsearch `_sources` from query responses [#239205](https://github.com/elastic/kibana/pull/239205).
- Fixes rule condition chart parser replacing metric names in filter values [#238849]https://github.com/elastic/kibana/pull/(238849).
- Fixes creating and updating private location monitors [#238326](https://github.com/elastic/kibana/pull/238326).
- Disables max attempts for the private locations sync task [#237784](https://github.com/elastic/kibana/pull/237784).
- Fixes `useAnyOfApmParams` to include mobile services [#237500](https://github.com/elastic/kibana/pull/237500).
- Fixes a bug with Synthetics alerting where a down monitor triggered recovered alerts when it shouldn't [#237479](https://github.com/elastic/kibana/pull/237479).
- Fixes the AI Assistant button tooltip by closing the tooltip when the button is not being hovered over [#237202](https://github.com/elastic/kibana/pull/237202).


## 9.1.5


### Features and enhancements

- Allows implementation of a default LLM connector from settings [#236103](https://github.com/elastic/kibana/pull/236103).


### Fixes

- Removes span documents from `getServiceAgent` function [#236732](https://github.com/elastic/kibana/pull/236732).
- Removes incorrect `fleet.ssl` configuration [#236788](https://github.com/elastic/kibana/pull/236788).
- Fixes malformed synthetics package policies [#236176](https://github.com/elastic/kibana/pull/236176).
- Reverts filter policy inputs [#236104](https://github.com/elastic/kibana/pull/236104).
- Removes extra synthetics package policies [#235200](https://github.com/elastic/kibana/pull/235200).


## 9.1.4


### Enhancements

- Save button is disabled in user-specific system prompt flyout when there's no input [#233184](https://github.com/elastic/kibana/pull/233184).


## 9.1.3


### Fixes

- Fixes Synthetics monitor filters [#231562](https://github.com/elastic/kibana/pull/231562).


## 9.1.2


### Fixes

- Fixes lock manager setup bug [#230519](https://github.com/elastic/kibana/pull/230519).
- Adds timestamp range filter to exclude frozen tier [#230375](https://github.com/elastic/kibana/pull/230375).
- Adjusts end-to-end onboarding tests to work in serverless environment [#229969](https://github.com/elastic/kibana/pull/229969).


## 9.1.1


### Fixes

- Fixes global parameters sync for non-default private locations [#230157](https://github.com/elastic/kibana/pull/230157).


## 9.1.0


### Features and enhancements

- Adds the anonymization advanced setting for Observability AI Assistant [#224607](https://github.com/elastic/kibana/pull/224607).
- Allows users to change the Knowledge Base model post-installation in AI Assistant Settings [#221319](https://github.com/elastic/kibana/pull/221319).
- Adds ELSER and e5 on EIS [#220993](https://github.com/elastic/kibana/pull/220993).
- Only shows ELSER in EIS if the pre-configured endpoint is available [#220096](https://github.com/elastic/kibana/pull/220096).
- Allows users to specify a Knowledge Base model to support non-English languages [#218448](https://github.com/elastic/kibana/pull/218448).
- Allows users to archive conversations with the AI Assistant [#216012](https://github.com/elastic/kibana/pull/216012).
- Allows users to share AI Assistant conversations [#211854](https://github.com/elastic/kibana/pull/211854).
- Adds accordion sections for the **Attributes** tables [#224185](https://github.com/elastic/kibana/pull/224185).
- Allows users to add the APM trace waterfall to other solutions [#216098](https://github.com/elastic/kibana/pull/216098).
- Adds the **History** tab view for calendar-based SLOs to the SLO details page [#223825](https://github.com/elastic/kibana/pull/223825).
- Allows users to view definitions, delete SLOs, and purge SLI data from a single page, without needing to consider instances [#222238](https://github.com/elastic/kibana/pull/222238).
- Adds the **Definition** tab to SLO pages [#212826](https://github.com/elastic/kibana/pull/212826).
- Adds suggested dashboards to alerts [#223424](https://github.com/elastic/kibana/pull/223424).
- Adds the **Add to case** button to alerts [#223184](https://github.com/elastic/kibana/pull/223184).
- Allows users to save `group by` information with dynamic mapping for custom threshold rules [#219826](https://github.com/elastic/kibana/pull/219826).
- Allows users to link dashboards in **Rules** and **Alerts** pages [#219019](https://github.com/elastic/kibana/pull/219019).
- Allows users to add an investigation guide to alert **Details** pages [#217106](https://github.com/elastic/kibana/pull/217106).
- Adds KQL filter to TLS alerting rule [#215110](https://github.com/elastic/kibana/pull/215110).
- Adds the `context.grouping` action variable in SLO burn rate and Elasticsearch query rules [#213550](https://github.com/elastic/kibana/pull/213550).
- Adds the `context.grouping` action variable in custom threshold and APM rules [#212895](https://github.com/elastic/kibana/pull/212895).
- Allows users to generate an alert for each row in query results in the Elasticsearch query ES|QL rule [#212135](https://github.com/elastic/kibana/pull/212135).
- Adds filter controls on Observability **Alerts** pages [#198495](https://github.com/elastic/kibana/pull/198495).
- Adds support for maintenance windows in Synthetics [#222174](https://github.com/elastic/kibana/pull/222174).
- Allows users to choose the spaces where Synthetics monitors are available [#221568](https://github.com/elastic/kibana/pull/221568).
- Allows users to rename private location labels and tags in Synthetics [#221515](https://github.com/elastic/kibana/pull/221515).
- Adds monitor downtime alert when Synthetics monitor has no data [#220127](https://github.com/elastic/kibana/pull/220127).
- Adds a compact view to the Synthetics **Overview** page [#219060](https://github.com/elastic/kibana/pull/219060).
- Adds drilldown functionality to Synthetics stats overview embeddable [#217688](https://github.com/elastic/kibana/pull/217688).
- Adds failure store metrics to the **Data Set Quality** page [#220874](https://github.com/elastic/kibana/pull/220874).
- Adds support for span links in the service map [#215645](https://github.com/elastic/kibana/pull/215645).
- Adds support for `GroupStreamDefinition` to `/api/streams` endpoints [#208126](https://github.com/elastic/kibana/pull/208126).
- Submits a comment in cases by pressing **+ Enter** [#228473](https://github.com/elastic/kibana/pull/228473).
- Updates SLO starter prompt [#224493](https://github.com/elastic/kibana/pull/224493).
- Integrates new tail sampling settings [#224479](https://github.com/elastic/kibana/pull/224479).
- Gets model ID from anonymization rules [#224280](https://github.com/elastic/kibana/pull/224280).
- Prefer `observabilityAIAssistantAPIClient` over supertest [#222753](https://github.com/elastic/kibana/pull/222753).
- Updates system prompt to inform about anonymization [#224211](https://github.com/elastic/kibana/pull/224211).
- Adds investigation guide empty state [#223974](https://github.com/elastic/kibana/pull/223974).
- Adds anonymization support [#223351](https://github.com/elastic/kibana/pull/223351).
- Remove `semantic_text` migration [#220886](https://github.com/elastic/kibana/pull/220886)
- Remaps `iInCircle` and `questionInCircle` and deprecates `help` icon [#223142](https://github.com/elastic/kibana/pull/223142).
- Shows cases on alert detail overview [#222903](https://github.com/elastic/kibana/pull/222903).
- Removes is_correction and confidence attributes from knowledge base entry [#222814](https://github.com/elastic/kibana/pull/222814).
- Refetches alert detail rule data on edit flyout submit [#222118](https://github.com/elastic/kibana/pull/222118).
- Adds new rule form to the **Create rule** flyout [#206685](https://github.com/elastic/kibana/pull/206685)
- Updates spec.max to 3.4 [#221544](https://github.com/elastic/kibana/pull/221544).
- Adds EDOT logging level to central config [#219722](https://github.com/elastic/kibana/pull/219722).
- Adds 'logging_level' agent configuration setting for EDOT Node.js [#222883](https://github.com/elastic/kibana/pull/222883).
- Adds 'deactivate_...' agent configuration settings for EDOT Node.js [#224502](https://github.com/elastic/kibana/pull/224502)
- Removes metrics and logs from get_service_stats API [#218346](https://github.com/elastic/kibana/pull/218346).
- Adds **Logs** tab to mobile services [#209944](https://github.com/elastic/kibana/pull/209944)
- Removes double confirmation when deleting conversation [#217991](https://github.com/elastic/kibana/pull/217991).
- Updates 790 deployment environment discrepancy [#217899](https://github.com/elastic/kibana/pull/217899).
- Adds embeddable Trace Waterfall Enhancements [#217679](https://github.com/elastic/kibana/pull/217679).
- Returns 404 if `screenshot_ref` only when truly not present [#215241](https://github.com/elastic/kibana/pull/215241).
- Adds the ability to create an APM availability or latency SLO for all services [#214653](https://github.com/elastic/kibana/pull/214653).
- Handle `ELASTIC_PROFILER_STACK_TRACE_IDS` for `apm-profiler` integration [#217020](https://github.com/elastic/kibana/pull/217020)
- Includes `spaceID` in SLI documents [#214278](https://github.com/elastic/kibana/pull/214278).
- Updates delete confirmation modal [#212695](https://github.com/elastic/kibana/pull/212695).
- Enables syntax highlighting for ES|QL [#212669](https://github.com/elastic/kibana/pull/212669).
- Shows dashboards with different ingest path on runtime metrics [#211822](https://github.com/elastic/kibana/pull/211822).
- Adds the ability for a user to create an API Key in Synthetics settings that applies only to specified spaces [#211816](https://github.com/elastic/kibana/pull/211816).
- Enables editing central config for EDOT Agents and SDKs [#211468](https://github.com/elastic/kibana/pull/211468).
- Adds the reason message to the rules recovery context [#211411](https://github.com/elastic/kibana/pull/211411).
- Removes enablement check in `PUT /api/streams/{id}` for classic streams [#212289](https://github.com/elastic/kibana/pull/212289).
- Uses bulk endpoint to import knowledge base entries [#222084](https://github.com/elastic/kibana/pull/222084).
- Changes embeddable view when only one monitor if one location is selected [#218402](https://github.com/elastic/kibana/pull/218402).
- Improves how related alerts are suggested [#215673](https://github.com/elastic/kibana/pull/215673).
- Updates handling of duplicate conversations in the AI Assistant[#208044](https://github.com/elastic/kibana/pull/208044).
- Indicates when failure store is not enabled for a data stream [#221644](https://github.com/elastic/kibana/pull/221644).


### Fixes

- Fixes for `metric_item` component [#227969](https://github.com/elastic/kibana/pull/227969).
- Fixes incorrect rendering of statistics in **TransactionsTable** [#227494](https://github.com/elastic/kibana/pull/227494).
- Injects user prompt before tool call when query actions are clicked [#227462](https://github.com/elastic/kibana/pull/227462).
- Fixes editing of private location with no monitors assigned [#227411](https://github.com/elastic/kibana/pull/227411).
- Fixes missing sparklines from **Dependencies** table [#227211](https://github.com/elastic/kibana/pull/227211).
- Shows tool validation error when processing a Gemini stream finishes with `MALFORMED_FUNCTION_CALL` [#227110](https://github.com/elastic/kibana/pull/227110).
- Makes Uptime available in stack solution view when enabled [#226999](https://github.com/elastic/kibana/pull/226999).
- Fixes product docs installation status [#226919](https://github.com/elastic/kibana/pull/226919).
- Fixes embeddings model dropdown with legacy endpoint on upgrade [#226878](https://github.com/elastic/kibana/pull/226878).
- Fixes the EIS callout being cut off for large font sizes [#226633](https://github.com/elastic/kibana/pull/226633).
- Fixes response handling of get_apm_dependencies tool call [#226601](https://github.com/elastic/kibana/pull/226601).
- Fixes span flyout in operation page [#226423](https://github.com/elastic/kibana/pull/226423).
- Collapses `*query` tool calls [#226078](https://github.com/elastic/kibana/pull/226078).
- Fixes broken operation page [#226036](https://github.com/elastic/kibana/pull/226036).
- Limits environment name length when creating Machine Learning jobs [#225973](https://github.com/elastic/kibana/pull/225973).
- Fixes schema page [#225481](https://github.com/elastic/kibana/pull/225481).
- Hides settings from Serverless navigation [#225436](https://github.com/elastic/kibana/pull/225436).
- Fixes **Agent Explorer** page [#225071](https://github.com/elastic/kibana/pull/225071).
- Adds query rewriting [#224498](https://github.com/elastic/kibana/pull/224498).
- Fixes SLO federated view bug when listed remote clusters and index name exceed 4096 bytes [#224478](https://github.com/elastic/kibana/pull/224478).
- Returns suggested dashboards only for custom threshold alerts [#224458](https://github.com/elastic/kibana/pull/224458).
- Fixes broken EDOT JVM metrics dashboard when classic agent metrics are present [#224052](https://github.com/elastic/kibana/pull/224052).
- Uses bulk helper for bulk importing knowledge base entries [#223526](https://github.com/elastic/kibana/pull/223526).
- Removes `run soon` for private location sync task [#222062](https://github.com/elastic/kibana/pull/222062).
- Adjusts example to NDJSON format [#221617](https://github.com/elastic/kibana/pull/221617).
- Prevents non-aggregatable messages from showing if no data matches [#221599](https://github.com/elastic/kibana/pull/221599).
- Deletes user instruction if text is empty [#221560](https://github.com/elastic/kibana/pull/221560).
- Checks for documents before starting semantic text migration [#221152](https://github.com/elastic/kibana/pull/221152).
- Hides data set details when `dataStream` comes from a remote cluster [#220529](https://github.com/elastic/kibana/pull/220529).
- Makes API tests more resilient [#220503](https://github.com/elastic/kibana/pull/220503).
- Removes index write blocks [#220362](https://github.com/elastic/kibana/pull/220362).
- Receives `aria-labelledby` from Elastic Charts svg [#220298](https://github.com/elastic/kibana/pull/220298).
- Queries alerts using the `alert.start` field and updates alerts function API test to check alert information [#219651](https://github.com/elastic/kibana/pull/219651).
- Fixes Alerts environment query follow up [#219571](https://github.com/elastic/kibana/pull/219571).
- Prevents flyout mode from opening on mount [#219420](https://github.com/elastic/kibana/pull/219420).
- Changes the alerts query to include environment not defined value [#219228](https://github.com/elastic/kibana/pull/219228).
- Disables using logical `AND` when filter is removed [#218910](https://github.com/elastic/kibana/pull/218910).
- Ensures index templates are created [#218901](https://github.com/elastic/kibana/pull/218901).
- Uses fields instead of `_source` in the metadata endpoint [#218869](https://github.com/elastic/kibana/pull/218869).
- Fixes span url link when transactionId missing in span Links [#218232](https://github.com/elastic/kibana/pull/218232).
- Fixes Bedrock error when displaying results and visualize query [#218213](https://github.com/elastic/kibana/pull/218213).
- Makes create annotations from keyboard navigable [#217918](https://github.com/elastic/kibana/pull/217918).
- Fixes EDOT error summary [#217885](https://github.com/elastic/kibana/pull/217885).
- Removes direct function calling from the chat input [#217359](https://github.com/elastic/kibana/pull/217359).
- Adds error text in environment filter when input is invalid [#216782](https://github.com/elastic/kibana/pull/216782).
- Changes "TPM" abbreviation to trace per minute for screen-readers [#216282](https://github.com/elastic/kibana/pull/216282).
- Fixes waterfall margin left position [#216229](https://github.com/elastic/kibana/pull/216229).
- Fixes fold/unfold button in traces waterfall explorer not clickable [#216972](https://github.com/elastic/kibana/pull/216972)
- Adds `aria-label` to transaction type select on service overview [#216014](https://github.com/elastic/kibana/pull/216014).
- Uses `nameTooltip` api for dependencies tables [#215940](https://github.com/elastic/kibana/pull/215940).
- Fixes page height of the AI Assistant app in solution views [#215646](https://github.com/elastic/kibana/pull/215646).
- Only allow `.ndjson` files when bulk importing to the knowledge base [#215433](https://github.com/elastic/kibana/pull/215433).
- Removes unnecessary field service.environment from top dependency spans endpoint [#215321](https://github.com/elastic/kibana/pull/215321).
- Updates retrieve_elastic_doc api test [#215237](https://github.com/elastic/kibana/pull/215237).
- Fixes id overflow [#215199](https://github.com/elastic/kibana/pull/215199).
- Fixes contextual insights scoring [#214259](https://github.com/elastic/kibana/pull/214259).
- Updates knowledge base installation flow [#214133](https://github.com/elastic/kibana/pull/214133).
- Always shows inspect configuration button [#213619](https://github.com/elastic/kibana/pull/213619).
- Fixes failing test in Observability stack deployments `Deployment-agnostic A…` [#213530](https://github.com/elastic/kibana/pull/213530).
- Fixes conversation tests [#213338](https://github.com/elastic/kibana/pull/213338).
- Fixes sorting in profiler storage explorer [#212583](https://github.com/elastic/kibana/pull/212583).
- Adds system message in copy conversation JSON payload [#212009](https://github.com/elastic/kibana/pull/212009).
- Removed unnecessary breadcrumbs in Universal Profiling [#211081](https://github.com/elastic/kibana/pull/211081).
- Added minHeight to profiler flamegraphs [#210443](https://github.com/elastic/kibana/pull/210443).
- Adds system message [#209773](https://github.com/elastic/kibana/pull/209773).
- Ensures that when an SLO is created, the ID is verified across all spaces [#214496](https://github.com/elastic/kibana/pull/214496).
- Fixes the **Outcome Preview** table so columns always fill the page width after a resize in **Streams** [#226000](https://github.com/elastic/kibana/pull/226000).
- Adds discernible text for the **Refresh data preview** button in **Streams** [#225816](https://github.com/elastic/kibana/pull/225816).
- Ensures the members array is unique for `GroupStreamDefinitions` in **Streams** [#210089](https://github.com/elastic/kibana/pull/210089).
- Applies chunking algorithm for `getIndexBasicStats` in Dataset Health [#221153](https://github.com/elastic/kibana/pull/221153).
- Improves finding functions in Universal Profiling [#210437](https://github.com/elastic/kibana/pull/210437).
- Adds logical `AND` to monitor tags and locations filter [#217985](https://github.com/elastic/kibana/pull/217985).


## 9.0.8


### Features and enhancements

- Allows implementation of a default LLM connector from settings [#236103](https://github.com/elastic/kibana/pull/236103).


### Fixes

- Removes span documents from `getServiceAgent` function [#236732](https://github.com/elastic/kibana/pull/236732).


## 9.0.7


### Features and enhancements

There are no user-facing changes in the 9.0.7 release.

## 9.0.6


### Fixes

- Fixes AI Assistant for Observability settings to only show for Enterprise users [#231989](https://github.com/elastic/kibana/pull/231989).


## 9.0.5


### Features and enhancements

- Submit a comment in a case by pressing `ctrl/cmd` + `enter` [#228473](https://github.com/elastic/kibana/pull/228473).


### Fixes

- Instructs AI Assistant not to perform destructive actions [#229497](https://github.com/elastic/kibana/pull/229497).
- Fixes service error for table column sorting [#229199](https://github.com/elastic/kibana/pull/229199).
- Fixes Dependencies inventory page issue where loading spinner spins indefinitely when no data exists [#228094](https://github.com/elastic/kibana/pull/228094).


## 9.0.4


### Fixes

- Fixes missing sparklines in the Dependencies table in the APM UI [#227211](https://github.com/elastic/kibana/pull/227211).
- Fixes legacy Uptime monitoring UI not showing when turned on [#226999](https://github.com/elastic/kibana/pull/226999).
- Fixes response handling of `get_apm_dependencies` tool call [#226601](https://github.com/elastic/kibana/pull/226601).
- Fixes query function calls when using Claude LLM [#226078](https://github.com/elastic/kibana/pull/226078).
- Fixes Agent Explorer boundary errors  [#225071](https://github.com/elastic/kibana/pull/225071).
- Fixes broken EDOT JVM metrics dashboard when classic APM agent metrics are present [#224052](https://github.com/elastic/kibana/pull/224052).


## 9.0.3


### Enhancements

- Improve the system prompt and instructions for working with Claude models [#221965](https://github.com/elastic/kibana/pull/221965).


### Fixes

- Tool instructions are no longer shown in the system message when tools are disabled [#223278](https://github.com/elastic/kibana/pull/223278).


## 9.0.2


### Enhancements

- Enhanced the handling of missing `service.environment` attributes [#217899](https://github.com/elastic/kibana/pull/217899).


### Fixes

- Fixes issue with updating SLOs created in a version later than 8.18 that were failing due to an invalid ingest pipeline [#221158](https://github.com/elastic/kibana/pull/221158).
- Fixes `error_marker.tsx` to support mobile-services [#220424](https://github.com/elastic/kibana/pull/220424).
- Fixes alerts environment query follow up [#219571](https://github.com/elastic/kibana/pull/219571).
- Fixes the alerts query to include "environment not defined" value [#219228](https://github.com/elastic/kibana/pull/219228).


## 9.0.1


### Fixes

- Fixes an error that prevented query results from displaying and visualizing correctly in Bedrock [#218213](https://github.com/elastic/kibana/pull/218213)


## 9.0.0


### Features and enhancements

- Improves SLO navigation by separating details from the overview panel [#212826](https://github.com/elastic/kibana/pull/212826)
- Enables the new Borealis theme [#210468](https://github.com/elastic/kibana/pull/210468)
- Returns a 404 response only when the `screenshot_ref` is truly missing [#215241](https://github.com/elastic/kibana/pull/215241)
- Includes the `spaceId` field in Service Level Indicator (SLI) documents [#214278](https://github.com/elastic/kibana/pull/214278)
- Includes the recovery reason message in the rule context [#211411](https://github.com/elastic/kibana/pull/211411)
- Enhances Synthetic SLOs by adding location context and correcting badge link behavior [#210695](https://github.com/elastic/kibana/pull/210695)
- Updates the default sampling frequency to 19Hz [#202278](https://github.com/elastic/kibana/pull/202278)


### Fixes

- Resolves an issue that prevented the chat feature from functioning correctly on the Alerts page [#197126](https://github.com/elastic/kibana/pull/197126)
- Addresses a missing versioning issue in `inventory_view_saved_object` that could prevent the Observability Infrastructure Inventory view from loading post-upgrade [#207007](https://github.com/elastic/kibana/pull/207007)
- Enables the use of wildcard filters in SLO queries [#213119](https://github.com/elastic/kibana/pull/213119)
- Updates the `Close project` navigation label to `Log out` to better reflect the intended action for users in serverless environments [#211463](https://github.com/elastic/kibana/pull/211463)
- Fixes an issue where clicking a name badge for a synthetics monitor led to a page that failed to load monitor details [#210695](https://github.com/elastic/kibana/pull/210695)
- Fixes code scanning alert no. 456: Incomplete string escaping or encoding [#193909](https://github.com/elastic/kibana/pull/193909)
- Fixes code scanning alert: Incomplete string escaping or encoding [#193365](https://github.com/elastic/kibana/pull/193365)