﻿---
title: Kibana known issues
description: For Elastic Observability known issues, refer to Elastic Observability known issues. For Elastic Security known issues, refer to Elastic Security known...
url: https://www.elastic.co/docs/release-notes/kibana/known-issues
products:
  - Kibana
---

# Kibana known issues
For Elastic Observability known issues, refer to [Elastic Observability known issues](https://www.elastic.co/docs/release-notes/observability/known-issues).
For Elastic Security known issues, refer to [Elastic Security known issues](https://www.elastic.co/docs/release-notes/security/known-issues).
<dropdown title="The connection between agentless integrations and Fleet Server is broken" applies-to="Elastic Cloud Hosted: Generally available">
  Applies to: Elastic Stack <9.1.6**Details**When agentless integrations are deployed in Fleet in an Elastic Cloud Hosted deployment, the connection between the agentless integrations and Fleet Server can be broken if the default Fleet Server host URL is modified or if a different host URL is set as the default.**Resolved**This issue is resolved in Elastic Stack 9.1.6.
</dropdown>

<dropdown title="Alerts aren't generated for rules with alert flapping off and an alert delay higher than 1">
  Applies to: Elastic Stack 9.0.0-9.2.0**Details**Alerts aren't generated for rules that have **Alert flapping detection** turned off and the alert delay set to a value higher than 1.**Workaround**Set the alert delay value to 1 or turn on **Alert flapping detection**.
</dropdown>

<dropdown title="Reports created in non-default Kibana spaces aren't shown in the Reporting UI">
  Applies to: Elastic Stack 9.1.0, 9.1.1**Details**After creating a report in a non-default Kibana space, the document exists in the `.kibana-reporting` index but isn't shown in the Reporting UI.
</dropdown>

<dropdown title="Issues with rules occur when xpack.alerting.rules.run.alerts.max is set to a value greater than 5000">
  Applies to: Elastic Stack 9.0.3, 9.0.4, 9.1.0**Details**If you've set `xpack.alerting.rules.run.alerts.max` to a value greater than `5000`, you will encounter `Result window is too large` error messages when a maintenance window is active.**Action**To mitigate the issue, set `xpack.alerting.rules.run.alerts.max` to a value equal to or less than `5000`.**Resolved**This issue is resolved in Elastic Stack 9.1.0 and 9.1.2.
</dropdown>

<dropdown title="PDF and PNG reports time out and fail with an invalid header error if server.protocol is set to http2">
  Applies to: Elastic Stack 9.0.0**Details**Starting in  9.0.0, the default value of `server.protocol` is `http2`. PDF and PNG reports will fail when this setting is used in this release.**Action**To temporarily resolve the issue, set `server.protocol` to `http1`.**Resolved**This issue is resolved in Elastic Stack 9.0.0, 9.0.4, 9.1.0.
</dropdown>

<dropdown title="Dashboard Copy link doesn't work when sharing from a space other than the default space">
  Applies to: Elastic Stack 9.0.3**Details**When attempting to share a dashboard from a space that isn't the default space, the **Copy link** action never completes.**Action**To avoid this error, don't upgrade Kibana to Elastic Stack 9.0.3 or upgrade Kibana to Elastic Stack 9.0.4 when available.**Resolved**This issue is resolved in Elastic Stack 9.0.4.
</dropdown>

<dropdown title="Upgrading Kibana from 8.18.x to 9.0.2 fails due to a configuration conflict in the kibana.yml file">
  Applies to: Elastic Stack 9.0.2**Details**Upgrading Kibana from version 8.18.x to 9.0.2 fails due to a configuration conflict if `xpack.alerting.cancelAlertsOnRuleTimeout` is set to `false` in the `kibana.yml` file. Kibana fails to boot and shows a fatal error message in the Kibana logs that's similar to the following:
  ```
  FATAL Error: Rule type "transform_health" cannot have both cancelAlertsOnRuleTimeout set to false and autoRecoverAlerts set to true.
  ```
  This failure occurs when the `xpack.alerting.cancelAlertsOnRuleTimeout` setting is set to `false`, which is incompatible with the default configuration of an internal setting (`autoRecoverAlerts`) in 9.0.2.**Action**To temporarily resolve the issue and allow the upgrade to proceed, follow these steps:
  1. Remove the `xpack.alerting.cancelAlertsOnRuleTimeout: false` setting from the `kibana.yml` file.
  2. Restart Kibana to apply the changes.
  **Resolved**This was resolved in Elastic Stack 9.0.3.
</dropdown>

<dropdown title="Errors in rule executions occur when maintenance windows have filters">
  Applies to: Elastic Stack 9.0.0, 9.0.1, 9.0.2**Details**
  Errors occur when rules run during an active maintenance window that has filters and a matching rule category.**Workaround**
  Remove any filters added to the active maintenance window.**Resolved**This was resolved in Elastic Stack 9.0.3.
</dropdown>

<dropdown title="Issue with follower indices during upgrade">
  Applies to: Elastic Stack 9.0.0**Details**In Upgrade Assistant, follower indices may be identified to be reindexed. However, this is not a valid migration path and will result in an error. Instead, the recommendation is to mark as read-only and unfollow the leader index. Cross-cluster replication on that index will not be possible.Find additional information in the [upgrade documentation](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade#upgrade-ccr-data-streams).
</dropdown>

<dropdown title="Unexpected deprecation warnings for APM indices during upgrade">
  Applies to: Elastic Stack 9.0.0**Details**When upgrading an Elastic Cloud Hosted deployment to Elastic Stack 9.0.0, you may see deprecation warnings for APM indices, even if you are not using APM.If your deployment ever ran on Elastic Stack 7.x, these APM indices have been created automatically at that time, even if you didn't use APM. In this case, these indices exist and are empty.**Action**To proceed with the upgrade to 9.0.0, you must resolve all deprecation notices for indices beginning with the name `apm-7` by selecting **Mark as read-only** for each of them.
</dropdown>

<dropdown title="Upgrade Assistant - Rollup jobs need to be stopped before rollup indices are reindexed">
  Applies to: Elastic Stack 9.0.0**Details**Rollup indices, like all indices, created in 7.x or earlier need to be reindexed in preparation for migration to 9.0. However, in addition to the normal reindex process the rollup job also needs to be accounted for.**Action**Stop the rollup job before reindexing begins otherwise there may be a gap in rollup data. You can restart the job can after reindexing is complete.This needs to be performed manually until addressed in the upgrade assistant code.View [#211850](https://github.com/elastic/kibana/issues/211850).
</dropdown>