﻿---
title: Kibana deprecations
description: Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for...
url: https://www.elastic.co/docs/release-notes/kibana/deprecations
products:
  - Kibana
---

# Kibana deprecations
Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for a period before removal, giving you time to update your applications.
Review the deprecated functionality for Kibana. While deprecations have no immediate impact, we strongly encourage you update your implementation after you upgrade. To learn how to upgrade, check out [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade).

## 9.3.0

There are no deprecations in this version.

## 9.2.0

There are no deprecations in this version.

## 9.1.0

There are no deprecations in this version.

## 9.0.0

<dropdown title="HTTP/2 becomes the default protocol when TLS is enabled">
  **Details** Starting from version 9.0.0, HTTP/2 is the default protocol when TLS is enabled. This ensures improved performance and security. However, if HTTP/2 is not enabled or TLS is not configured, a deprecation warning will be added.**Impact** Systems that have TLS enabled but don’t specify a protocol will start using HTTP/2 in 9.0.0. Systems that use HTTP/1 or don’t have TLS configured will get a deprecation warning.**Action** Verify that TLS is properly configured by enabling it and providing valid certificates in the settings. Test your system to ensure that connections are established securely over HTTP/2.If your Kibana server is hosted behind a load balancer or reverse proxy we recommend testing your deployment configuration before upgrading to 9.0.View [#204384](https://github.com/elastic/kibana/pull/204384).
</dropdown>

<dropdown title="Scripted field creation has been disabled in the Data Views management page">
  The ability to create new scripted fields has been removed from the **Data Views** management page in 9.0. Existing scripted fields can still be edited or deleted, and the creation UI can be accessed by navigating directly to `/app/management/kibana/dataViews/dataView/{{dataViewId}}/create-field`, but we recommend migrating to runtime fields or ESQL queries instead to prepare for removal.**Impact** It will no longer be possible to create new scripted fields directly from the **Data Views** management page.**Action** Migrate to runtime fields or ESQL instead of creating new scripted fields. Existing scripted fields can still be edited or deleted.View [#202250](https://github.com/elastic/kibana/pull/202250).
</dropdown>