﻿---
title: Kibana release notes
description: Review the changes, fixes, and more in each version of Kibana. To check for security updates, go to Security announcements for the Elastic stack. Elastic...
url: https://www.elastic.co/docs/release-notes/kibana
products:
  - Kibana
---

# Kibana release notes
Review the changes, fixes, and more in each version of Kibana.
To check for security updates, go to [Security announcements for the Elastic stack](https://discuss.elastic.co/c/announcements/security-announcements/31).

## 9.3.0


### Features and enhancements

**Elastic Agent Builder**:
- [Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder) is now generally available. It is enabled by default in Elasticsearch solution environments, and you can opt in to **Agent Builder** and its **AI Agent** chat experience in Observability and Security solution environments. Learn how to [get started](https://www.elastic.co/docs/explore-analyze/ai-features/agent-builder/get-started).

**Alerting**:
- Supports searching for report schedules by title and creator [#243841](https://github.com/elastic/kibana/pull/243841).
- Provides fields for specifying cc and bcc recipients, the subject line, and the message for scheduled report email notifications [#242922](https://github.com/elastic/kibana/pull/242922).
- Enables incremental human-readable case IDs [#238555](https://github.com/elastic/kibana/pull/238555).
- Adds option to delete report schedules [#238197](https://github.com/elastic/kibana/pull/238197).
- Alert cleanup is now generally available [#247465](https://github.com/elastic/kibana/pull/247465).
- Adds search to the new **Attachments** tab in cases [#246265](https://github.com/elastic/kibana/pull/246265).
- Adds support for searching rules by their actions' params using the API [#246123](https://github.com/elastic/kibana/pull/246123).
- Scheduled reports are now generally available [#245882](https://github.com/elastic/kibana/pull/245882).
- The Slack connector can now be configured to send messages to any channel using channel names [#245423](https://github.com/elastic/kibana/pull/245423).
- Improves search on the case management page [#245321](https://github.com/elastic/kibana/pull/245321).
- Adds option to enable disabled report schedules [#244202](https://github.com/elastic/kibana/pull/244202).
- Disable flapping per rule - schema only changes [#243855](https://github.com/elastic/kibana/pull/243855).
- Centralizes tabs for different attachement types under the new **Attachments** tab in cases [#243708](https://github.com/elastic/kibana/pull/243708).
- Adds a date time picker to the cases management page to help you find cases that were created during a specific time range [#243409](https://github.com/elastic/kibana/pull/243409).
- Adds option to edit report schedules [#241928](https://github.com/elastic/kibana/pull/241928).
- Improves UI for specifying additional fields for IBM Resilient action [#238869](https://github.com/elastic/kibana/pull/238869).
- Makes Agent ID the default observables type [#238533](https://github.com/elastic/kibana/pull/238533).
- Adds `kibana.alert.index_pattern` to all Stack alerts. This change doesn't affect detection alerts [#239450](https://github.com/elastic/kibana/pull/239450).

**Connectivity**:
- Elastic will regularly be adding new AI models from 9.3 onwards which will appear as pre-configured AI connectors in  Kibana. Refer to [the Elastic Inference Service page](https://www.elastic.co/docs/explore-analyze/elastic-inference/eis) for more details.
- Adds Groq to the list of available providers for the Inference/AI Connector and for Inference endpoint creation [#244962](https://github.com/elastic/kibana/pull/244962).
- Introduces a Brave Search connector [#245329](https://github.com/elastic/kibana/pull/245329).
- The webhook connector now supports the following HTTP request methods: POST(default), PUT, PATCH, GET, and DELETE [#238072](https://github.com/elastic/kibana/pull/238072).
- Adds new preconfigured connectors and updates existing ones [#242791](https://github.com/elastic/kibana/pull/242791).
- Adds a new temperature parameter to AI Connector and to OpenAI, Bedrock, and Gemini connectors [#239806](https://github.com/elastic/kibana/pull/239806).
- Adds support for headers in the OpenAI integration [#238710](https://github.com/elastic/kibana/pull/238710).

**Dashboards and Visualizations**:
- Dashboards now support ownership and "write_restricted" mode. You can now keep dashboards publicly editable or in a write-restricted state until they are ready to be published, giving you more control over who can edit your dashboards, regardless of broader space permissions [#224552](https://github.com/elastic/kibana/pull/224552).
- Adds support for chaining variable controls. You can now set up variable controls to depend on the values selected for another variable control [#242909](https://github.com/elastic/kibana/pull/242909).
- Adds basic filtering support for interactions with ES|QL charts [#243439](https://github.com/elastic/kibana/pull/243439).
- Removes the **Supporting visualization** section heading from the Primary Metric editor. All configuration options remain fully accessible in the same location under **Appearance** [#245979](https://github.com/elastic/kibana/pull/245979).
- Reorganizes and renames color settings in the Primary Metric dimension editor. For numeric metrics, the "Color by value" and "Color mapping"/"Color" settings are now located under the "Background chart" field. The settings have been renamed as follows: "Color by value" is now "Color mode", and "Color mapping" is now "Dynamic color mapping" [#243608](https://github.com/elastic/kibana/pull/243608).
- In **dashboard visualization in-line editing** and **Lens workspace**, the 'Appearance', 'Titles and text', 'Axis', and 'Legend' settings have been moved from a popover into a dedicated flyout panel [#240804](https://github.com/elastic/kibana/pull/240804).
- Moves the Lens visualization toolbar from the workspace section to the configuration panel [#239879](https://github.com/elastic/kibana/pull/239879)
- Moves the **Save as** and **Reset** options under the top nav **Save** button when the dashboard is in edit mode [#237211](https://github.com/elastic/kibana/pull/237211).
- The Lens configuration panel has been redesigned to display layers as tabs instead of vertically stacked panels. Layer actions (clone, remove, save) are now accessible through a menu in each tab, improving the editing experience when working with multiple data layers, annotations, and reference lines [#235372](https://github.com/elastic/kibana/pull/235372).

**Data ingestion and Fleet**:
- Enables integration knowledge generation by default and adds a UI setting that allows you to opt out of the integration knowledge indexing [#245080](https://github.com/elastic/kibana/pull/245080).
- Enables rolling back integrations to the previously installed version [#240761](https://github.com/elastic/kibana/pull/240761).
- Adds capability for rolling back a recent upgrade of a Fleet-managed Elastic Agent using Fleet UI or API [#247398](https://github.com/elastic/kibana/pull/247398), [#249416](https://github.com/elastic/kibana/pull/249416).
- Adds functionality for removing root privilege from Fleet-managed agents if applicable [#237790](https://github.com/elastic/kibana/pull/237790).
- Adds **Advanced Internal YAML Settings** field to the agent policy settings UI [#245819](https://github.com/elastic/kibana/pull/245819).
- Redesigns the Actions menu in Fleet, placing commonly used actions at the top level and organizing other actions into nested menus by use case [#245174](https://github.com/elastic/kibana/pull/245174).
- Auto-migrates component templates to use `type@lifecycle` ILM policies during Fleet setup [#243333](https://github.com/elastic/kibana/pull/243333).
- Adds a cleanup task that removes excess policy revisions from the `.fleet-policies` index [#242612](https://github.com/elastic/kibana/pull/242612).
- Uses `type@lifecycle` ILM policies for new package installations [#241992](https://github.com/elastic/kibana/pull/241992).
- Adds the `xpack.fleet.experimentalFeatures` config setting [#238840](https://github.com/elastic/kibana/pull/238840).
- Adds a **Show agentless resources** toggle on the Fleet > Settings page for debugging and diagnostics [#237528](https://github.com/elastic/kibana/pull/237528).
- Adds Fleet Server host authentication settings for Elastic Agent > Fleet Server SSL support [#236959](https://github.com/elastic/kibana/pull/236959).
- Persists the state of filters in the agent list table while navigating within a session [#228875](https://github.com/elastic/kibana/pull/228875).

**Discover**:
- Discover now shows partial results after a search gets canceled [#242346](https://github.com/elastic/kibana/pull/242346).
- Background search is now enabled by default in all environments [#242105](https://github.com/elastic/kibana/pull/242105).
- Adds a “Copy as Markdown” option for selected results [#245545](https://github.com/elastic/kibana/pull/245545).
- Optimizes performance by avoiding redundant requests when breakdown or chart interval changes [#245523](https://github.com/elastic/kibana/pull/245523).
- Shows multi-fields in the document viewer by default in ES|QL mode [#245890](https://github.com/elastic/kibana/pull/245890).
- Adds support for filtering multivalue fields by interacting with the results table in ES|QL mode [#245554](https://github.com/elastic/kibana/pull/245554).
- Improves the lookup index editor interface available in ES|QL mode [#244480](https://github.com/elastic/kibana/pull/244480).
- Improves the file upload section of the lookup index editor interface [#244550](https://github.com/elastic/kibana/pull/244550).
- Saving an ES|QL query's visualization to a dashboard now brings any related controls along with it [#237070](https://github.com/elastic/kibana/pull/237070).
- Updates the icon in the document viewer to add or remove a field in the main documents table [#246024](https://github.com/elastic/kibana/pull/246024).

**ES|QL editor**:
- Adds a **Quick search** functionality that helps you turn free-text inputs into ES|QL WHERE clauses [#242123](https://github.com/elastic/kibana/pull/242123).
- Adds support for multi-value variables using MV_CONTAINS functions [#239266](https://github.com/elastic/kibana/pull/239266).
- Adds inline suggestions to ES|QL queries  [#235162](https://github.com/elastic/kibana/pull/235162).
- Allows selecting field data type in the lookup index editor interface of the ES|QL editor [#241637](https://github.com/elastic/kibana/pull/241637).
- Adds support for expressions in functions [#236343](https://github.com/elastic/kibana/pull/236343).
- Improves computed suggestions for expressions [#246421](https://github.com/elastic/kibana/pull/246421).
- Renders string-only suggestions for Like and RLike operators [#244903](https://github.com/elastic/kibana/pull/244903).
- Improves validation and autocomplete suggestions for the CASE function [#244280](https://github.com/elastic/kibana/pull/244280).
- Adds context-aware suggestion ordering with categorization [#243312](https://github.com/elastic/kibana/pull/243312).
- Suggests adding curly braces after the `WITH` keyword for RERANK and COMPLETION commands [#243047](https://github.com/elastic/kibana/pull/243047).
- Adds support for new exponential_histogram Elasticsearch field type [#242748](https://github.com/elastic/kibana/pull/242748).
- Wraps the fork subcommands inside a`parens` node [#242369](https://github.com/elastic/kibana/pull/242369).
- Improves the quality of context-based suggestions [#241081](https://github.com/elastic/kibana/pull/241081).
- Adds autocomplete suggestions for expressions in LOOKUP JOIN commands [#240735](https://github.com/elastic/kibana/pull/240735).
- Applies the breakdown field before applying time bucketing in STATS BY commands to preserve consistent sorting across buckets in ES|QL queries [#239685](https://github.com/elastic/kibana/pull/239685).

**Elastic Observability solution**:
For the Elastic Observability 9.3.0 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.3.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Adds buttons to the time picker component to quickly shift the selected time range backward and forward, and adds timezone information to the time picker popover [#243020](https://github.com/elastic/kibana/pull/243020).
- Adds cross-tab syncing for recently used time ranges [#242467](https://github.com/elastic/kibana/pull/242467).
- The `defaultRoute` advanced setting now controls the target of the Elastic logo link for spaces using a solution view [#241571](https://github.com/elastic/kibana/pull/241571).
- The name of the deployment now appears in the navigation breadcrumb on Elastic Cloud Hosted [#238078](https://github.com/elastic/kibana/pull/238078).
- Enforces the `object_src 'none'` directive in Kibana's Content Security Policy and introduces a new `csp.object_src` configuration option to control its behavior
- Containers now set the default Node.js heap to 75% of available memory up to a maximum of 4096 Mb.  Previously, this was set to 50% [#246073](https://github.com/elastic/kibana/pull/246073).
- Linux now supports the `populate_file_data` advanced option which enables `entropy` and `header_bytes` fields in file events [#246197](https://github.com/elastic/kibana/pull/246197).
- Adds the ability to cancel file uploads [#241297](https://github.com/elastic/kibana/pull/241297).

**Kibana security**:
- The **API keys** management page now defaults to showing personal API keys only [#245261](https://github.com/elastic/kibana/pull/245261).
- Adds a warning when deleting API keys currently used by alerting rules [#243353](https://github.com/elastic/kibana/pull/243353).
- Adds the ability to specify the origin(s) of authentication providers that appear to users logging in to Kibana [#239993](https://github.com/elastic/kibana/pull/239993).
- Enhances the error message to include detailed information about why a role is considered as malformed [#239098](https://github.com/elastic/kibana/pull/239098).
- Removes the `AI Assistants Settings` privilege [#239144](https://github.com/elastic/kibana/pull/239144).

**Machine Learning**:
- Adds an optional `timeout` parameter to the Inference chat model [#248326](https://github.com/elastic/kibana/pull/248326).
- Adds Security machine learning modules for GCP Audit and Azure Activity Logs [#236849](https://github.com/elastic/kibana/pull/236849).
- Removes median line length anomaly detection categorization check [#243827](https://github.com/elastic/kibana/pull/243827).
- Adds custom header support to inference endpoints creation UI [#242187](https://github.com/elastic/kibana/pull/242187).
- Improves the layout for custom inference endpoint UI [#241779](https://github.com/elastic/kibana/pull/241779).
- Adds an action to create an anomaly detection alerting rule [#241274](https://github.com/elastic/kibana/pull/241274).
- Makes the machine learning update space APIs public [#241109](https://github.com/elastic/kibana/pull/241109).
- Improves display of long fields values in top values list [#241006](https://github.com/elastic/kibana/pull/241006).
- Adds the ability to narrow down the list of anomalies that the Anomaly detection rule looks for [#240100](https://github.com/elastic/kibana/pull/240100).
- Adds feedback button to the Anomaly Explorer and Single Metric Viewer [#239883](https://github.com/elastic/kibana/pull/239883).

**Search**:
- When creating a new Elasticsearch solution project, you will now land on the **Elasticsearch home page** by default instead of the **Create index** page to get immediate access to relevant tutorials and educational content [#237612](https://github.com/elastic/kibana/pull/237612).
- Adds a new getting started page within the Elasticsearch solution which offers hands-on feature tutorials. This page defaults as the initial destination for users creating a new Elasticsearch solution project [#245311](https://github.com/elastic/kibana/pull/245311).
- Adds a clear confirmation when an element has been successfully copied using one of the available **Copy** buttons on the Elasticsearch solution home page [#246090](https://github.com/elastic/kibana/pull/246090).
- Adds callouts and guided tours to Kibana's Elasticsearch solution UI on Elastic Cloud Hosted and Serverless to provide better introductions to Elastic Inference Service endpoints. You can dismiss callouts and tours, which will not reappear after dismissal [#244626](https://github.com/elastic/kibana/pull/244626).
- Improves the Console UI to make key actions more intuitive. The **Play** button is now more prominent, a new **Copy to language** button provides quick access to export the selected command in your preferred coding language, and the context menu has been updated to allow you to set a default language preference [#242487](https://github.com/elastic/kibana/pull/242487).

**Workflows**:
- Elastic Workflows is now available in technical preview. Build YAML-based workflows to automate actions across Elasticsearch,Kibana, external systems, and AI. Workflows support manual, scheduled, and alert-based triggers, conditional logic, and integrations with existing connectors and Agent Builder. You must turn on the feature to get started. Refer to [Set up workflows](https://www.elastic.co/docs/explore-analyze/workflows/setup) for more details.


### Fixes

**Alerting**:
- Fixes `cases.total_event` not showing the number of events attached to a case [#247996](https://github.com/elastic/kibana/pull/247996).
- Encodes terms searched on cases management page [#247992](https://github.com/elastic/kibana/pull/247992).
- Adds max character validation to the email connector params and config [#246453](https://github.com/elastic/kibana/pull/246453).
- Fixes an issue that caused the Security alerts table to not update columns correctly when switching view mode [#245253](https://github.com/elastic/kibana/pull/245253).
- Adds `alert.consecutiveMatches` to action context [#244997](https://github.com/elastic/kibana/pull/244997).
- Fixes case submissions becoming stale [#244543](https://github.com/elastic/kibana/pull/244543).
- Allows spaces in file paths for case observables [#244350](https://github.com/elastic/kibana/pull/244350).
- Catches connector errors without interrupting the case creation flow [#244188](https://github.com/elastic/kibana/pull/244188).
- Improves error messages for IBM connector [#244012](https://github.com/elastic/kibana/pull/244012).
- Verifies the alert exists before muting [#242847](https://github.com/elastic/kibana/pull/242847).
- Fixes auto-extraction in event bulk actions [#242325](https://github.com/elastic/kibana/pull/242325).
- Fixes Alerts table pagination being stuck on rule details page [#242275](https://github.com/elastic/kibana/pull/242275).
- Use real dimensions when taking a screenshot of {kib} layout [#242127](https://github.com/elastic/kibana/pull/242127).
- Only takes tag changes into account when connector supports them [#241944](https://github.com/elastic/kibana/pull/241944).
- Improves cases management table loading to prevent flashing [#240155](https://github.com/elastic/kibana/pull/240155).
- Fixes missing announcements in case forms to improve accessiblity [#240132](https://github.com/elastic/kibana/pull/240132).
- Adds manual focus to buttons for case actions to improve accessiblity [#239504](https://github.com/elastic/kibana/pull/239504).
- Removes `autoFocus` to preserve proper focus when modal closed [#239366](https://github.com/elastic/kibana/pull/239366).
- Fixes observables not being added to cases when auto-extract is turned on [#239000](https://github.com/elastic/kibana/pull/239000).
- Updates `nodemailer` to to 7.0.9 [#238816](https://github.com/elastic/kibana/pull/238816).
- Adds Jira's `otherFields` JSON editor to case creation flow [#238435](https://github.com/elastic/kibana/pull/238435).
- Isolates the configuration parameters for the Tines connector to the server side [#236863](https://github.com/elastic/kibana/pull/236863).
- Enables auto-extraction by default and adds user actions for case observable actions [#236524](https://github.com/elastic/kibana/pull/236524).
- Separates sync alert and auto-extract updates in case activity [#236519](https://github.com/elastic/kibana/pull/236519).
- Fixes the alert history chart background color in dark mode [#246017](https://github.com/elastic/kibana/pull/246017).
- Fixes infinite loop issue in investigation guide editor [#240472](https://github.com/elastic/kibana/pull/240472).
- Fixes missing fields when using combined filters with the `ignoreFilterIfFieldNotInIndex` advanced setting enabled [#238945](https://github.com/elastic/kibana/pull/238945).

**Connectivity**:
- Ensures that the "maximum tokens" parameter is passed as expected by the service for the Anthropic connector [#241188](https://github.com/elastic/kibana/pull/241188).
- Removes the default fallback region for the Bedrock connector [#241157](https://github.com/elastic/kibana/pull/241157).
- Ensures all authentication fields show up correctly for the AI Connector [#240913](https://github.com/elastic/kibana/pull/240913).

**Dashboards and Visualizations**:
- Cleans filters as they’re updated from Unified Search, adds extra cleanup for compound filters by removing undefined properties, and fixes unsaved badges appearing when dashboards with compound filters are loaded [#247309](https://github.com/elastic/kibana/pull/247309).
- Uses `Number.MAX_VALUE` instead of `Infinity` for the default maximum height of a panel [#243572](https://github.com/elastic/kibana/pull/243572).
- Fixes an issue where saving a dashboard after switching a Dashboard Link to an External Link caused the save function to throw an error [#243134](https://github.com/elastic/kibana/pull/243134).
- Fixes the silence warnings by silencing error notifications in Discover and Dashboards and changing the built-in URL restore error to a `console.warn` [#242788](https://github.com/elastic/kibana/pull/242788).
- Fixes a regression with print mode in Dashboard [#242780](https://github.com/elastic/kibana/pull/242780).
- Fixes an issue with sync colors and sync tooltips being turned on by default for new dashboards. Now, those options are turned off by default for new dashboards [#242442](https://github.com/elastic/kibana/pull/242442).
- Fixes an error with deselecting a "(blank)" option from an options list [#242036](https://github.com/elastic/kibana/pull/242036).
- Fixes layout issues for Markdown embeddables in small dashboard panels using CSS container queries. When a markdown panel is shorter than 120px, the UI now adapts to a compact layout that maximizes usable space [#240806](https://github.com/elastic/kibana/pull/240806).
- Labels in the **Create index** flow now render with the default **Use vector tiles** scaling as soon as label styling is applied (or after save), without requiring a scaling toggle [#240728](https://github.com/elastic/kibana/pull/240728).
- Fixes an issue where users could not reset unsaved changes after enabling time restore and changing dashboard time range [#239992](https://github.com/elastic/kibana/pull/239992).
- Fixes search session restoration issue [#239822](https://github.com/elastic/kibana/pull/239822).
- Fixes an error in the Options list control when selecting a "(blank)" value [#239791](https://github.com/elastic/kibana/pull/239791).
- Fixes an issue in the `LensConfigBuilder` that treated all dataview references the same, causing the UI to throw an error attempting to find an ad-hoc dataview that does not exist as a `SavedObject` [#239431](https://github.com/elastic/kibana/pull/239431).
- Fixes an issue in the Lens Table that broke **click to filter** on table rows when any column is used as a formula [#239222](https://github.com/elastic/kibana/pull/239222).
- Fixes metric color assignment when the breakdown and maximum options are defined in Lens [#238901](https://github.com/elastic/kibana/pull/238901).
- Fixes an issue where ad-hoc data views were not providing suggestions in the global search bar [#238731](https://github.com/elastic/kibana/pull/238731).
- Fixes an error in the **Visualize Listing** page in which an error in the visualization could cause the entire page to error. This improves the error handling to make it easier to identify which visualization is causing the problem in order to address it [#238355](https://github.com/elastic/kibana/pull/238355).
- Fixes an issue where dashboards cannot be saved when a filter pill has a combined filter using OR or AND operations [#237477](https://github.com/elastic/kibana/pull/237477).
- Fixes an issue where panels in sections are not displayed when opening the dashboard from a shared link [#237382](https://github.com/elastic/kibana/pull/237382).
- Prevents a double fetch when panels would fetch data while controls were building filters and then fetch data again once controls filters are available [#237169](https://github.com/elastic/kibana/pull/237169).
- Fixes color contrast for links in Lens [#247721](https://github.com/elastic/kibana/pull/247721).

**Data ingestion and Fleet**:
- Uses long expiration for agent auto-upgrade actions and scheduled upgrades [#243443](https://github.com/elastic/kibana/pull/243443).
- Fixes auto-upgrade logic to retry upgrade action if agents are stuck in **Updating** state [#243326](https://github.com/elastic/kibana/pull/243326).
- Adds retry behavior for `/api/fleet/agents` when transient issues with Elasticsearch are encountered [#243105](https://github.com/elastic/kibana/pull/243105).
- Fixes Docker image in the Kubernetes manifest in the Add agent instructions [#242691](https://github.com/elastic/kibana/pull/242691).
- Fixes an issue where some package icons were not loaded correctly [#242406](https://github.com/elastic/kibana/pull/242406).
- Shows warnings on sync integrations UI when referencing other entities [#241623](https://github.com/elastic/kibana/pull/241623).
- Adds the proxy SSL options to download sources if a proxy is selected [#241115](https://github.com/elastic/kibana/pull/241115).
- Omits system properties when synchronizing ingest pipelines [#241096](https://github.com/elastic/kibana/pull/241096).
- Fixes `template_path` asset selection for some integration packages [#240750](https://github.com/elastic/kibana/pull/240750).
- Allows Fleet setup retries on start in all environments [#240342](https://github.com/elastic/kibana/pull/240342).
- Fixes an issue where the uniqueness of agent policy names was not consistently enforced across spaces when name or space changes occurred [#239631](https://github.com/elastic/kibana/pull/239631).
- Fixes `ignore_above` mapping for `flattened` fields [#238890](https://github.com/elastic/kibana/pull/238890).
- Fixes a "package not found" error when skipping cloud onboarding for a prerelease package [#238629](https://github.com/elastic/kibana/pull/238629).
- Fixes an issue where new package global variables were not included and stale variable references were not removed on integration policy upgrade [#238542](https://github.com/elastic/kibana/pull/238542).
- Fixes an error that occurred when deleting orphaned integration policies [#237875](https://github.com/elastic/kibana/pull/237875).
- Enables storing secrets in Fleet Server host config if Fleet Server is running at a minimum supported version [#237464](https://github.com/elastic/kibana/pull/237464).
- Fixes MSI commands for installing Elastic Agent and Fleet Server [#236994](https://github.com/elastic/kibana/pull/236994).

**Discover**:
- Fixes an issue with the "Search entire time range" option that could exclude some results if the time field was set to date nanos [#248495](https://github.com/elastic/kibana/pull/248495).
- Fixes an issue where document viewer tabs were unnecessarily re-mounting on every refresh, leading to degraded performance [#248203](https://github.com/elastic/kibana/pull/248203).
- Fixes an issue causing query drafts to be lost when switching between tabs without running the query first in ES|QL mode [#247968](https://github.com/elastic/kibana/pull/247968).
- Fixes an issue with ES|QL tabs not loading properly [#246941](https://github.com/elastic/kibana/pull/246941).
- Fixes an issue in Discover where default app state could trigger unsaved changes in saved Discover sessions, such as default columns applied through the `defaultColumns` advanced setting [#246664](https://github.com/elastic/kibana/pull/246664).
- Fixes an issue with Discover tabs that occurs when navigating to a different tab while the previous tab is still initializing [#245752](https://github.com/elastic/kibana/pull/245752).
- Fixes truncation for longer text in the Discover table [#241440](https://github.com/elastic/kibana/pull/241440).

**ES|QL editor**:
- Displays the available options when editing an existing variable control [#239315](https://github.com/elastic/kibana/pull/239315).
- Fixes unrecognized GROK patterns [#246871](https://github.com/elastic/kibana/pull/246871).
- Fixes KEEP behavior in ES|QL when a query initially returns no results [#239063](https://github.com/elastic/kibana/pull/239063).
- Adds FORK with KEEP/STATS in the transformational commands [#240011](https://github.com/elastic/kibana/pull/240011).
- Fixes the autocomplete of timeseries sources after a comma [#241402](https://github.com/elastic/kibana/pull/241402).

**Elastic Observability solution**:
For the Elastic Observability 9.3.0 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.3.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes the serialization of `meta.error` in JSON layouts. If it is an `Error` instance, only `message`, `name`, and `stack` are included. Other fields are no longer returned in the logs [#244364](https://github.com/elastic/kibana/pull/244364).
- Fixes an issue in the component template creation flow where a new component template with `@custom` suffix in its name would lead to updating mappings of all unrelated data streams and cause a popup to appear asking to roll over conflicting ones [#237952](https://github.com/elastic/kibana/pull/237952).
- Fixes privilege requirements when reindexing indices through the upgrade assistant. Previously, the "superuser" role was required. Now, "cluster: manage" and "all" privileges for the relevant indices are sufficient [#237055](https://github.com/elastic/kibana/pull/237055).
- Fixes a case where the upgrade assistant would incorrectly warn about a node breaching the low watermark despite the max headroom setting [#243906](https://github.com/elastic/kibana/pull/243906).
- Fixes `createAuditEvents` always returning failure as outcome [#247152](https://github.com/elastic/kibana/pull/247152).
- Fixes "now" and mixed format date handling in the **Share** menu [#245539](https://github.com/elastic/kibana/pull/245539).
- Fixes favicon CSS specifity [#243351](https://github.com/elastic/kibana/pull/243351).
- Reduces re-renders on resize and items changes [#239888](https://github.com/elastic/kibana/pull/239888).
- Fixes an issue with the files management flyout crashing [#237588](https://github.com/elastic/kibana/pull/237588).
- Fixes infinite loading of roles on the **Edit space** page [#242954](https://github.com/elastic/kibana/pull/242954).
- Reflects the value selected for the `AI Assistants Visibility` GenAI setting when opening AI Assistant from the header [#239555](https://github.com/elastic/kibana/pull/239555).
- Fixes ECS-incompatible logs values [#245706](https://github.com/elastic/kibana/pull/245706).
- Fixes an issue where clients authorized to a partial list of saved object types would circumvent the Saved Objects Repository's allowed types and could list hidden saved object types [#244967](https://github.com/elastic/kibana/pull/244967).

**Kibana security**:
- Fixes an issue where fields were not case-sensitive in Kibana's user interface for creating and updating roles, though fields are case-sensitive in Elasticsearch [#246069](https://github.com/elastic/kibana/pull/246069).
- Fixes an issue preventing IDP-initiated login with multiple OIDC providers [#243869](https://github.com/elastic/kibana/pull/243869).
- Introduces a separate error for empty login attempts with SAML and OIDC providers [#237611](https://github.com/elastic/kibana/pull/237611).

**Machine Learning**:
- Disables field statistics when using the ES|QL `TS` command in Data Visualizer [#247641](https://github.com/elastic/kibana/pull/247641).
- Fixes display of Data Visualizer's map view for small screen sizes [#247615](https://github.com/elastic/kibana/pull/247615).
- Fixes anomaly chart empty query issue [#246841](https://github.com/elastic/kibana/pull/246841).
- Fixes creating new anomaly detection jobs from Discover sessions with no data view [#246410](https://github.com/elastic/kibana/pull/246410).
- Ensures Anomaly detection result chart tooltips are always shown correctly [#246077](https://github.com/elastic/kibana/pull/246077).
- Prevents clearing cell selections after hiding the alert's table popover in Anomaly explorer [#244183](https://github.com/elastic/kibana/pull/244183).
- Optimizes and enables text field analysis in contextual insights for log rate analysis [#244109](https://github.com/elastic/kibana/pull/244109).
- Ensures deleted text in the inference connector, AI connector, and inference endpoint creation forms is not sent as an empty string [#244059](https://github.com/elastic/kibana/pull/244059).
- Fixes wizard for data view with runtime fields for data frame analytics [#242557](https://github.com/elastic/kibana/pull/242557).
- Fixes import and improves validation for Anomaly detection and Data frame analytics jobs [#242263](https://github.com/elastic/kibana/pull/242263).
- Ensures max tokens parameter is passed as expected during Anthropic endpoint creation [#241212](https://github.com/elastic/kibana/pull/241212).
- Fixes index names causing incompatible cluster errors when product docs are installed for multiple inference IDs [#240506](https://github.com/elastic/kibana/pull/240506).
- Ensures inference endpoints UI list loads when provider is custom [#240189](https://github.com/elastic/kibana/pull/240189).
- Fixes layout of fields in machine learning overview and notifications pages [#239113](https://github.com/elastic/kibana/pull/239113).
- Adds unique accessible labels for **Show top field values** buttons [#237972](https://github.com/elastic/kibana/pull/237972).
- Fixes tool calling unavailable tools [#237174](https://github.com/elastic/kibana/pull/237174).
- Improves trained models list performance [#237072](https://github.com/elastic/kibana/pull/237072).
- Fixes partition field settings errors in the single metric viewer dashboard panel [#237046](https://github.com/elastic/kibana/pull/237046).
- Prevents URL-like strings from being displayed as links in alerts [#226849](https://github.com/elastic/kibana/pull/226849).
- Improves anonymization error messages when NER model is unavailable [#247696](https://github.com/elastic/kibana/pull/247696).
- Adds table caption for empty top categories in logs category table [#246041](https://github.com/elastic/kibana/pull/246041).
- Fixes broken Data Visualizer and AI Operations navigation breadcrumbs and sidebar in solutions [#248167](https://github.com/elastic/kibana/pull/248167).
- Fixes counter metric fields missing in anomaly detection dropdown [#153021](https://github.com/elastic/kibana/pull/153021).

**Search**:
- Fixes an issue when running Elasticsearch with a Basic license, where you could encounter errors when updating index mappings, even when adding non-ML field types. Mapping updates now work as expected, while advanced semantic text features continue to require the appropriate license [#248462](https://github.com/elastic/kibana/pull/248462).
- Disables 'API keys' button on the Elasticsearch home page when logged in with insufficient permissions [#248072](https://github.com/elastic/kibana/pull/248072).
- Fixes the token count display showing "NaN" in Search Playground by preserving message annotations across the AI SDK v5 stream [#246589](https://github.com/elastic/kibana/pull/246589).
- Fixes an issue with the API creation flyout size [#244072](https://github.com/elastic/kibana/pull/244072).
- Fixes a case of keyboard focus getting trapped in pages using document preview [#243791](https://github.com/elastic/kibana/pull/243791).
- Makes `elser-2-elastic` (ELSER in EIS) the default inference endpoint for adding semantic text fields. Refactors the `SelectInferenceId` component for clarity and stability, resolving a console warning and improving popover and flyout state handling [#242436](https://github.com/elastic/kibana/pull/242436).
- Fixes Agents & Playground icons in the solution side navigation to render correctly when using dark mode [#240475](https://github.com/elastic/kibana/pull/240475).
- Fixes visual issues in the data preview metadata popup when ID is too long. Adds a tooltip and copy button to improve user experience [#239768](https://github.com/elastic/kibana/pull/239768).
- Fixes an issue in RAG Playground where invalid fields displayed red styling but no error messages. Error text now appears to help you identify and correct form issues [#238284](https://github.com/elastic/kibana/pull/238284).
- Fixes an accessibility issue where resetting changes or removing all terms in the Synonyms panel was not announced by screen readers. VoiceOver users on Safari will now hear updates when terms are reset [#237877](https://github.com/elastic/kibana/pull/237877).
- The Index management mappings editor now syncs model deployment status correctly. This fixes a case where users couldn't save `semantic_text` fields during deployment without forcing [#237812](https://github.com/elastic/kibana/pull/237812).
- Fixes an issue where the retriever query copied from the "Search your data" JavaScript tutorial fails with a `parsing_exception` when passed through the query parameter in the Node.js Elasticsearch client. Retriever queries must be passed through the body parameter to ensure they are serialized correctly [#237654](https://github.com/elastic/kibana/pull/237654).
- Adds refusal field to AI Assistant conversations [#243423](https://github.com/elastic/kibana/pull/243423).
- Turns off custom suggestions on the embedded console [#241516](https://github.com/elastic/kibana/pull/241516).
- Fixes an issue where form fields were resetting automatically when editing ingest pipeline settings [#237509](https://github.com/elastic/kibana/pull/237509).


## 9.2.5


### Fixes

**Alerting**:
- Fixes timestamp override for ES|QL CSV scheduled reports with relative time ranges [#248169](https://github.com/elastic/kibana/pull/248169).

**Dashboards and Visualizations**:
- Fixes an issue with dashboard PDF/PNG reports being cut off at the end when the dashboard has a markdown panel [#249644](https://github.com/elastic/kibana/pull/249644).

**Discover**:
- Fixes an issue with the "Search entire time range" option that could exclude some results if the time field was set to date nanos [#248495](https://github.com/elastic/kibana/pull/248495).
- Fixes an issue where document viewer tabs were unnecessarily re-mounting on every refresh, leading to degraded performance [#248203](https://github.com/elastic/kibana/pull/248203).
- Fixes an issue causing query drafts to be lost when switching between tabs without running the query first in ES|QL mode [#247968](https://github.com/elastic/kibana/pull/247968).

**Elastic Observability solution**:
For the Elastic Observability 9.2.5 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.5 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes an issue with the Share menu where all time ranges were being shared as absolute [#248804](https://github.com/elastic/kibana/pull/248804).
- Fixes an issue with certain properties causing failures when adding a policy to an index template [#249168](https://github.com/elastic/kibana/pull/249168).
- Fixes an issue with duplicated managed ILM policies still appearing as managed [#248586](https://github.com/elastic/kibana/pull/248586).
- Fixes Stack Monitoring Recent Log Entries' timestamps to respect Kibana's time zone setting (`dateFormat:tz`) [#249016](https://github.com/elastic/kibana/pull/249016).
- Fixes the breadcrumb when navigating to the Stack Monitoring page while using a solution view [#249751](https://github.com/elastic/kibana/pull/249751).

**Machine Learning**:
- Fixes occasional file preview corruption during file uploads [#250532](https://github.com/elastic/kibana/pull/250532).
- Updates Packetbeat DNS tunneling datafeed to include runtime mappings [#249317](https://github.com/elastic/kibana/pull/249317).


## 9.2.4


### Features and enhancements

**Elastic Security solution**:
For the Elastic Security 9.2.4 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

### Fixes

**Alerting and cases**:
- Adds maximum character validation to the email connector params and configuration [#246453](https://github.com/elastic/kibana/pull/246453).
- Adds encoding to search terms in the **Cases** page to prevent decoding errors [#247992](https://github.com/elastic/kibana/pull/247992).
- Updates total events in Elasticsearch document when attaching an event to a case [#247996](https://github.com/elastic/kibana/pull/247996).

**Dashboards and Visualizations**:
- Fixes compound filters showing unsaved changes on dashboard load [#247309](https://github.com/elastic/kibana/pull/247309).

**Discover**:
- Fixes default app state handling when detecting unsaved changes [#246664](https://github.com/elastic/kibana/pull/246664).
- Fixes an issue with ES|QL tabs not loading properly [#246941](https://github.com/elastic/kibana/pull/246941).

**Elastic Observability solution**:
For the Elastic Observability 9.2.4 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.4 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes `createAuditEvents` always returning failure as the outcome [#247152](https://github.com/elastic/kibana/pull/247152).

**Kibana security**:
- Adds case sensitivity to the index privileges fields on the **Edit roles** page [#246069](https://github.com/elastic/kibana/pull/246069).

**Machine Learning**:
- Disables field statistics for ESQL with TS command [#247641](https://github.com/elastic/kibana/pull/247641).
- Fixes the display of map view in Data Visualizer for small screen sizes [#247615](https://github.com/elastic/kibana/pull/247615).
- Fixes an issue with queries getting malformed in anomaly charts, which was preventing the charts from rendering [#246841](https://github.com/elastic/kibana/pull/246841).

**Platform**:
- Unifies the flow for clients partially and fully authorized to saved objects, and applies the intersection of allowed and authorized lists [#244967](https://github.com/elastic/kibana/pull/244967).

**Search**:
- Fixes an issue where users running Elasticsearch with basic licenses would encounter errors when updating index mappings. Now, the Machine Learning saved object check will only run if saving semantic text mapping [#248462](https://github.com/elastic/kibana/pull/248462).


## 9.2.3


### Features and enhancements

**Data ingestion and Fleet**:
- Adds the background task `FleetPolicyRevisionsCleanupTask` which removes excess policy revisions from the `.fleet-policies` index [#242612](https://github.com/elastic/kibana/pull/242612).

**Kibana platform**:
- The **API keys** management page now defaults to showing personal API keys only [#245261](https://github.com/elastic/kibana/pull/245261).
- Adds a warning when deleting API keys currently used by alerting rules [#243353](https://github.com/elastic/kibana/pull/243353).


### Fixes

**Alerting**:
- Fixes an issue that caused the Security alerts table to not update columns correctly when switching view modes [#245253](https://github.com/elastic/kibana/pull/245253).
- Adds `consecutiveMatches` to action context [#244997](https://github.com/elastic/kibana/pull/244997).

**Discover**:
- Fixes an issue with Discover tabs that occurs when navigating to a different tab while the previous tab is still initializing [#245752](https://github.com/elastic/kibana/pull/245752).
- Fixes Discover's trace waterfall behavior with duplicate spans [#244984](https://github.com/elastic/kibana/pull/244984).

**Elastic Observability solution**:
For the Elastic Observability 9.2.3 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.3 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes "now" and mixed-format date handling in the **Share** menu [#245539](https://github.com/elastic/kibana/pull/245539).
- Fixes an issue with authentication when multiple OIDC providers are configured [#243869](https://github.com/elastic/kibana/pull/243869).
- Fixes an ECS incompatibility with the `kibana_started.elasticsearch.waitTime` value in logs [#245706](https://github.com/elastic/kibana/pull/245706).
- Fixes the serialization of `meta.error` in JSON layouts. If it is an `Error` instance, only `message`, `name`, and `stack` are included. Other fields are no longer returned in the logs [#244364](https://github.com/elastic/kibana/pull/244364).
- Fixes JVM metric conflicts with explicit cast [#244151](https://github.com/elastic/kibana/pull/244151).


## 9.2.2


### Features and enhancements

**Elastic Observability solution**:
For the Elastic Observability 9.2.2 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.2 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

### Fixes

**Alerting and cases**:
- Captures connector errors without interrupting the case creation flow. Issues with connectors can be resolved on the case details page [#244188](https://github.com/elastic/kibana/pull/244188).
- Improves error message for IBM Resilient connector failing to create an incident [#244012](https://github.com/elastic/kibana/pull/244012).
- Fixes auto-extraction of observables when alerts are added to a case using the bulk actions menu [#242325](https://github.com/elastic/kibana/pull/242325).
- Fixes pagination for the **Alerts** table, which was getting stuck on rule details pages [#242275](https://github.com/elastic/kibana/pull/242275).

**Dashboards and Visualizations**:
- Uses `max_value` instead of `infinity` for the default maximum height of a panel [#243572](https://github.com/elastic/kibana/pull/243572).
- Fixes issue with saving dashboards after changing the dashboard link to an external link [#243134](https://github.com/elastic/kibana/pull/243134).
- Fixes error that occurs when you deselect the **(blank)** option from the filter controls menu [#242036](https://github.com/elastic/kibana/pull/242036).

**Data ingestion and Fleet**:
- Uses long expiration for upgrading agents [#243443](https://github.com/elastic/kibana/pull/243443).
- Fixes retrying agents stuck in auto-upgrade logic [#243326](https://github.com/elastic/kibana/pull/243326).
- Adds retry behavior for `/api/fleet/agents` when transient issues with Elasticsearch are encountered [#243105](https://github.com/elastic/kibana/pull/243105).
- Fixes Docker image in the **Add agent** Kubernetes manifest [#242691](https://github.com/elastic/kibana/pull/242691).

**Discover**:
- Fixes truncation for longer text in the Discover table [#241440](https://github.com/elastic/kibana/pull/241440).

**Elastic Observability solution**:
For the Elastic Observability 9.2.2 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.2 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes the production build favicon's CSS specificity [#243351](https://github.com/elastic/kibana/pull/243351).
- Fixes an issue on the **Index management** page where screen reader text was different from visible text [#243802](https://github.com/elastic/kibana/pull/243802).
- Fixes an issue with keyboard focus getting trapped on pages using document preview [#243791](https://github.com/elastic/kibana/pull/243791).

**Machine Learning**:
- Ensures deleted text in AI connector or Inference endpoint forms is not sent as empty strings [#244059](https://github.com/elastic/kibana/pull/244059).
- Fixes data views showing runtime fields twice [#242557](https://github.com/elastic/kibana/pull/242557).
- Fixes import and improves validation for Anomaly Detection and Data Frame Analytics jobs [#242263](https://github.com/elastic/kibana/pull/242263).

**Search**:
- Turns off custom suggestions on embedded console [#241516](https://github.com/elastic/kibana/pull/241516).


## 9.2.1


### Features and enhancements

**Kibana platform**:
- The `defaultRoute` advanced setting now controls the target of the Elastic logo link for spaces using a solution view [#241571](https://github.com/elastic/kibana/pull/241571).
- Enforces the `object_src 'none'` directive in Kibana's Content Security Policy and introduces a new `csp.object_src` configuration option to control its behavior [#241029](https://github.com/elastic/kibana/pull/241029).

**Machine Learning**:
- Improves layout wrapping in the **Overview** and **Notifications** tabs on the Machine Learning Overview page [#239113](https://github.com/elastic/kibana/pull/239113).


### Fixes

**Alerting**:
- Fixes missing accessibility announcements in Cases [#240132](https://github.com/elastic/kibana/pull/240132).

**Dashboards and visualizations**:
- Fixes an issue where references were being lost in Links, Maps, and legacy Visualize panels when updating a dashboard [#241893](https://github.com/elastic/kibana/pull/241893).
- Fixes layout issues for markdown content in small panels [#240806](https://github.com/elastic/kibana/pull/240806).

**Data ingestion and Fleet**:
- Shows warnings in the integrations synchronization UI when referencing other entities [#241623](https://github.com/elastic/kibana/pull/241623).
- Adds proxy SSL options to download sources [#241115](https://github.com/elastic/kibana/pull/241115).
- Omits system properties when syncing ingest pipelines [#241096](https://github.com/elastic/kibana/pull/241096).
- Fixes Fleet policy name uniqueness not being consistently enforced across spaces when name or space changes occur [#239631](https://github.com/elastic/kibana/pull/239631).

**ES|QL editor**:
- Fixes the autocomplete suggestion of time series sources in `TS` commands after a comma [#241402](https://github.com/elastic/kibana/pull/241402).

**Elastic Observability solution**:
For the Elastic Observability 9.2.1 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.1 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Ensures all authentication fields show up correctly when setting up an AI connector [#240913](https://github.com/elastic/kibana/pull/240913).

**Search**:
- Fixes an issue with Agents and Playground icons not rendering correctly in the Elasticsearch solution side navigation when using dark mode [#240475](https://github.com/elastic/kibana/pull/240475).


## 9.2.0


### Features and enhancements

**Navigation and general interface**:
- Enhanced navigation menu for spaces that use a solution view. The new navigation experience provides more workspace for your data with an improved collapsed mode, hover menus, and responsiveness.
- New Data Management menu. For easier access to data-related management tasks, you can now find Fleet, Index Management, Integrations, and Ingest Pipelines in a dedicated menu next to the Stack Management menu that previously hosted these pages.
- Kibana is now available in German in Beta. To get started, set the locale in your Kibana settings as follows: `i18n.locale: de-DE`. If you find any issues, please raise them on [Github](https://github.com/elastic/kibana/issues) [#236903](https://github.com/elastic/kibana/pull/236903).
- Adds a table list view mode to the space selection screen for a more scalable design when a user has access to many spaces [#229046](https://github.com/elastic/kibana/pull/229046).

**Alerting**:
- Enables incremental human-readable case IDs [#238555](https://github.com/elastic/kibana/pull/238555).
- Create case analytics indexes per solution per space [#234125](https://github.com/elastic/kibana/pull/234125).
- Shows thumbnail image of attached case file [#226004](https://github.com/elastic/kibana/pull/226004).
- Adds a new Jira Service Management connector [#235408](https://github.com/elastic/kibana/pull/235408).
- Adds `xpack.actions.email.recipient_allowlist` alert action setting, which lets you specify a list of allowed email recipient patterns (`to`, `cc`, or `bcc`) that can be used with email connectors [#220058](https://github.com/elastic/kibana/pull/220058).
- Adds support for OAuth 2.0 authentication to the Webhook connector [#218442](https://github.com/elastic/kibana/pull/218442).
- Allows you to specify additional fields for the IBM Resilient connector [#236144](https://github.com/elastic/kibana/pull/236144).
- Maintenance windows are now generally available [#233870](https://github.com/elastic/kibana/pull/233870).
- Adds support for encrypted headers in the Webhook connector [#233695](https://github.com/elastic/kibana/pull/233695).
- Automatically copies source data into the alerts-as-data documents for other Elasticsearch query rule types [#230010](https://github.com/elastic/kibana/pull/230010).
- You can now add filters to maintenance windows based on alert fields from all solutions, without needing to select a category first [#227888](https://github.com/elastic/kibana/pull/227888).

**Dashboards and Visualizations**:
- Adds the ability to configure index settings when importing geospatial files in Maps [#232308](https://github.com/elastic/kibana/pull/232308).
- Adds a new inline Markdown editor to edit your text without leaving the dashboard. [#229191](https://github.com/elastic/kibana/pull/229191).
- Updates the toolbar popover for Metric charts, which is now called **Appearance**, with reorganized settings into clearer sections and new Primary position, Primary alignment, Secondary alignment, and Font weight settings [#233992](https://github.com/elastic/kibana/pull/233992).
- Improves ESQL suggestions logic when an ES|QL visualization query changes [#231767](https://github.com/elastic/kibana/pull/231767).
- Adds a new **Add** menu to the toolbar that lets you populate your dashboard with visualizations, panels, sections, and controls. This menu replaces and combines the various buttons that previously allowed you to perform these actions [#230324](https://github.com/elastic/kibana/pull/230324).
- Improves perceived performance of dashboard flyouts [#226052](https://github.com/elastic/kibana/pull/226052).
- Adds the ability to **Select all** to Options list controls [#221010](https://github.com/elastic/kibana/pull/221010).

**Data ingestion and Fleet**:
- Adds a toggle on the Elasticsearch output configuration page that grants agents permission to write to the `logs` and `logs.*` data streams [#233374](https://github.com/elastic/kibana/pull/233374).
- Completes OTel configuration pipelines with an exporter [#233090](https://github.com/elastic/kibana/pull/233090).
- Enables feature to auto-install content packages when data is ingested for datasets that match the datasets defined in the packages' `discovery` fields [#232668](https://github.com/elastic/kibana/pull/232668).
- Adds a new `MIGRATE` action type for migrating agents to a different cluster [#239556](https://github.com/elastic/kibana/pull/239556).
- Adds the `MIGRATE` action to the `SIGNED_ACTIONS` set [#228566](https://github.com/elastic/kibana/pull/228566).
- Adds a **Show agentless resources** toggle on the Fleet > Settings page to allow for troubleshooting and diagnostics [#237528](https://github.com/elastic/kibana/pull/237528).
- Updates the maximum supported version of package spec to 3.5 [#235942](https://github.com/elastic/kibana/pull/235942).
- Enables the installation of `alerting_rule_template` Kibana assets from packages; also enables a background task for reporting agent status changes in Fleet [#235842](https://github.com/elastic/kibana/pull/235842).
- Adds a filter on the Integrations page to show only agentless integrations [#235686](https://github.com/elastic/kibana/pull/235686).
- Adds support for a new `url` variable type in Fleet packages which provides better input validation of URLs in configurations [#231062](https://github.com/elastic/kibana/pull/231062).
- Adds support for a new `duration` variable type in Fleet packages which provides better input validation of duration strings in configurations [#231027](https://github.com/elastic/kibana/pull/231027).
- Renders the accordion for sample events on the integration overview page as collapsed by default [#228799](https://github.com/elastic/kibana/pull/228799).
- Hides metrics data streams and packages on Logs Essentials projects [#227842](https://github.com/elastic/kibana/pull/227842).
- Adds a package rollback API [#226754](https://github.com/elastic/kibana/pull/226754).
- Adds support for the `keep` option in the Remove processor in ingest pipelines [#225638](https://github.com/elastic/kibana/pull/225638).
- Adds the **Add / remove tags** action on the agent details page [#225433](https://github.com/elastic/kibana/pull/225433).

**Discover**:
- You can now manage multiple data explorations simultaneously in Discover using tabs. Navigate between them seamlessly, duplicate them to build on previous queries, and save them into a single Discover session to retrieve your queries, filters, and configurations untouched at a later time [#235150](https://github.com/elastic/kibana/pull/235150).
- You can now send long-running queries to the background. When a query runs in the background, you can perform other queries and tasks, then open it later from a new Background searches flyout to view cached results. This feature is in technical preview and disabled by default in this release. Check [this page](https://www.elastic.co/docs/explore-analyze/discover/background-search) for instructions [#236818](https://github.com/elastic/kibana/pull/236818).
- Improves Discover’s ES|QL LOOKUP JOIN experience with an index editor flyout supporting inline editing, and CSV import [#232686](https://github.com/elastic/kibana/pull/232686).
- You can now add variable controls to your ES|QL queries in Discover just like for your ES|QL visualizations in Dashboards [#229598](https://github.com/elastic/kibana/pull/229598).
- Adds related errors count and failure badge when exploring traces in Discover [#227413](https://github.com/elastic/kibana/pull/227413).
- Shows logs related to the current document when exploring traces in Discover [#232784](https://github.com/elastic/kibana/pull/232784).
- Adds a warning when navigating away from Discover with unsaved changes [#225252](https://github.com/elastic/kibana/pull/225252).
- Adds the ability to view the currently active profiles, such as the detected solution and data source contexts, which determine Discover's context-aware experiences [#222999](https://github.com/elastic/kibana/pull/222999).
- Appends the casting only when necessary in Discover's ES|QL mode filtering [#234748](https://github.com/elastic/kibana/pull/234748).
- Removes the default limit of `10` added to the query base query when switching to ES|QL mode in Discover [#234349](https://github.com/elastic/kibana/pull/234349).

**ES|QL editor**:
- Extends the ES|QL query history size to 50 KB, which represents between 200 to 300 queries instead of 20 [#232955](https://github.com/elastic/kibana/pull/232955).
- Adds support for lookup indices from remote clusters [#232907](https://github.com/elastic/kibana/pull/232907).
- The ES|QL autocomplete feature has been extended so that fields from the selected lookup index are suggested when using the `LOOKUP JOIN` command. The same enhancement was applied to column suggestions when using the `ENRICH` command [#233221](https://github.com/elastic/kibana/pull/233221).
- Improves function validation [#230139](https://github.com/elastic/kibana/pull/230139).
- Adds support for expressions in the STATS command [#229513](https://github.com/elastic/kibana/pull/229513).
- Enhances GROK semantics extraction with Onigurama regex patterns [#229409](https://github.com/elastic/kibana/pull/229409).
- Adds a **Prettify** button that formats queries to make them more readable [#228159](https://github.com/elastic/kibana/pull/228159).
- Displays function license requirements in the in-product ES|QL help reference [#229961](https://github.com/elastic/kibana/pull/229961).

**Elastic Observability solution**:
For the Elastic Observability 9.2.0 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Machine Learning**:
- Sets the default retention period for results from the logs anomaly detection configurations to 120 days [#231080](https://github.com/elastic/kibana/pull/231080).
- Redesigns the file upload UX and adds the ability to upload multiple files and existing indices [#232923](https://github.com/elastic/kibana/pull/232923).
- Adds a **GenAI Settings** page to **Stack Management** that lets you manage AI feature access for your deployment [#227289](https://github.com/elastic/kibana/pull/227289), [#233727](https://github.com/elastic/kibana/pull/233727).
- Introduces a new connector in technical preview, the AI Connector, which provides a single interface for connecting to a range of large language model providers [#235166](https://github.com/elastic/kibana/pull/235166), [#236951](https://github.com/elastic/kibana/pull/236951), [#228116](https://github.com/elastic/kibana/pull/228116).
- Inference endpoints UI: Adds tech preview for e5 preconfig endpoint [#234811](https://github.com/elastic/kibana/pull/234811).
- Inference endpoints UI: Adds tech preview for rerank preconfig endpoint [#235222](https://github.com/elastic/kibana/pull/235222).
- Improves the layout for custom URLs list in the data frame analytics form [#232575](https://github.com/elastic/kibana/pull/232575).
- AI Connector/Inference endpoints creation UI: Adds icon for AI21 labs and Llama Stack [#232098](https://github.com/elastic/kibana/pull/232098).
- Ensures ELSER and E5 product docs are appropriately updated when Kibana is upgraded [#231884](https://github.com/elastic/kibana/pull/231884).
- Improves layout for custom URLs when creating a machine learning job [#231751](https://github.com/elastic/kibana/pull/231751).
- Adds a check to validate whether your newly uploaded index is searchable [#231614](https://github.com/elastic/kibana/pull/231614).
- Displays document count chart for ESQL categorize queries [#231459](https://github.com/elastic/kibana/pull/231459).
- UX enhancements for editing fields in the AI Connector flyout [#231037](https://github.com/elastic/kibana/pull/231037).

**Kibana platform and management**:
- Data views managed by Elastic are now clearly identified in the UI. You can no longer edit them and instead have to duplicate them to apply any changes while preserving the original data view [#223451](https://github.com/elastic/kibana/pull/223451).
- Adds an option to convert an index to a lookup index [#233998](https://github.com/elastic/kibana/pull/233998).
- The Console introduction tour is now disabled by default. You can manually start the tour at any time from the Help popover [#227978](https://github.com/elastic/kibana/pull/227978).
- Improves the rate-limiter UX [#227678](https://github.com/elastic/kibana/pull/227678).

**Elasticsearch solution**:
- [Agent Builder](https://www.elastic.co/docs/solutions/explore-analyze/ai-features/elastic-agent-builder) is now available in technical preview. Build custom agents and tools to explore your Elastic data using natural language, in real time or programmatically using MCP, A2A, or REST APIs. You must [enable the feature](https://www.elastic.co/docs/solutions/explore-analyze/ai-features/agent-builder/get-started#enable-agent-builder) to get started.
- Adds the ability to save Playgrounds within a space [#229511](https://github.com/elastic/kibana/pull/229511).
- Improves code examples in the Synonyms interface [#235944](https://github.com/elastic/kibana/pull/235944).


### Fixes

**Alerting**:
- Fetches the tracked alerts without depending on the task state [#235253](https://github.com/elastic/kibana/pull/235253).
- Fixes an issue that prevented the query field from properly loading in the rule request if you used a saved query [#229964](https://github.com/elastic/kibana/pull/229964).

**Dashboards and Visualizations**:
- Null buckets and empty string values are now rendered in the UI as `(missing value)` and `(empty)` respectively. This is now aligned across charts and tables, including Discover and Lens charts [#233369](https://github.com/elastic/kibana/pull/233369).
- Skips automatic scroll when interacting with a panel that is already visible [#233226](https://github.com/elastic/kibana/pull/233226).
- Shows solid panel borders when a dashboard is in **View** mode [#232676](https://github.com/elastic/kibana/pull/232676).
- Fixes error handling when saving a Links panel to the library from a dashboard [#231168](https://github.com/elastic/kibana/pull/231168).
- Logs a warning instead of throwing an error if a filter and query state can not be read or written due to missing or malformed references [#230088](https://github.com/elastic/kibana/pull/230088).

**Data ingestion and Fleet**:
- Fixes "package not found" error when skipping cloud onboarding for a prerelease package [#238629](https://github.com/elastic/kibana/pull/238629).

**Discover**:
- Fixes an issue with the data view creation flyout that could glitch when accessed from a separate page [#228749](https://github.com/elastic/kibana/pull/228749).

**ES|QL editor**:
- Fixes controls' trigger across various commands [#236121](https://github.com/elastic/kibana/pull/236121).
- Fixes lookup index route failures on read permissions [#233282](https://github.com/elastic/kibana/pull/233282).
- Fixes an issue on Firefox where the ES|QL inline editor could prevent scrolling [#228849](https://github.com/elastic/kibana/pull/228849).

**Elastic Observability solution**:
For the Elastic Observability 9.2.0 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.2.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Machine Learning**:
- Adds unique accessible labels for the **Show top field values** buttons on the **Log Rate Analysis** page [#237972](https://github.com/elastic/kibana/pull/237972).
- Single Metric Viewer: fixes partition field settings errors in the dashboard panel [#237046](https://github.com/elastic/kibana/pull/237046).
- Escapes URL-like string from being displayed as links in email clients [#226849](https://github.com/elastic/kibana/pull/226849).

**Search**:
- Fixes an accessibility issue where resetting changes or removing all terms in the Synonyms panel was not announced by screen readers. VoiceOver users on Safari will now hear updates when terms are reset [#237877](https://github.com/elastic/kibana/pull/237877).
- Fixes an issue with a null property being read in Playground [#230729](https://github.com/elastic/kibana/pull/230729).


## 9.1.10


### Features and enhancements

**Elastic Observability solution**:
For the Elastic Observability 9.1.10 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.10 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

### Fixes

**Alerting and cases**:
- Adds maximum character validation to the email connector params and configuration [#246453](https://github.com/elastic/kibana/pull/246453).
- Adds encoding to search terms in the **Cases** page to prevent decoding errors [#247992](https://github.com/elastic/kibana/pull/247992).

**Dashboards and Visualizations**:
- Fixes compound filters showing unsaved changes on dashboard load [#247309](https://github.com/elastic/kibana/pull/247309).

**Elastic Observability solution**:
For the Elastic Observability 9.1.10 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.10 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes `createAuditEvents` always returning failure as the outcome [#247152](https://github.com/elastic/kibana/pull/247152).

**Kibana security**:
- Adds case sensitivity to the index privileges fields on the **Edit roles** page [#246069](https://github.com/elastic/kibana/pull/246069).

**Machine Learning**:
- Fixes the display of map view in Data Visualizer for small screen sizes [#247615](https://github.com/elastic/kibana/pull/247615).

**Platform**:
- Unifies the flow for clients partially and fully authorized to saved objects, and applies the intersection of allowed and authorized lists [#244967](https://github.com/elastic/kibana/pull/244967).

**Search**:
- Fixes an issue where users running Elasticsearch with basic licenses would encounter errors when updating index mappings. Now, the Machine Learning saved object check will only run if saving semantic text mapping [#248462](https://github.com/elastic/kibana/pull/248462).


## 9.1.9


### Features and enhancements

**Data ingestion and Fleet**:
- Adds the background task `FleetPolicyRevisionsCleanupTask` which removes excess policy revisions from the `.fleet-policies` index [#242612](https://github.com/elastic/kibana/pull/242612).

**Kibana platform**:
- The **API keys** management page now defaults to showing personal API keys only [#245261](https://github.com/elastic/kibana/pull/245261).
- Adds a warning when deleting API keys currently used by alerting rules [#243353](https://github.com/elastic/kibana/pull/243353).


### Fixes

**Alerting**:
- Fixes an issue that caused the Security alerts table not to update columns correctly when switching view modes [#245253](https://github.com/elastic/kibana/pull/245253).
- Adds `consecutiveMatches` to action context [#244997](https://github.com/elastic/kibana/pull/244997).

**Elastic Observability solution**:
For the Elastic Observability 9.1.9 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.9 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes "now" and mixed-format date handling in the **Share** menu [#245539](https://github.com/elastic/kibana/pull/245539).
- Fixes an issue with authentication when multiple OIDC providers are configured [#243869](https://github.com/elastic/kibana/pull/243869).
- Fixes an ECS incompatibility with the `kibana_started.elasticsearch.waitTime` value in logs [#245706](https://github.com/elastic/kibana/pull/245706).
- Fixes the serialization of `meta.error` in JSON layouts: if the error is an `Error` instance, only `message`, `name`, and `stack` are included. Other fields are no longer returned in the logs [#244364](https://github.com/elastic/kibana/pull/244364).

**Machine Learning**:
- Hiding the alerts table popover no longer clears the cell selection in Anomaly Explorer [#244183](https://github.com/elastic/kibana/pull/244183).


## 9.1.8


### Features and enhancements

**Elastic Observability solution**:
For the Elastic Observability 9.1.8 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.8 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

### Fixes

**Alerting and cases**:
- Captures connector errors without interrupting the case creation flow. Issues with connectors can be resolved on the case details page  [#244188](https://github.com/elastic/kibana/pull/244188).
- Fixes pagination for the **Alerts** table, which was getting stuck on rule details pages [#242275](https://github.com/elastic/kibana/pull/242275).
- Fetches tracked alerts without depending on the task state [#235253](https://github.com/elastic/kibana/pull/235253).

**Dashboards and Visualizations**:
- Fixes error that occurs when you deselect the **(blank)** option from the filter controls menu [#242036](https://github.com/elastic/kibana/pull/242036).

**Data ingestion and Fleet**:
- Uses long expiration for upgrading agents [#243443](https://github.com/elastic/kibana/pull/243443).
- Fixes retrying agents stuck in auto-upgrade logic [#243326](https://github.com/elastic/kibana/pull/243326).
- Adds retry behavior for `/api/fleet/agents` when transient issues with Elasticsearch are encountered [#243105](https://github.com/elastic/kibana/pull/243105).
- Fixes Docker image in the **Add agent** Kubernetes manifest [#242691](https://github.com/elastic/kibana/pull/242691).
- Fixes Fleet policy name uniqueness not being consistently enforced across spaces when name or space changes occur [#239631](https://github.com/elastic/kibana/pull/239631).
- Fixes `ignore_above` mapping for `flattened` fields [#238890](https://github.com/elastic/kibana/pull/238890).

**Elastic Observability solution**:
For the Elastic Observability 9.1.8 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.8 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes the production build favicon's CSS specificity [#243351](https://github.com/elastic/kibana/pull/243351).
- Fixes an issue on the **Index management** page where screen reader text was different from visible text [#243802](https://github.com/elastic/kibana/pull/243802).
- Fixes an issue with keyboard focus getting trapped on pages using document preview [#243791](https://github.com/elastic/kibana/pull/243791).

**Machine Learning**:
- Ensures deleted text in AI connector or Inference endpoint forms is not sent as empty strings [#244059](https://github.com/elastic/kibana/pull/244059).
- Fixes import and improves validation for Anomaly Detection and Data Frame Analytics jobs [#242263](https://github.com/elastic/kibana/pull/242263).


## 9.1.7


### Features and enhancements

**Machine Learning**:
- Adds a feedback button to Anomaly Explorer and Single Metric Viewer [#239883](https://github.com/elastic/kibana/pull/239883).


### Fixes

**Alerting**:
- In Cases, tables no longer flash when the page is loading [#240155](https://github.com/elastic/kibana/pull/240155).
- Fixes an infinite loop issue occurring when the Investigation guide of a rule's details is too long [#240472](https://github.com/elastic/kibana/pull/240472).

**Dashboards and visualizations**:
- Labels in Maps' **Create index** flow now render with the default **Use vector tiles** scaling as soon as label styling is applied (or after saving), without requiring a scaling toggle [#240728](https://github.com/elastic/kibana/pull/240728).
- Fixes an issue occurring when resetting a dashboard with unsaved changes after enabling `timeRestore` and setting a time range [#239992](https://github.com/elastic/kibana/pull/239992).

**Data ingestion and Fleet**:
- Shows warnings in the integrations synchronization UI when referencing other entities [#241623](https://github.com/elastic/kibana/pull/241623).
- Adds proxy SSL options to download sources [#241115](https://github.com/elastic/kibana/pull/241115).
- Fixes Fleet policy name uniqueness not being consistently enforced across spaces when name or space changes occur [#239631](https://github.com/elastic/kibana/pull/239631).

**Kibana platform**:
- Ensures that the `max_tokens` parameter is correctly passed as expected when connecting to Anthropic [#241212](https://github.com/elastic/kibana/pull/241212) & [#241188](https://github.com/elastic/kibana/pull/241188).
- Removes the default fallback region for the Amazon Bedrock connector [#241157](https://github.com/elastic/kibana/pull/241157).

**Elastic Observability solution**:
For the Elastic Observability 9.1.7 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.7 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Machine Learning**:
- Ensures that the inference endpoints list loads properly even when using a custom inference provider [#240189](https://github.com/elastic/kibana/pull/240189).


## 9.1.6


### Features and enhancements

**Data ingestion and Fleet**:
- Replaces the `?showAgentless` query param with a local storage setting called `fleet:showAgentlessResources`, which can be toggled from the Fleet settings page. When enabled, agentless agents and policies are visible in the Fleet UI [#237528](https://github.com/elastic/kibana/pull/237528).

**Elastic Security solution**:
For the Elastic Security 9.1.6 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana security**:
- Enhances error message by explaining why the role is considered malformed [#239098](https://github.com/elastic/kibana/pull/239098).


### Fixes

**Dashboards and Visualizations**:
- Fixes an issue that prevented you from deleting unsaved dashboard changes after you had enabled the `timeRestore` setting and selected a time and date using the date picker [#239992](https://github.com/elastic/kibana/pull/239992).
- Fixes error that occured when you selected a blank value in the options list [#239791](https://github.com/elastic/kibana/pull/239791).
- Fixes an issue in Lens that incorrectly assigned unsaved, ad-hoc dataview references [#239431](https://github.com/elastic/kibana/pull/239431).
- Fixes metric color assignment when breakdown and a max dimension are defined in Lens [#238901](https://github.com/elastic/kibana/pull/238901).
- Ensures adhoc dataviews from ES|QL charts aren't being filtered out in the KQL search bar [#238731](https://github.com/elastic/kibana/pull/238731).

**Data ingestion and Fleet**:
- Fixes an issue that occured during an integration policy upgrade that prevented the new package global variables from being included and stale variable references from being removed [#238542](https://github.com/elastic/kibana/pull/238542).

**Discover**:
- Ensures that the combined filters are considered when selecting the correct fields for the query while the `courier:ignoreFilterIfFieldNotInIndex` advanced setting is enabled [#238945](https://github.com/elastic/kibana/pull/238945).

**Elastic Observability solution**:
For the Elastic Observability 9.1.6 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.6 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Search**:
- Fixes visual issues with the document metadata popup that happened when the document ID was too long. Also adds a tooltip and copy button to improve the user experience [#239768](https://github.com/elastic/kibana/pull/239768).


## 9.1.5

<important>
  The 9.1.5 release contains fixes for potential security vulnerabilities. Check our [security advisory](https://discuss.elastic.co/c/announcements/security-announcements/31) for more details.
</important>


### Features and enhancements

**Data ingestion and Fleet**:
- Renames Fleet Server SSL options for clarity in the **Add a Fleet Server** flyout [#236887](https://github.com/elastic/kibana/pull/236887).

**Elastic Security solution**:
For the Elastic Security 9.1.5 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

### Fixes

**Alerting**:
- Rolls over the reporting data stream if its template version is newer than the version in the data stream's mappings [#234119](https://github.com/elastic/kibana/pull/234119).

**Dashboards and Visualizations**:
- Fixes an issue where the dashboard title would not get updated in the breadcrumb when edited from the list of dashboards [#236561](https://github.com/elastic/kibana/pull/236561).
- Updates dashboards to wait until controls are ready before rendering panels to prevent a double fetch of data [#237169](https://github.com/elastic/kibana/pull/237169).
- Fixes an issue with the Lens table's column sort order being different in the dashboard and the exported CSV [#236673](https://github.com/elastic/kibana/pull/236673).

**Data ingestion and Fleet**:
- Fixes text kerning issues in PDF/PNG exports of dashboards and visualizations [#235516](https://github.com/elastic/kibana/pull/235516).
- Fixes incorrect copying of SSL settings to the Fleet Hosts section of generated Agent policies [#236788](https://github.com/elastic/kibana/pull/236788).
- Validates the Logstash pipeline ID at the Kibana API level [#236347](https://github.com/elastic/kibana/pull/236347).
- Adds a unique count to improve accuracy of the number of transforms on the integrations overview page [#236177](https://github.com/elastic/kibana/pull/236177).
- Fixes malformed synthetics package policies [#236176](https://github.com/elastic/kibana/pull/236176).

**Discover**:
- Clears sort by `timestamp` when navigating from classic to ESQL mode [#235338](https://github.com/elastic/kibana/pull/235338).
- Fixes sizing issues with the **Actions** column header [#235227](https://github.com/elastic/kibana/pull/235227).

**Kibana security**:
- Allows `xpack.spaces.defaultSolution` to be configured through environment variables for Docker deployments [#236570](https://github.com/elastic/kibana/pull/236570).

**Machine Learning**:
- Omits fields that should not be included in datafeed preview requests when testing custom URLs in anomaly detection jobs [#234709](https://github.com/elastic/kibana/pull/234709).
- Improves trained model performance by adding filters to the request to fetch all index settings [#237072](https://github.com/elastic/kibana/pull/237072).
- Hides the show forecast checkbox when selecting a new job in the Single Metric Viewer [#236724](https://github.com/elastic/kibana/pull/236724).
- Makes alerts visible in Anomaly Explorer to all Machine Learning-only users regardless of where they create rules [#236289](https://github.com/elastic/kibana/pull/236289).
- Fixes the **Job details** flyout on the **Analytics Map** page [#236131](https://github.com/elastic/kibana/pull/236131).
- Fixes rendering of the dashboard panel in PDF reporting for the Anomaly Swim Lane [#235475](https://github.com/elastic/kibana/pull/235475).
- Limits log rate analysis category requests to reduce `msearch` usage [#235611](https://github.com/elastic/kibana/pull/235611).

**Management**:
- Adds the `managed` field to the data views response schema to prevent the public API call from failing [#236237](https://github.com/elastic/kibana/pull/236237).
- Adds the `timeFieldName` field to the data views response schema to prevent the public API call from failing [#235975](https://github.com/elastic/kibana/pull/235975).
- Fixes privilege requirements when reindexing indices through Upgrade Assistant. Previously, the `superuser` role was required, but now the `cluster: manage` and `all` privileges are sufficient [#237055](https://github.com/elastic/kibana/pull/237055).

**Stack Management**:
- Adds the ability to do partial matches and searches in the **API keys** section [#221959](https://github.com/elastic/kibana/pull/221959).

**Search solution**:
- Adds search functionality to the **Query rules** details page [#232579](https://github.com/elastic/kibana/pull/232579).


## 9.1.4


### Features and enhancements

**Elastic Observability solution**:
For the Elastic Observability 9.1.4 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Stack management**
- Adds IPv6 support to remote clusters address fields [#233415](https://github.com/elastic/kibana/pull/233415).


### Fixes

**Dashboards and Visualizations**:
- Fixes an issue with the Save modal that allowed duplicate saves of dashboards, visualizations, and other objects when clicking the **Save** button multiple times [#233933](https://github.com/elastic/kibana/pull/233933).

**Elastic Security solution**:
For the Elastic Security 9.1.4 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Machine Learning**:
- The **Run** button is now properly disabled in Elastic Managed LLM tests when the action's JSON body isn't valid [#231873](https://github.com/elastic/kibana/pull/231873).


## 9.1.3

<important>
  The 9.1.3 release contains fixes for potential security vulnerabilities. Check our [security advisory](https://discuss.elastic.co/c/announcements/security-announcements/31) for more details.
</important>


### Fixes

**Alerting**:
- Fixes an issue that prevents reports from showing in the Reporting UI when they're created in a non-default Kibana space with a dash in its name [#230876](https://github.com/elastic/kibana/pull/230876).

**Dashboards and Visualizations**:
- Fixes an issue in Lens that caused color mapping changes to render as gray [#231563](https://github.com/elastic/kibana/pull/231563).
- Fixes broken references that occured when you returned to an unsaved dashboard with reference panels [#231517](https://github.com/elastic/kibana/pull/231517).

**Data ingestion and Fleet**:
- Fixes the `deployment_modes` evaluation for policy templates when creating a package policy. When deploying in agentless mode, this prevents the acceptance of inputs from policy templates that are not opted into the agentless mode at the template level [#231679](https://github.com/elastic/kibana/pull/231679).

**Discover**:
- Disables sorting for JSON-like fields in ESQL mode [#231289](https://github.com/elastic/kibana/pull/231289).

**Elastic Observability solution**:
For the Elastic Observability 9.1.3 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.3 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes an issue where the schedule interval of the cleanup task for unused URLs wouldn't update if the `share.url_expiration.duration` changed [#231883](https://github.com/elastic/kibana/pull/231883).
- Updates the built-in `reporting_user` role to leverage a new  `reporting_user` reserved privilege [#231533](https://github.com/elastic/kibana/pull/231533).


## 9.1.2


### Fixes

**Alerting**:
- Fixes an issue that prevents reports from showing in the Reporting UI when they're created in a non-default Kibana space with a dash in its name [#230876](https://github.com/elastic/kibana/pull/230876).

**Data ingestion and Fleet**:
- Fixes validation for `text` and `password` inputs in the package policy editor [#229932](https://github.com/elastic/kibana/pull/229932).

**Elastic Observability solution**:
For the Elastic Observability 9.1.2 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.2 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes the breadcrumb to include a link to the home page when browsing pages from the **Elasticsearch** section of the navigation [#230270](https://github.com/elastic/kibana/pull/230270).


## 9.1.1


### Features and enhancements

**Dashboards and Visualizations**:
- Improves usability of dashboards when zooming up to 400% [#228978](https://github.com/elastic/kibana/pull/228978).
- Adds list options to ESQL controls in dashboards [#227334](https://github.com/elastic/kibana/pull/227334).

**Management**:
- Console now uses explicit host selection instead of retrying failed hosts, ensuring predictable behavior and preventing silent request failures. This change fixes an issue in Console where request bodies were lost during automatic host retries. [#229574](https://github.com/elastic/kibana/pull/229574).


### Fixes

**Dashboards and Visualizations**:
- Fixes incorrect panel rendering when the **Defer loading panels below "the fold"** advanced setting is on [#229662](https://github.com/elastic/kibana/pull/229662).
- Fixes an issue in reports where a PNG or PDF export would offset and clip part of the visualization in *Lens* [#228603](https://github.com/elastic/kibana/pull/228603).
- Fixes ES|QL loading button state for long running queries in *Lens* [#226565](https://github.com/elastic/kibana/pull/226565).
- Improves the layout and accessibility of the ES|QL control editor [#228103](https://github.com/elastic/kibana/pull/228103).

**Data ingestion and Fleet**:
- Fixes an issue where the SSL configuration isn't properly added to agent policies with pre-configured output types [#230211](https://github.com/elastic/kibana/pull/230211).

**Discover**:
- Fixes an issue where HTML search highlighting markup is incorrectly carried over into filter values when using the **Filter for value** field action in the **Log overview** tab [#227652](https://github.com/elastic/kibana/pull/227652).

**Elastic Observability solution**:
For the Elastic Observability 9.1.1 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.1 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Machine Learning**:
- Fixes patterns field selector menu width [#228791](https://github.com/elastic/kibana/pull/228791).

**Kibana platform**:
- Fixes the breadcrumb to include a link to the home page when browsing pages from the **Elasticsearch** section of the navigation [#230270](https://github.com/elastic/kibana/pull/230270).


## 9.1.0

If you're upgrading to version 9.1.0, you first need to upgrade to version [8.19](https://www.elastic.co/guide/en/kibana/8.19/release-notes-8.19.0.html) or [9.0](#kibana-900-release-notes).

### Features and enhancements

**Alerting**:
- Adds the ability to schedule reports on a recurring basis and view previously scheduled reports [#224849](https://github.com/elastic/kibana/pull/224849), [#221028](https://github.com/elastic/kibana/pull/221028).
- Adds the `xpack.actions.email.services.enabled` Kibana setting, which allows you to enable or disable email services for email connectors [#223363](https://github.com/elastic/kibana/pull/223363).
- Adds the `xpack.actions.webhook.ssl.pfx.enabled` Kibana setting, which allows you to disable Webhook connector PFX file support for SSL client authentication [#222507](https://github.com/elastic/kibana/pull/222507).
- Adds the `xpack.actions.email.services.ses.host` Kibana setting, which lets you specify the SMTP endpoint for an Amazon Simple Email Service (SES) service provider that can be used by email connectors. Also adds the `xpack.actions.email.services.ses.hostport` Kibana setting, which allows you to specify the port number for an Amazon SES service provider that can be used by email connectors [#221389](https://github.com/elastic/kibana/pull/221389).
- Adds `rrule` notation support for task scheduling [#217728](https://github.com/elastic/kibana/pull/217728).
- Publishes new public APIs for the Maintenance Window [#216756](https://github.com/elastic/kibana/pull/216756).
- Allows you to delete Maintenance Windows [#211399](https://github.com/elastic/kibana/pull/211399).
- Adds an alert cleanup functionality that allows you to delete active or inactive (acknowledged, recovered, closed, or untracked) alerts with no status update for a period of time [#216613](https://github.com/elastic/kibana/pull/216613).
- Adds an embeddable panel for dashboards that allows you to show a simplified version of the Alerts table from Observability or Elastic Security [#216076](https://github.com/elastic/kibana/pull/216076).
- Ensures the **Reporting** page only shows reports generated in the current space [#221375](https://github.com/elastic/kibana/pull/221375).
- Moves the rule settings to a flyout [#216162](https://github.com/elastic/kibana/pull/216162).
- Allows users to delete a snooze schedule from a rule using schedule ID [#213247](https://github.com/elastic/kibana/pull/213247).
- Allows users to create a snooze schedule for rules using the schedule API [#210584](https://github.com/elastic/kibana/pull/210584).
- Implements functionality to add observables, procedures, and custom fields to alerts for TheHive [#207255](https://github.com/elastic/kibana/pull/207255).

**Dashboards and Visualizations**:
- Adds the **Create alert rule** action to ESQL dashboard panels, usable from the panel context menu or by right-clicking a data point on the visualization. This rule allows you to generate an alert when the data on the chart crosses a certain threshold [#217719](https://github.com/elastic/kibana/pull/217719).
- Adds collapsible sections to dashboards that allow you to group panels into logical groups. Collapsible sections also help dashboards load faster by only loading their content when expanded [#220877](https://github.com/elastic/kibana/pull/220877).
- Adds the ability to mark a dashboard as favorite from within the dashboard in addition to the **Dashboards** page [#201596](https://github.com/elastic/kibana/pull/201596).
- Adds the ability to resize and move dashboard panels using a keyboard [#208286](https://github.com/elastic/kibana/pull/208286).
- Adds a highlight effect when adding a panel to a dashboard [#223614](https://github.com/elastic/kibana/pull/223614).
- Adds the ability to create ES|QL controls from the dashboard **Controls** menu [#219495](https://github.com/elastic/kibana/pull/219495).
- Adds the ability to create ES|QL controls by typing a question mark (`?`) when editing an ES|QL visualization's query [#216839](https://github.com/elastic/kibana/pull/216839).
- Allows the creation of dynamic aggregations controls for ES|QL visualizations [#210170](https://github.com/elastic/kibana/pull/210170).
- Improves handling of `?_tstart` and `?_tend` named parameters when the ES|QL visualization's query includes controls [#225054](https://github.com/elastic/kibana/pull/225054).
- Adds CRUD API routes for Lens [#223296](https://github.com/elastic/kibana/pull/223296).
- The **Color Mapping** feature is now GA. Previous Lens palette definitions are deprecated and will continue to function normally with no visual change to existing visualizations. Toggling off legacy mode will replace the palette with an equivalent color mapping configuration [#220296](https://github.com/elastic/kibana/pull/220296).
- Adds **Compare to** badge for Metric charts in Lens [#214811](https://github.com/elastic/kibana/pull/214811).
- Updates time-based charts to use the multi-layer time axis by default, providing a better time window context and improved label positioning [#210579](https://github.com/elastic/kibana/pull/210579).
- Enables read-only editor mode to inspect a panel's configuration in Lens [#208554](https://github.com/elastic/kibana/pull/208554).
- Adds a **Point visibility** option to Area and Line charts in Lens [#222187](https://github.com/elastic/kibana/pull/222187).
- Adds a setting to control the data table density in Lens [#220252](https://github.com/elastic/kibana/pull/220252).
- Opens Lens in the same tab when you select **Open in Lens** on a visualization [#217528](https://github.com/elastic/kibana/pull/217528).
- Adds the ability to open links from Vega visualizations in a new tab by specifying the `"target": "_blank"` option for the `usermeta.embedOptions.loader` property of the Vega chart configuration [#216200](https://github.com/elastic/kibana/pull/216200).
- Adds globe projection improvements to Maps [#212437](https://github.com/elastic/kibana/pull/212437).
- When possible, keeps the chart configuration after editing an ES|QL visualization's query [#210780](https://github.com/elastic/kibana/pull/210780).

**Data ingestion and Fleet**:
- Adds support for bulk agent migration using the **Bulk actions** menu in the agent list table [#224334](https://github.com/elastic/kibana/pull/224334).
- Enables the tabular integrations feature in Fleet [#222842](https://github.com/elastic/kibana/pull/222842).
- Adds support for single agent migration using the **Actions** menu in Fleet. Users can provide a remote cluster URL and enrollment token, as well as customize parameters for the migration [#222111](https://github.com/elastic/kibana/pull/222111).
- Adds an API endpoint to migrate a single agent to another cluster using a URL and enrollment token. Tamper-protected and Fleet-managed agents are not supported and return a `403` response if attempted [#220601](https://github.com/elastic/kibana/pull/220601).
- Adds a new integration flyout component [#220229](https://github.com/elastic/kibana/pull/220229).
- Enables the sync integrations on remote clusters feature in Fleet [#220215](https://github.com/elastic/kibana/pull/220215).
- Enables the automatic agent upgrades feature in Fleet [#219932](https://github.com/elastic/kibana/pull/219932).
- Adds edit functionality for custom integration READMEs. Editing a README automatically increments the integration version and updates all associated policies [#215259](https://github.com/elastic/kibana/pull/215259).
- Adds SSL fields to agent binary source settings [#213211](https://github.com/elastic/kibana/pull/213211).
- Adds support for Cloud Connectors in CSPM [#212200](https://github.com/elastic/kibana/pull/212200).
- Exposes SSL options for Elasticsearch and remote Elasticsearch outputs in the UI [#208745](https://github.com/elastic/kibana/pull/208745).
- Adds SSL options to Fleet Server host settings [#208091](https://github.com/elastic/kibana/pull/208091).
- Adds a new action to add tags from the **Agent details** page [#225433](https://github.com/elastic/kibana/pull/225433).
- Adds a tooltip to the **Last activity** column in the agent list UI [#224850](https://github.com/elastic/kibana/pull/224850).
- Adds support for agentless traffic filters [#222082](https://github.com/elastic/kibana/pull/222082).
- Makes the tag filter in Fleet agents searchable and sorted [#219639](https://github.com/elastic/kibana/pull/219639).
- Adds a callout to highlight breaking changes during integration upgrades [#217257](https://github.com/elastic/kibana/pull/217257).
- Adds MSI installer command support for Fleet Server and agents [#217217](https://github.com/elastic/kibana/pull/217217).
- Makes SSL optional for Fleet Logstash outputs [#216216](https://github.com/elastic/kibana/pull/216216).
- Formats the **Last activity** value in the Fleet agent details view as a datetime [#215531](https://github.com/elastic/kibana/pull/215531).
- Adds support for `searchAfter` and point-in-time (`pit`) parameters in the get agents list API [#213486](https://github.com/elastic/kibana/pull/213486).
- Registers a custom integrations search provider [#213013](https://github.com/elastic/kibana/pull/213013).
- Adds support for collapsible sections in integration overview pages [#223916](https://github.com/elastic/kibana/pull/223916).

**Discover**:
- Adds an **Attributes** tab to the document viewer when exploring OTel documents in the Observability solution view [#222391](https://github.com/elastic/kibana/pull/222391).
- Shows any available results when an ESQL query times out as a result of the `search:timeout` advanced setting [#219027](https://github.com/elastic/kibana/pull/219027).
- Adds click actions for Stacktrace and Degraded Fields when exploring logs in Discover [#214413](https://github.com/elastic/kibana/pull/214413).
- Shows a **Load more** option instead of pagination when exploring Logs in Discover [#211176](https://github.com/elastic/kibana/pull/211176).
- Expands the ES|QL editor to fit the query size automatically when loading Discover [#225509](https://github.com/elastic/kibana/pull/225509).
- Hides the **Selected only** toggle in pages that don't support filtering by value [#220624](https://github.com/elastic/kibana/pull/220624).
- Adds a **Copy value** button to field value cells in the Document viewer [#218817](https://github.com/elastic/kibana/pull/218817).
- Adds a warning and a tooltip for explaining the `_score` column in Discover [#211013](https://github.com/elastic/kibana/pull/211013).
- Adds support for `command`/`ctrl` + click to open new Discover sessions in a separate tab. This is useful, for example, when conducting multiple searches simultaneously [#210982](https://github.com/elastic/kibana/pull/210982).
- Improves the **Display options** menu layout [#210180](https://github.com/elastic/kibana/pull/210180).
- Updates styles for Color formatter to look like badges [#189391](https://github.com/elastic/kibana/pull/189391).

**ES|QL editor**:
- The ES|QL `LOOKUP_JOIN` command is now GA [#225117](https://github.com/elastic/kibana/pull/225117).
- The ES|QL `COMPLETION` command is now available in technical preview [#224811](https://github.com/elastic/kibana/pull/224811).
- The ES|QL `FORK` command is now available in technical preview [#224680](https://github.com/elastic/kibana/pull/224680).
- Adds suggestions for all operators when writing queries [#223503](https://github.com/elastic/kibana/pull/223503).
- Improves handling of long fields [#223222](https://github.com/elastic/kibana/pull/223222).
- Adds support for `date_nanos` fields in `BUCKET` functions [#213319](https://github.com/elastic/kibana/pull/213319).
- Shows list of keyboard shortcuts at the bottom of the editor [#221331](https://github.com/elastic/kibana/pull/221331).
- Adds suggestions for full text search when writing queries [#221239](https://github.com/elastic/kibana/pull/221239).
- Adds full text search suggestions to `STATS ... WHERE` queries [#220691](https://github.com/elastic/kibana/pull/220691).
- Adds autocomplete suggestions for `STATS...WHERE` [#216379](https://github.com/elastic/kibana/pull/216379).
- Enables suggestions for the `CHANGE_POINT` command [#218100](https://github.com/elastic/kibana/pull/218100).
- Adds validation and autocomplete support for the `CHANGE_POINT` command [#216043](https://github.com/elastic/kibana/pull/216043).
- Highlights code examples in the in-product documentation [#214915](https://github.com/elastic/kibana/pull/214915).
- Suggests triple quotes when using `KQL` and `QSTR` functions [#211457](https://github.com/elastic/kibana/pull/211457).

**Elastic Observability solution**:
For the Elastic Observability 9.1.0 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Adds an option to User Settings that allows displaying the Kibana interface in high contrast mode [#216242](https://github.com/elastic/kibana/pull/216242).
- Adds an unused URL saved objects cleanup task to reduce upgrade downtime [#220138](https://github.com/elastic/kibana/pull/220138).
- Adds a `defaultSolution` setting to spaces configuration so that you can start Kibana with its default space set to a specific solution view [#218360](https://github.com/elastic/kibana/pull/218360).
- Kibana logging's pattern layout, used by default for the console appender, will now use a new default pattern layout: `[%date][%level][%logger] %message %error`. This includes the error name and stack trace if these were included in the log entry. To opt out of this behavior, you can omit the `%error` placeholder from your log pattern configuration in `kibana.yml` [#219940](https://github.com/elastic/kibana/pull/219940). For example:

```yml
logging:
  appenders:
    console:
      type: console
      layout:
        type: pattern
        pattern: "[%date][%level][%logger] %message"
```

**Machine Learning**:
- Moves job and trained model management features into Stack Management [#204290](https://github.com/elastic/kibana/pull/204290).
- Updates NL-2-ESQL docs [#224868](https://github.com/elastic/kibana/pull/224868).
- Hides the **Adaptive Allocations** toggle in Serverless [#224097](https://github.com/elastic/kibana/pull/224097).
- Adds rare scripts job to preconfigured Security:Windows anomaly detection jobs [#223041](https://github.com/elastic/kibana/pull/223041).
- Adds new subAction for converse and converseStream for Bedrock [#223033](https://github.com/elastic/kibana/pull/223033).
- Adds a recommended query for the `CATEGORIZE` function in ES|QL [#222871](https://github.com/elastic/kibana/pull/222871).
- Adds the ability to disable the AIOps features in Kibana [#221286](https://github.com/elastic/kibana/pull/221286).
- Adds new severity colors and UX for filtering anomalies [#221081](https://github.com/elastic/kibana/pull/221081).
- Prevents the download of models already present in other spaces and shows a warning [#220238](https://github.com/elastic/kibana/pull/220238).
- Enhances `No Results` state for Change Point Detection [#219072](https://github.com/elastic/kibana/pull/219072).
- Fixes some OpenAI models not accepting temperature for Inference service [#218887](https://github.com/elastic/kibana/pull/218887).
- Adds Voyage AI and DeepSeek icons [#216651](https://github.com/elastic/kibana/pull/216651).
- Enhances the display for anomaly time function values in anomaly tables [#216142](https://github.com/elastic/kibana/pull/216142).
- Improves the UX for deploying trained models [#205699](https://github.com/elastic/kibana/pull/205699).

**Management**:
- Adds autocomplete suggestions for ES|QL queries in Console [#219980](https://github.com/elastic/kibana/pull/219980).
- Adds a loader indicator when datasources are being loaded [#225005](https://github.com/elastic/kibana/pull/225005).

**Search solution**:
- Adds a section that enables adding, updating, and deleting query rules written on top of the Query Rules APIs to pin or exclude documents according to criteria you set. [#227226](https://github.com/elastic/kibana/pull/227226).
- Adds a **Home** page dedicated to the Elasticsearch solution to Classic and Elasticsearch solution views [#225162](https://github.com/elastic/kibana/pull/225162).
- Updates the navigation items available for the Elasticsearch solution view and the Elasticsearch section of the Classic view [#224755](https://github.com/elastic/kibana/pull/224755).

**Sharing**:
- Adds the ability to switch between relative and absolute time range when sharing objects [#218056](https://github.com/elastic/kibana/pull/218056).


### Fixes

**Alerting**:
- Fixes a regression that caused the cases actions to disappear from the Alerts table **Bulk actions** menu [#215111](https://github.com/elastic/kibana/pull/215111).

**Dashboards and Visualizations**:
- Forwards the secondary prefix correctly when the state value is an empty string (`None` option) in Lens [#228183](https://github.com/elastic/kibana/pull/228183).
- Fixes an issue where a Lens Partition chart (i.e. `Pie`) prevented the user from selecting a legacy palette [#228051](https://github.com/elastic/kibana/pull/228051).
- Fixes an accessibility issue where dashboard controls should be grouped as a labelled list [#227633](https://github.com/elastic/kibana/pull/227633).
- Fixes incorrectly disabled range slider tooltip and moves the **Delete control** button to be more visible [#227295](https://github.com/elastic/kibana/pull/227295).
- Fixes secondary metric styles to prevent wrapping in Lens [#227234](https://github.com/elastic/kibana/pull/227234).
- Keeps the **Save** button enabled in case of save error [#227091](https://github.com/elastic/kibana/pull/227091).
- Hides the **Select All** checkbox from single select controls [#226311](https://github.com/elastic/kibana/pull/226311).
- Removes `kebab-case` warnings [#226114](https://github.com/elastic/kibana/pull/226114).
- Fixes an issue with dashboards not saving due to exceptionally high number of references in the request payload [#225908](https://github.com/elastic/kibana/pull/225908).
- Prevents dashboards from recommending adhoc data views [#225705](https://github.com/elastic/kibana/pull/225705).
- Prevents Lens Embeddable `defaultTitle` from being overwritten with a custom title after reload [#225664](https://github.com/elastic/kibana/pull/225664).
- Fixes panel title synchronization with the corresponding saved object when using `defaultTitle` [#225237](https://github.com/elastic/kibana/pull/225237).
- Fixes visual issues causing labels to be truncated [#225430](https://github.com/elastic/kibana/pull/225430).
- Refreshes **Values from a query** options for ES|QL controls on dashboard reload [#225101](https://github.com/elastic/kibana/pull/225101).
- Fixes an issue with calculating the query for retrieving ES|QL control values [#214905](https://github.com/elastic/kibana/pull/214905).
- Fixes an issue with the ES|QL **Create control** suggestions not triggering if the query already contained a control [#214833](https://github.com/elastic/kibana/pull/214833).
- Fixes the visibility of the date picker when writing ES|QL visualization queries [#214728](https://github.com/elastic/kibana/pull/214728).
- Fixes a performance issue with ES|QL visualizations in case of errors in the query [#225067](https://github.com/elastic/kibana/pull/225067).
- Fixes dashboard control value changes causing multiple fetches [#224761](https://github.com/elastic/kibana/pull/224761).
- Fixes an issue in Lens where reordering the groups within a layer would incorrectly assign the color mapping to a group other than the first [#215426](https://github.com/elastic/kibana/pull/215426).
- Fixes invalid dashboard being displayed as 404 instead of showing a validation error [#211661](https://github.com/elastic/kibana/pull/211661).
- Fixes an issue where custom ranges and multi-field values were not correctly colored based on selected color mapping configurations [#207957](https://github.com/elastic/kibana/pull/207957).

**Data ingestion and Fleet**:
- Fixes CSV export in the agent list [#225050](https://github.com/elastic/kibana/pull/225050).
- Replaces registry call when deleting Kibana assets for custom packages [#224886](https://github.com/elastic/kibana/pull/224886).
- Ensures package policy names are unique when moving across spaces [#224804](https://github.com/elastic/kibana/pull/224804).
- Fixes bulk actions incorrectly selecting agents when a namespace filter is applied [#224036](https://github.com/elastic/kibana/pull/224036).
- Reverts "Added instructions for installing Elastic Agent complete." [#223520](https://github.com/elastic/kibana/pull/223520).
- Fixes styled component theme lookup issue [#221979](https://github.com/elastic/kibana/pull/221979).
- Fixes SSL config being overridden by advanced YAML in full agent policy [#219902](https://github.com/elastic/kibana/pull/219902).
- Fixes required capability for the SIEM migrations topic [#219427](https://github.com/elastic/kibana/pull/219427).
- Makes output and Fleet Server settings non-editable for agentless policies [#218905](https://github.com/elastic/kibana/pull/218905).
- Supports integrations with secrets that contain multiple values [#216918](https://github.com/elastic/kibana/pull/216918).
- Adds remote cluster instructions for syncing integrations [#211997](https://github.com/elastic/kibana/pull/211997).
- Updates install snippets to include all platforms [#210249](https://github.com/elastic/kibana/pull/210249).

**Discover**:
- Fixes an issue where an ES|QL query was overwritten when edited while the previous request was still running [#224671](https://github.com/elastic/kibana/pull/224671).
- Fixes invalid input highlight in the **Data View** flyout [#226822](https://github.com/elastic/kibana/pull/226822).
- Fixes an issue causing Discover to freeze when dragging and dropping columns with animations disabled [#226592](https://github.com/elastic/kibana/pull/226592).
- Fixes row highlighting when reordering columns [#226584](https://github.com/elastic/kibana/pull/226584).
- Fixes error appearing when updating and then deleting a saved query [#226569](https://github.com/elastic/kibana/pull/226569).
- Fixes a cell value alignment issue for aggregate metric fields [#226562](https://github.com/elastic/kibana/pull/226562).
- Adds missing information icon to the document viewer table [#222299](https://github.com/elastic/kibana/pull/222299).
- Fixes an issue incorrectly showing the unmapped icon when a field changed from unmapped to mapped [#221308](https://github.com/elastic/kibana/pull/221308).
- Fixes the parsing of index patterns in Kibana's **Inspect** feature. Previously, certain index pattern strings were not being parsed and displayed correctly [#221084](https://github.com/elastic/kibana/pull/221084).
- Fixes an issue that causes redirects from the deprecated **Logs Stream** and **Logs Explorer** routes to Discover to lose some context such as the selected time range or KQL query [#215867](https://github.com/elastic/kibana/pull/215867).
- Excludes only Elasticsearch metadata fields from the Summary column instead of all fields starting with `_` [#213255](https://github.com/elastic/kibana/pull/213255).
- Fixes inability to clear the **Document ID** in data view field editor preview [#220891](https://github.com/elastic/kibana/pull/220891).
- Fixed multiple accessibility issues, including adding missing aria labels and column headers, improving keyboard navigation and interactions, and improving focus changes when interacting with Discover features [View list of fixes](https://github.com/elastic/kibana/issues?q=state:closed%20label:Project:Accessibility%20label:v9.1.0%20label:Team:DataDiscovery).

**ES|QL editor**:
- Fixes wrong validation on expressions between aggregations [#227989](https://github.com/elastic/kibana/pull/227989).
- Hides lookup index hidden indices from autocomplete [#227819](https://github.com/elastic/kibana/pull/227819).
- Fixes several issues with `BUCKET` function signatures [#222553](https://github.com/elastic/kibana/pull/222553).
- Fixes validation issues with the `COALESCE` function [#222425](https://github.com/elastic/kibana/pull/222425).
- Fixes incorrect suggestions after a variable such as `?value` when using the `WHERE` command [#222312](https://github.com/elastic/kibana/pull/222312).
- Fixes an issue with suggestions after using triple quotes [#221200](https://github.com/elastic/kibana/pull/221200).
- Fixes a validation issue when using asterisks `*` in queries [#219832](https://github.com/elastic/kibana/pull/219832).
- Fixes an issue with incorrect source validation in case of unknown patterns [#218352](https://github.com/elastic/kibana/pull/218352).
- Fixes a display issue with the editor's menus on Safari [#218167](https://github.com/elastic/kibana/pull/218167).
- Fixes a display issue with descriptions in suggestion tooltips [#218067](https://github.com/elastic/kibana/pull/218067).
- Correctly enables the time picker when time parameters are used with cast [#215820](https://github.com/elastic/kibana/pull/215820).
- Fixes an issue preventing warnings to display correctly when they include escaped quotes [#213685](https://github.com/elastic/kibana/pull/213685).
- Fixes a validation issue when a named parameter is used as a function [#213355](https://github.com/elastic/kibana/pull/213355).
- Fixes an issue with suggestions for the `WHERE` command in case of a multiline query [#213240](https://github.com/elastic/kibana/pull/213240).

**Elastic Observability solution**:
For the Elastic Observability 9.1.0 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.1.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Removes listing limit warning [#217945](https://github.com/elastic/kibana/pull/217945).
- Adds a setting to customize the link color of the top banner [#214241](https://github.com/elastic/kibana/pull/214241).
- Updates the wording used in **Sort by** menu options [#206464](https://github.com/elastic/kibana/pull/206464).
- Passes the correct namespace to `migrateInputDocument` [#222313](https://github.com/elastic/kibana/pull/222313).

**Machine Learning**:
- Fixes unknown fields not supported in Data Visualizer and Field Statistics [#223903](https://github.com/elastic/kibana/pull/223903).
- Fixes overflow of cards in the Machine Learning **Overview** page [#223431](https://github.com/elastic/kibana/pull/223431).
- Fixes an issue with the **Use full data** button that was causing the page to crash [#217291](https://github.com/elastic/kibana/pull/217291).
- Fixes permission to view ML nodes [#215503](https://github.com/elastic/kibana/pull/215503).
- Fixes chart in single metric anomaly detection wizard [#214837](https://github.com/elastic/kibana/pull/214837).
- Prevents multiple clicks in the **Delete Model** dialog [#211580](https://github.com/elastic/kibana/pull/211580).
- Fixes further deployment of models after a failed deployment [#211459](https://github.com/elastic/kibana/pull/211459).
- Allows hiding the **Load query** and **Save query** options in the query bar menu on AIOps pages [#210556](https://github.com/elastic/kibana/pull/210556).

**Management**:
- Fixes the search functionality for spaces created with an image as their avatar type [#220398](https://github.com/elastic/kibana/pull/220398).
- Fixes styling issues in the **Edit data view** flyout [#228078](https://github.com/elastic/kibana/pull/228078).

**Search**:
- Adjusts the `z-index` of the app menu header to not conflict with the Persistent Console [#224708](https://github.com/elastic/kibana/pull/224708).
- Fixes an issue preventing solution navigation submenu items from being displayed when the navigation is collapsed [#227705](https://github.com/elastic/kibana/pull/227705).


## 9.0.8

<important>
  The 9.0.8 release contains fixes for potential security vulnerabilities. Check our [security advisory](https://discuss.elastic.co/c/announcements/security-announcements/31) for more details.
</important>


### Fixes

**Dashboards and Visualizations**:
- Fixes text kerning issues in PDF/PNG exports of dashboards and visualizations [#235516](https://github.com/elastic/kibana/pull/235516).
- Fixes an issue where the dashboard title would not get updated in the breadcrumb when edited from the list of dashboards [#236561](https://github.com/elastic/kibana/pull/236561).
- Fixes an issue with the Lens table's column sort order being different in the dashboard and the exported CSV [#236673](https://github.com/elastic/kibana/pull/236673).

**Data ingestion and Fleet**:
- Validates the Logstash pipeline ID at the Kibana API level [#236347](https://github.com/elastic/kibana/pull/236347).
- Adds a unique count to improve accuracy of the number of transforms on the integrations overview page [#236177](https://github.com/elastic/kibana/pull/236177).

**Discover**:
- Clears sort by `timestamp` when navigating from classic to ESQL mode [#235338](https://github.com/elastic/kibana/pull/235338).

**Machine Learning**:
- Hides the show forecast checkbox when selecting a new job in the Single Metric Viewer [#236724](https://github.com/elastic/kibana/pull/236724).
- Improves trained model performance by adding filters to the request to fetch all index settings [#237072](https://github.com/elastic/kibana/pull/237072).
- Makes alerts visible in Anomaly Explorer to all Machine Learning-only users regardless of where they create rules [#236289](https://github.com/elastic/kibana/pull/236289).
- Fixes the **Job details** flyout on the **Analytics Map** page [#236131](https://github.com/elastic/kibana/pull/236131).
- Limits log rate analysis category requests to reduce `msearch` usage [#235611](https://github.com/elastic/kibana/pull/235611).
- Fixes rendering of the dashboard panel in PDF reporting for the Anomaly Swim Lane [#235475](https://github.com/elastic/kibana/pull/235475).

**Management**:
- Fixes handling of special characters when creating, editing, and cloning ingest pipelines [#233651](https://github.com/elastic/kibana/pull/233651).

**Stack Management**:
- Adds the ability to do partial matches and searches in the **API keys** section [#221959](https://github.com/elastic/kibana/pull/221959).


## 9.0.7


### Fixes

**Elastic Security solution**:
For the Elastic Security 9.0.7 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana security**:
- Fixes an issue causing the API Keys Management page to break when trying to load API keys with null names [#234083](https://github.com/elastic/kibana/pull/234083).

**Search solution**:
- Fixes the Docs Explorer paging information to correctly render bold text instead of escaped HTML [#234079](https://github.com/elastic/kibana/pull/234079).


## 9.0.6

<important>
  The 9.0.6 release contains fixes for potential security vulnerabilities. Check our [security advisory](https://discuss.elastic.co/c/announcements/security-announcements/31) for more details.
</important>


### Features and enhancements

**Dashboards and Visualizations**:
- Improves usability of dashboards when zooming up to 400% [#228978](https://github.com/elastic/kibana/pull/228978).


### Fixes

**Kibana platform**:
- Fixes the breadcrumb to include a link to the home page when browsing pages from the **Elasticsearch** section of the navigation [#230270](https://github.com/elastic/kibana/pull/230270).
- Updates the built-in `reporting_user` role to leverage a new  `reporting_user` reserved privilege [#231533](https://github.com/elastic/kibana/pull/231533).

**Search**:
- Fixes an incorrect link in the **Build** breadcrumb when navigating to the **Connectors** and **Elasticsearch indices** pages [#232504](https://github.com/elastic/kibana/pull/232504).


## 9.0.5


### Features and enhancements

**Dashboards and Visualizations**:
- Improves usability of dashboards when zooming up to 400% [#228978](https://github.com/elastic/kibana/pull/228978).


### Fixes

**Dashboards and Visualizations**:
- Fixes an issue with the plus sign `+` not being properly encoded when it's part of a date math expression [#230469](https://github.com/elastic/kibana/pull/230469).
- Fixes an issue in Firefox preventing you from scrolling in the Lens editor flyout [#228625](https://github.com/elastic/kibana/pull/228625).
- Fixes an issue preventing you from saving linked TSVB visualizations when changing data views [#228685](https://github.com/elastic/kibana/pull/228685).
- Fixes a console error occurring when adding a Region map visualization to a dashboard [#228669](https://github.com/elastic/kibana/pull/228669).
- Fixes an issue with the dashboard toolbar header not correctly staying visible when opening the Dashboards app from some specific sections of the Classic navigation [#229621](https://github.com/elastic/kibana/pull/229621).
- Fixes an issue in reports where a PNG or PDF export would offset and clip part of the visualization in Lens [#228603](https://github.com/elastic/kibana/pull/228603).

**Data ingestion and Fleet**:
- Fixes an issue that could cause some SSL configurations set using the UI to be overridden [#230758](https://github.com/elastic/kibana/pull/230758).
- Fixes an issue where the SSL configuration isn't properly added to agent policies with pre-configured output types [#230211](https://github.com/elastic/kibana/pull/230211).
- Fixes agentless integrations using 'organization', 'division', or 'team' data fields being overwritten by package agentless metadata on the agent policy [#230479](https://github.com/elastic/kibana/pull/230479).
- Adds `azure-blob-storage` and `gcs` inputs to the AGENTLESS_DISABLED_INPUTS list [#229117](https://github.com/elastic/kibana/pull/229117).

**Discover**:
- Improves performance of breakdown field search [#229335](https://github.com/elastic/kibana/pull/229335).
- Enables the **Save query** button after making changes [#229053](https://github.com/elastic/kibana/pull/229053).
- Fixes the field being picked for fetching stats in the sidebar popover [#228969](https://github.com/elastic/kibana/pull/228969).
- Fixes an issue where some Discover **Copy to clipboard** actions only worked when accessing Kibana in a secure browser context [#229531](https://github.com/elastic/kibana/pull/229531).
- Fixes the handling of the **Body cell lines** display option in Discover when the default value is set to `-1` in Advanced Settings [#228697](https://github.com/elastic/kibana/pull/228697).

**Elastic Observability solution**:
For the Elastic Observability 9.0.5 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.0.5 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes an issue with overlapping action icons in the **Data views** menu when on mobile [#229771](https://github.com/elastic/kibana/pull/229771).
- Fixes a display issue with counter indicators on toast messages [#229300](https://github.com/elastic/kibana/pull/229300).
- Fixes an issue leading to some features not being visible when updating a space solution view to Classic [#230385](https://github.com/elastic/kibana/pull/230385).
- Decreases the loading time drastically when loading Index Management component templates [#228709](https://github.com/elastic/kibana/pull/228709).

**Machine Learning**:
- Removes `removeIfExists` from the synchronization task scheduler [#228783](https://github.com/elastic/kibana/pull/228783).


## 9.0.4


### Features and enhancements

**Data ingestion and Fleet**:
- Adds a tooltip to the **Last activity** column in Agent list UI [#224850](https://github.com/elastic/kibana/pull/224850).

**Machine Learning**:
- Improves error messages in the AI Connector creation UI and ensures they're surfaced in Kibana [#221859](https://github.com/elastic/kibana/pull/221859).


### Fixes

**Dashboards and Visualizations**:
- Fixes an issue with dashboard sharing links where copied links were not shortened and some users were unable to copy links in new spaces [#227625](https://github.com/elastic/kibana/pull/227625).
- Stops dashboards from recommending adhoc data views [#225705](https://github.com/elastic/kibana/pull/225705).
- Prevents dashboards from initiating duplicate requests when making a selection on a control [#224761](https://github.com/elastic/kibana/pull/224761).

**Data ingestion and Fleet**:
- Fixes an issue that causes the CSV export to fail in Agent list [#225050](https://github.com/elastic/kibana/pull/225050).
- Replaces call to registry when deleting Kibana assets for custom packages [#224886](https://github.com/elastic/kibana/pull/224886).
- Fixes an issue where the background task was not deleting some unenrolled Elastic Agents [#224808](https://github.com/elastic/kibana/pull/224808).
- Fixes bulk actions incorrectly selecting Elastic Agents with the namespaces filter [#224036](https://github.com/elastic/kibana/pull/224036).

**Discover**:
- Makes expiration badges singular and plural [#227035](https://github.com/elastic/kibana/pull/227035).

**Elastic Observability solution**:
For the Elastic Observability 9.0.4 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.0.4 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Hides the header and side navigation when printing or exporting a dashboard with **Print layout** selected [#227095](https://github.com/elastic/kibana/pull/227095).

**Search**:
- Fixes handling of context limit errors in Playground when using the Elastic Managed LLM  [#225360](https://github.com/elastic/kibana/pull/225360).
- Adjusts `z-index` of the header menu to avoid conflicting with Console [#224708](https://github.com/elastic/kibana/pull/224708).


## 9.0.3

<important>
  The 9.0.3 release contains fixes for potential security vulnerabilities. Check our [security advisory for more details](https://discuss.elastic.co/c/announcements/security-announcements/31).
</important>


### Features and enhancements

**Elastic Observability solution**:
For the Elastic Observability 9.0.3 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.0.3 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

### Fixes

**Alerting**:
- Fixes an issue that caused Kibana to repeatedly restart when `xpack.alerting.cancelAlertsOnRuleTimeout` was set to `false` in the `kibana.yml` file [#222263](https://github.com/elastic/kibana/pull/222263).
- Resolves multiple issues in the Watcher UI that were introduced in 8.18.0, 8.18.1, 9.0.0, and 9.1.0. This includes the table not displaying more than 10 watches, an error banner appearing unexpectedly in certain scenarios, and the search bar functionality not working as expected [#223898](https://github.com/elastic/kibana/pull/223898).
- Fixes an issue that caused errors when rules ran during an active maintenance window that had filters and a matching rule category [#221702](https://github.com/elastic/kibana/pull/221702).

**Dashboards and Visualizations**:
- Fixes an issue that prevented navigating through pages when inspecting a chart's data  [#217937](https://github.com/elastic/kibana/pull/217937).

**Discover**:
- In version 9.0.0, we changed the way time ranges are handled for Discover ESQL CSV exports ([#216792](https://github.com/elastic/kibana/pull/216792)). We realized that this change caused an issue with CSV Post URLs now using an absolute time range instead of a relative one, leading to duplicate reports being generated. We've reverted this change while we investigate different solutions [#223249](https://github.com/elastic/kibana/pull/223249).
- The request URL now appears correctly again when inspecting an ESQL request [#221816](https://github.com/elastic/kibana/pull/221816).

**Elastic Observability solution**:
For the Elastic Observability 9.0.3 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.0.3 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Machine Learning**:
- Ensures the Amazon Bedrock connector respects the action proxy configuration [#224130](https://github.com/elastic/kibana/pull/224130).
- Ensures the OpenAI connector respects the action proxy configuration for all sub-actions [#219617](https://github.com/elastic/kibana/pull/219617).
- Allows you to add additional fields even if your ingest pipeline is empty when uploading a file [#222775](https://github.com/elastic/kibana/pull/222775).


## 9.0.2


### Enhancements

**Elastic Observability solution**:
For the Elastic Observability 9.0.2 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).

### Fixes

**Alerting**:
- Fixes ignored dynamic templates [#219875](https://github.com/elastic/kibana/pull/219875).
- Fixes an issue where notifications would not trigger after the expiration of maintenance windows on active alerts [#219797](https://github.com/elastic/kibana/pull/219797).

**Dashboards**:
- When adding a panel using **Add from library**, the interface now shows a success message and scrolls the dashboard to the added panel [#220122](https://github.com/elastic/kibana/pull/220122).

**Elastic Observability solution**:
For the Elastic Observability 9.0.2 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.0.2 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

## 9.0.1

<important>
  The 9.0.1 release contains fixes for potential security vulnerabilities. See our [security advisory](https://discuss.elastic.co/c/announcements/security-announcements/31) for more details.
</important>


### Enhancements

**Data ingestion and Fleet**:
- Reuses shared integration policies when duplicating agent policies [#217872](https://github.com/elastic/kibana/pull/217872).

**Elastic Security solution**:
For the Elastic Security 9.0.1 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).

### Fixes

**Dashboards & Visualizations**:
- When exploring a dashboard, the request inspector now shows the correct request and response in any successful scenario [#216519](https://github.com/elastic/kibana/pull/216519).
- Correctly synchronize the dashboard ESQL query and filters with the corresponding visualization query in **Lens** [#218997](https://github.com/elastic/kibana/pull/218997).
- Fixes an issue where keywords could be incorrectly formatted in a metric visualization [#218233](https://github.com/elastic/kibana/pull/218233).

**Discover**:
- Fixes incorrect behavior for requests on fields where the *Allow hidden and system indices* (`allow_hidden`) option of the data view could be ignored [#217628](https://github.com/elastic/kibana/pull/217628).

**Elastic Observability solution**:
For the Elastic Observability 9.0.1 release information, refer to [Elastic Observability Solution Release Notes](https://www.elastic.co/docs/release-notes/observability).
**Elastic Security solution**:
For the Elastic Security 9.0.1 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana platform**:
- Fixes broken icons in integrations coming from the Home plugin [#219206](https://github.com/elastic/kibana/pull/219206).
- Fixes placeholder disappearing when a value is set in the Monaco code editor [#217828](https://github.com/elastic/kibana/pull/217828).

**Machine Learning**:
- Fixes an issue that could cause a page loading error to show when changing between Inference endpoints services [#219020](https://github.com/elastic/kibana/pull/219020).
- Fixes missing field names in the step details of the anomaly detection job wizards [#218570](https://github.com/elastic/kibana/pull/218570).


## 9.0.0

If you're upgrading to version 9.0.0, you first need to upgrade to version 8.18. We recommend checking the [8.18 release notes](https://www.elastic.co/guide/en/kibana/8.18/release-notes-8.18.0.html).

### Features and enhancements

**Theme**:
Kibana 9.0 introduces a more modern and refined look and feel. This new theme brings a vibrant color palette, improved dark mode support (including honoring your system preferences), and more that will bring your data in Kibana to life.
**Data ingestion and Fleet**:
- New setting allowing automatic deletion of unenrolled agents in Fleet settings [#195544](https://github.com/elastic/kibana/pull/195544).
- Improves filtering and visibility of `Uninstalled` and `Orphaned` agents in Fleet, by differentiating them from `Offline` agents [#205815](https://github.com/elastic/kibana/pull/205815).
- Introduces air-gapped configuration for bundled packages [#202435](https://github.com/elastic/kibana/pull/202435).
- Updates removed parameters of the Fleet -> Logstash output configurations [#210115](https://github.com/elastic/kibana/pull/210115).
- Updates max supported package version  [#196675](https://github.com/elastic/kibana/pull/196675).

**Elastic Observability solution**:
- Alerting rules:
  - Adds the reason message to the rules recovery context [#211411](https://github.com/elastic/kibana/pull/211411).
- SLOs:
  - Splits Up SLO Details from Overview. Static data that describes the SLO definition has been moved to a separate tab, making charts and valuable information about SLIs faster to access. [#212826](https://github.com/elastic/kibana/pull/212826).
- SpaceId can now be referenced in document-based access filters for roles to restrict a user's access to SLI data for spaces where they do not have access [#214278](https://github.com/elastic/kibana/pull/214278).
- Adds a link to the location badge on synthetics SLOs that sends to the Monitors page with a filter applied that matches the location of the origin SLO [#210695](https://github.com/elastic/kibana/pull/210695).
- Synthetics:
  - Ensures 404 is returned only if `screenshot_ref` is truly not present [#215241](https://github.com/elastic/kibana/pull/215241).

**Elastic Security solution**:
For the Elastic Security 9.0.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Kibana security**:
- Updates `js-yaml` to `4.1.0` [#190678](https://github.com/elastic/kibana/pull/190678).

**Machine Learning**:
- Removes use of `ignore_throttled` [#199107](https://github.com/elastic/kibana/pull/199107).

**Platform**:
- Adds warning header to deprecated API endpoints [#205926](https://github.com/elastic/kibana/pull/205926).
- Sets HTTP2 as default if SSL is enabled and adds deprecation log if SSL is not enabled or protocol is set to HTTP1 [#204384](https://github.com/elastic/kibana/pull/204384).


### Fixes

**Dashboards & Visualizations**:
- Fixes an issue in Lens where colors behind text were not correctly assigned, such as in `Pie`, `Treemap` and `Mosaic` charts [#209632](https://github.com/elastic/kibana/pull/209632).
- Fixes an issue where changing the *Ignore timeout results* control setting wasn't taken into account [#208611](https://github.com/elastic/kibana/pull/208611).
- Force returns 0 on empty buckets on count if `null` flag is disabled [#207308](https://github.com/elastic/kibana/pull/207308).
- Fixes infinite loading time for some charts due to search context reload [#203150](https://github.com/elastic/kibana/pull/203150).

**Data ingestion and Fleet**:
- Fixes overlay for Integrations on mobile [#215312](https://github.com/elastic/kibana/pull/215312).
- Update minimum package spec version to 2.3 [#214600](https://github.com/elastic/kibana/pull/214600).
- Fixes a validation error happening on multi-text input fields [#205768](https://github.com/elastic/kibana/pull/205768).

**Elastic Observability solution**:
- Alerting rules:
  - Fixes chat on the Alerts page [#197126](https://github.com/elastic/kibana/pull/197126).
- Infrastructure inventory:
  - Fixes an error that could prevent the Observability Infrastructure inventory view from loading after an upgrade due to missing versioning on inventory_view_saved_object [#207007](https://github.com/elastic/kibana/pull/207007).
- SLOs:
  - Fixes an issue where clicking on the name badge for a synthetics monitor on an SLO details page would lead to a page that failed to load monitor details [#210695](https://github.com/elastic/kibana/pull/210695).
- Allows use of wildcard filters in SLO queries when DSL filters are also used [#213119](https://github.com/elastic/kibana/pull/213119).
- Ensures that when an SLO is created, its ID is correctly verified to be unique across all spaces [#214496](https://github.com/elastic/kibana/pull/214496).

**Elastic Security solution**:
For the Elastic Security 9.0.0 release information, refer to [Elastic Security Solution Release Notes](https://www.elastic.co/docs/release-notes/security).
**Platform**:
- Fixes several interface inconsistencies on the Space creation and settings pages [#197303](https://github.com/elastic/kibana/pull/197303).