﻿---
title: Elasticsearch deprecations
description: Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for...
url: https://www.elastic.co/docs/release-notes/elasticsearch/deprecations
products:
  - Elasticsearch
---

# Elasticsearch deprecations
Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for a period before removal, giving you time to update your applications.
Review the deprecated functionality for Elasticsearch. While deprecations have no immediate impact, we strongly encourage you update your implementation after you upgrade. To learn how to upgrade, check out [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade).
To give you insight into what deprecated features you’re using, Elasticsearch:
- Returns a `Warn` HTTP header whenever you submit a request that uses deprecated functionality.
- [Logs deprecation warnings](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration/update-elasticsearch-logging-levels#deprecation-logging) when deprecated functionality is used.
- [Provides a deprecation info API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-migration-deprecations) that scans a cluster’s configuration and mappings for deprecated functionality.


## 9.3.0

ILM:
- Add deprecation notice for `max_size` rollover condition [#135765](https://github.com/elastic/elasticsearch/pull/135765) (issue: [#130737](https://github.com/elastic/elasticsearch/issues/130737))

Infra/Logging:
- Add deprecation lenient booleans usage for analysis boolean setting (3rd party plugins) and boolean system properties. [#137885](https://github.com/elastic/elasticsearch/pull/137885) (issue: [#128993](https://github.com/elastic/elasticsearch/issues/128993))


## 9.2.5

There are no deprecations associated with this release.

## 9.1.10

There are no deprecations associated with this release.

## 9.2.4

There are no deprecations associated with this release.

## 9.1.9

There are no deprecations associated with this release.

## 9.2.3

There are no deprecations associated with this release.

## 9.2.2

There are no deprecations associated with this release.

## 9.1.8

There are no deprecations associated with this release.

## 9.1.7

There are no deprecations associated with this release.

## 9.2.1

There are no deprecations associated with this release.

## 9.1.6

There are no deprecations associated with this release.

## 9.2.0

Cluster Coordination:
- Remove `PeerFinder` request timeout [#134365](https://github.com/elastic/elasticsearch/pull/134365)


## 9.0.8

There are no deprecations associated with this release.

## 9.1.5

There are no deprecations associated with this release.

## 9.1.4

There are no deprecations associated with this release.

## 9.0.7

There are no deprecations associated with this release.

## 9.0.6

Authorization:
- Change `reporting_user` role to leverage reserved kibana privileges [#132766](https://github.com/elastic/elasticsearch/pull/132766)


## 9.1.3

Authorization:
- Change `reporting_user` role to leverage reserved kibana privileges [#132766](https://github.com/elastic/elasticsearch/pull/132766)


## 9.1.2

There are no deprecations associated with this release.

## 9.0.5

There are no deprecations associated with this release.

## 9.1.1

There are no deprecations associated with this release.

## 9.1.0

There are no deprecations associated with this release.

## 9.0.4

There are no deprecations associated with this release.

## 9.0.3

Engine:
- Deprecate `indices.merge.scheduler.use_thread_pool` setting [#129464](https://github.com/elastic/elasticsearch/pull/129464)


## 9.0.2

There are no deprecations associated with this release.

## 9.0.1

There are no deprecations associated with this release.

## 9.0.0

ESQL:
- Drop support for brackets from METADATA syntax [#119846](https://github.com/elastic/elasticsearch/pull/119846) (issue: [#115401](https://github.com/elastic/elasticsearch/issues/115401))

Ingest Node:
- Fix `_type` deprecation on simulate pipeline API [#116259](https://github.com/elastic/elasticsearch/pull/116259)

Machine Learning:
- Add deprecation warning for flush API [#121667](https://github.com/elastic/elasticsearch/pull/121667) (issue: [#121506](https://github.com/elastic/elasticsearch/issues/121506))
- Removing index alias creation for deprecated transforms notification index [#117583](https://github.com/elastic/elasticsearch/pull/117583)
- [Inference API] Deprecate elser service [#113216](https://github.com/elastic/elasticsearch/pull/113216)

Rollup:
- Emit deprecation warning when executing one of the rollup APIs [#113131](https://github.com/elastic/elasticsearch/pull/113131)

Search:
- Deprecate Behavioral Analytics CRUD apis [#122960](https://github.com/elastic/elasticsearch/pull/122960)

Security:
- Deprecate certificate based remote cluster security model [#120806](https://github.com/elastic/elasticsearch/pull/120806)