﻿---
title: Elasticsearch JavaScript Client breaking changes
description: Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade, carefully review the Elasticsearch...
url: https://www.elastic.co/docs/release-notes/elasticsearch/clients/javascript/breaking-changes
products:
  - Elasticsearch Client
  - Elasticsearch JavaScript Client
---

# Elasticsearch JavaScript Client breaking changes
Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade, carefully review the Elasticsearch JavaScript Client breaking changes and take the necessary steps to mitigate any issues. To learn how to upgrade, check [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade).

## 9.0.0

<dropdown title="Changes to the optional body property">
  In 8.x, every API function had a `body` property that would provide a place to put arbitrary values that should go in the HTTP request body, even if they were not noted in the specification or documentation. In 9.0, each API function still includes an optional `body` property, but TypeScript's type checker will disallow properties that should go in the root of the object. A `querystring` parameter has also been added that behaves the same as `body`, but inserts its values into the request querystring.**Impact** Some adjustments to API calls may be necessary for code that used a `body` property 8.x, especially to appease the TypeScript type checker, but it should not have any impact on any code that was not using a `body` property. The `estypesWithBody` export and `typesWithBodyKey` module are no longer available.**Action** Check existing code for use of the `body` property, and move any properties that should be in the root object according to the API function's request type definition. If using TypeScript, the TypeScript type checker will surface most of these issues for you. Also look for any imports of `estypesWithBody` or `typesWithBodyKey` and update them to `estypes` and `types`, respectively.
</dropdown>

<dropdown title="Changes to API parameter collation into an HTTP request">
  The logic for where each parameter in an API function call should be added to its HTTP request has been updated:
  1. If recognized as a `body` parameter according to the Elasticsearch specification, put it in the JSON body
  2. If recognized as a `path` parameter, put it in the URL path
  3. If recognized as a `query` parameter or a "common" query parameter (e.g. `pretty`, `error_trace`), put it in the querystring
  4. If not recognized, and this API accepts a JSON body, put it in the JSON body
  5. If not recognized and this API does not accept a JSON body, put it in the querystring
  The first two steps are identical in 8.x. The final three steps replace the logic from 8.x that put all unrecognized parameters in the querystring.**Impact** Some parameters that were sent via querystring to Elasticsearch may be sent in the JSON request body, and vice versa.**Action** If Elasticsearch sends back an error response due to a request not being valid, verify with the client's TypeScript type definitions, or via the docs, that the parameters your code passes are correct.
</dropdown>

<dropdown title="Removal of the default 30-second timeout on all API calls">
  The default 30-second timeout on all HTTP requests sent to Elasticsearch has been dropped in favor of having no timeout set at all. The previous behavior still works as it did when setting the `requestTimeout` value.See pull request [#2573](https://github.com/elastic/elasticsearch-js/pull/2573) for more information.**Impact** Requests to Elasticsearch that used to time out after 30 seconds will now wait for as long as it takes for Elasticsearch to respond.**Action** In environments where it is not ideal to wait for an API response indefinitely, manually setting the `requestTimeout` option when instantiating the client still works as it did in 8.x.
</dropdown>