﻿---
title: Elasticsearch Java Client 9.2.0
description: Discover what changed in the 9.2.0 version of the Java client. Nothing was deprecated in this version of the client. 
url: https://www.elastic.co/docs/release-notes/elasticsearch/clients/java/9-2-0
products:
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Elasticsearch Java Client 9.2.0
Discover what changed in the 9.2.0 version of the Java client.

## Breaking changes

<dropdown title="Map to NamedValue CompositeAggregation.sources">
  `sources` in `CompositeAggregation` was wrongly mapped as `List<Map>`, but the server doesn't actually accept more than one value, so the type has been changed to `List<NamedValue>`.**Action** Change the builder to use the correct type.
  Example:
  - Old
    ```java
    esClient.search(s -> s
        .aggregations("agg", a -> a
            .composite(c -> c
                .sources(Map.of("source", CompositeAggregationSource.of(cas -> cas...))))
        )
    );
    ```
  - New
    ```java
    esClient.search(s -> s
        .aggregations("agg", a -> a
            .composite(c -> c
                .sources(NamedValue.of("source", CompositeAggregationSource.of(cas -> cas...))))
        )
    );
    ```
</dropdown>

<dropdown title="String to Double GetOverallBucketsRequest.overallScore">
  `overallScore` in `GetOverallBucketsRequest` was wrongly mapped as `String`, but the correct value to be sent to the server is `Double`, so the type has been changed to `Double`.**Action** Change the builder to use the correct type.
  Example:
  - Old
    ```java
    esClient.ml()
        .getOverallBuckets(b -> b
            .overallScore("2")
            ...
    );
    ```
  - New
    ```java
    esClient.ml()
        .getOverallBuckets(b -> b
            .overallScore(2D)
            ...
    );
    ```
</dropdown>

<dropdown title="Level to NodeStatsLevel NodesStatsRequest.level">
  `level` in `NodesStatsRequest` was wrongly mapped as the `Level` enum, which did not match the values accepted by the server, so it has been replaced with `NodeStatsLevel`.**Action** Change the builder to use the correct enum.
  Example:
  - Old
    ```java
    esClient.nodes()
        .stats(s -> s
            .level(Level.Indices)
        );
    ```
  - New
    ```java
    esClient.nodes()
        .stats(s -> s
            .level(NodeStatsLevel.Indices)
        );
    ```
</dropdown>

<dropdown title="TimeUnit to Time StreamsStatusRequest.masterTimeout">
  `masterTimeout` in `StreamsStatusRequest` was wrongly mapped as `TimeUnit`, but the correct value to be sent to the server is `Time`, so the type has been changed to `Time`.**Action** Change the builder to use the correct type.
  Example:
  ```java
  esClient.streams()
      .status(s -> s
          .masterTimeout(Time.of(t -> t.time("10s")))
      );
  ```
</dropdown>


## Features and enhancements

<dropdown title="Jackson 3 implementation of the JSON object mapper">
  Following the stable release of the [Jackson library version 3](https://github.com/FasterXML/jackson/wiki/Jackson-Release-3.0), the Jackson 3 implementation of object mapper is now available!
  The default implementation will stay version 2 for now, so to try the new implementation replace `JacksonJsonpMapper` with `Jackson3JsonpMapper`.
  Example with shortcut builder:
  ```java
  try (ElasticsearchClient client = ElasticsearchClient.of(e -> e
          .jsonMapper(new Jackson3JsonpMapper())
          .host("your-host")
          .apiKey("your-api-keys"))) {
          ...
  }
  ```
</dropdown>

<dropdown title="elasticsearch-rest5-client as separate jar">
  The Elasticsearch Java client historically used a "Low Level Rest Client" (LLRC) based on Apache http client version 4 to handle http communications and distribution of requests among the nodes of a cluster.This directory is a port of this client to Apache http client version 5 that is mostly a drop-in replacement, except for the initialization phase.It is provided as an independent library as a convenience to users who have an existing code based on LLRC and would like to migrate to the more modern Apache http 5 library.[https://mvnrepository.com/artifact/co.elastic.clients/elasticsearch-rest5-client](https://mvnrepository.com/artifact/co.elastic.clients/elasticsearch-rest5-client)
</dropdown>


## Deprecations

Nothing was deprecated in this version of the client.