﻿---
title: Elasticsearch Java Client 9.1.0
description: Discover what changed in the 9.1.0 version of the Java client. Nothing was deprecated in this version of the client. 
url: https://www.elastic.co/docs/release-notes/elasticsearch/clients/java/9-1-0
products:
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Elasticsearch Java Client 9.1.0
Discover what changed in the 9.1.0 version of the Java client.

## Breaking changes

<dropdown title="Map to NamedValue Highlight.fields">
  `fields` in `Highlight` was wrongly mapped as `List<Map>`, but the server doesn't actually accept more than one value, so the type has been changed to `List<NamedValue>`.**Action** Change the builder to use the correct type.
  Example with `SearchRequest`:
  - Old
    ```java
    esClient.search(s -> s
        .index("*")
        .highlight(h -> h
            .fields(Map.of("highlighter-field", HighlightField.of(hf -> hf...)))
        )
    ,Void.class);
    ```
  - New
    ```java
    esClient.search(s -> s
        .index("*")
        .highlight(h -> h
            .fields(NamedValue.of("highlighter-field", HighlightField.of(hf -> hf...)))
        )
    ,Void.class);
    ```
</dropdown>

<dropdown title="Map to List<Map> WeightedTokensQuery.tokens">
  `tokens` in `WeightedTokensQuery` was mapped as `Map`, but the server can actually accept more than one map, so the type has been changed to `List<Map>`.**Action** Nothing should be changed since the builders for List also accept a single value.
</dropdown>

<dropdown title="Class name change: IndicesBlockStatus -> AddIndicesBlockStatus in AddBlockResponse">
  `IndicesBlockStatus` was renamed to `AddIndicesBlockStatus` to avoid confusion with the new `RemoveIndicesBlockStatus`**Action** Replace the missing class with the new class name.
</dropdown>


## Features and enhancements

<dropdown title="Opentelemetry update to stable conventions">
  Following the stable release of Opentelemetry's database conventions, the client was updated to use the correct attribute names.
  More details in the PR: [#1017](https://github.com/elastic/elasticsearch-java/pull/1017)
</dropdown>

<dropdown title="GetAliasResponse exception bug fix">
  `GetAliasesResponse` is a special case because it can return both an exception and the actual response, in case 2 aliases, 1 present and 1 missing, are added to `GetAliasesRequest`. The java client was unable to parse the response and used to throw a `TransportException`, this was fixed by adding the additional alias information to the `metadata` field in `ErrorCause`:
  ```java
  try{
      client.indices().getAlias(a -> a.name("test","test2"));
  }
  catch (ElasticsearchException e){
      Map<String, JsonData> metadata = e.error().metadata();
      JsonData index = metadata.get("example-index");
      Map aliases = index.to(Map.class);
      assertEquals("test", aliases.keySet().iterator().next());
  }
  ```
  More details in the PR: [#1041](https://github.com/elastic/elasticsearch-java/pull/1041)
</dropdown>


## Deprecations

Nothing was deprecated in this version of the client.