﻿---
title: Elasticsearch Java Client 9.0.4
description: Discover what changed in the 9.0.4 version of the Java client. There are no breaking changes in this version of the client. Rest5ClientBuilder now has...
url: https://www.elastic.co/docs/release-notes/elasticsearch/clients/java/9-0-4
products:
  - Elasticsearch Client
  - Elasticsearch Java Client
---

# Elasticsearch Java Client 9.0.4
Discover what changed in the 9.0.4 version of the Java client.

## Breaking changes

There are no breaking changes in this version of the client.

## Features and enhancements


### Added callbacks to Rest5ClientBuilder

`Rest5ClientBuilder` now has the same level of in-depth configuration as the legacy `RestClientBuilder`, allowing you to customize the underlying Apache `HttpClient` through callback functions. For example, here's how to configure the `IOReactor` thread count:
```java
Rest5ClientBuilder builder = Rest5Client
    .builder(new HttpHost("localhost", 9200))
    .setHttpClientConfigCallback(c -> c
        .setIOReactorConfig(IOReactorConfig.custom()
            .setIoThreadCount(1).build()
        )
    );
```

Here's how to customize the response timeout:
```java
Rest5ClientBuilder builder = Rest5Client
    .builder(new HttpHost("localhost", 9200))
    .setRequestConfigCallback(r -> r
        .setConnectTimeout(Timeout.of(5000, TimeUnit.MILLISECONDS))
        .setResponseTimeout(Timeout.of(30000, TimeUnit.MILLISECONDS))
        .build()
    );
```


## Deprecations

Nothing was deprecated in this version of the client.