﻿---
title: Elastic Distribution of OpenTelemetry PHP breaking changes
description: Breaking changes for Elastic Distribution of OpenTelemetry PHP.
url: https://www.elastic.co/docs/release-notes/edot/sdks/php/breaking-changes
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry PHP
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Distribution of OpenTelemetry PHP breaking changes
Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade, carefully review the Elastic Distribution of OpenTelemetry PHP breaking changes and take the necessary steps to mitigate any issues.

## Version 1.2.0

<dropdown title="Removal of ELASTIC_OTEL_VERIFY_SERVER_CERT (replaced by OTEL_EXPORTER_OTLP_INSECURE)">
  The environment variable ELASTIC_OTEL_VERIFY_SERVER_CERT has been removed and replaced by the standard OpenTelemetry variable OTEL_EXPORTER_OTLP_INSECURE.**Impact**
  Any configuration still using ELASTIC_OTEL_VERIFY_SERVER_CERT is ignored. TLS server certificate verification now defaults to enabled (no change here) unless explicitly disabled via OTEL_EXPORTER_OTLP_INSECURE=true.**Semantic change**
  Previous variable was affirmative (verify on true). New variable is negative (insecure on true):
  - ELASTIC_OTEL_VERIFY_SERVER_CERT=true  → OTEL_EXPORTER_OTLP_INSECURE=false (secure; default)
  - ELASTIC_OTEL_VERIFY_SERVER_CERT=false → OTEL_EXPORTER_OTLP_INSECURE=true (insecure; TLS verification disabled)
  **Action**
  Remove ELASTIC_OTEL_VERIFY_SERVER_CERT from environments. For production leave OTEL_EXPORTER_OTLP_INSECURE unset or set to false. Only for local/testing disable verification:
  ```
  OTEL_EXPORTER_OTLP_INSECURE=true
  ```
  View PR [PR #300](https://github.com/elastic/elastic-otel-php/pull/300)
</dropdown>