﻿---
title: Elastic Distribution of OpenTelemetry Node.js breaking changes
description: Breaking changes for Elastic Distribution of OpenTelemetry Node.js.
url: https://www.elastic.co/docs/release-notes/edot/sdks/node/breaking-changes
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Node
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Distribution of OpenTelemetry Node.js breaking changes
Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade, carefully review the Elastic Distribution of OpenTelemetry  breaking changes and take the necessary steps to mitigate any issues.

## 1.2.0

<dropdown title="Change usage of "redis-4" to "redis" in `OTEL_NODE_ENABLED_INSTRUMENTATIONS` and `OTEL_NODE_DISABLED_INSTRUMENTATIONS`">
  Support for instrumenting `redis` version 4 has moved from `@opentelemetry/instrumentation-redis-4` to `@opentelemetry/instrumentation-redis`. If you are using the `OTEL_NODE_ENABLED_INSTRUMENTATIONS` or `OTEL_NODE_DISABLED_INSTRUMENTATIONS` environment variables to control instrumentation of `redis@4` you will need to change from using "redis-4" to "redis".
</dropdown>


## 1.1.0

<dropdown title="AWS SDK v2 instrumentation has been dropped">
  Refer to the [opentelemetry-instrumentation-aws-sdk release notes](https://github.com/open-telemetry/opentelemetry-js-contrib/blob/main/plugins/node/opentelemetry-instrumentation-aws-sdk/CHANGELOG.md#0510-2025-04-08). The `aws.region` span attribute has been changed to `cloud.region`.Refer to [Issue #814](https://github.com/elastic/elastic-otel-node/pull/814) and [Issue #788](https://github.com/elastic/elastic-otel-node/pull/788).
</dropdown>


## 1.0.0

<dropdown title="Changed the default behavior of logging framework instrumentations">
  **Impact** Logging framework instrumentations for Bunyan, Pino, and Winston no longer do log sending by default. The new default behavior effectively sets the default config for these instrumentations to `{disableLogSending: true}`.**Action** To enable log-sending by default, set `ELASTIC_OTEL_ENABLE_LOG_SENDING=true`.Refer to [Issue #680](https://github.com/elastic/elastic-otel-node/issues/680).
</dropdown>

<dropdown title="Set default value of metrics temporality preference to delta">
  **Impact** The default value of `OTEL_EXPORTER_OTLP_METRICS_TEMPORALITY_PREFERENCE` is now set to `delta`.**Action** If you require the previous behavior, explicitly set the environment variable to your preferred value.Refer to [PR #670](https://github.com/elastic/elastic-otel-node/pull/670).
</dropdown>

<dropdown title="Removed support for passing in a function for a particular instrumentation">
  **Impact** Support for passing in a function for a particular instrumentation to the `getInstrumentations()` utility has been removed.**Action** None.
</dropdown>

<dropdown title="Removed the `@elastic/opentelemetry-node/sdk` entry-point">
  **Impact** The `@elastic/opentelemetry-node/sdk` entry-point has been removed for the 1.0.0 release.**Action** None.
</dropdown>

<dropdown title="Temporarily removed the 'gcp' resource detector">
  **Impact** The 'gcp' resource detector has been temporarily removed due to an issue that results in misleading tracing data.**Action** No action required. The detector will be re-added once the underlying issue is resolved.Refer to [PR #703](https://github.com/elastic/elastic-otel-node/pull/703).
</dropdown>


## 0.7.0

<dropdown title="Bumped min-supported node to `^18.19.0 || >=20.6.0`">
  **Impact** The minimum-supported Node.js version has been raised to match coming releases of OpenTelemetry JS. This drops support for Node.js 14 and 16.**Action** Upgrade to Node.js 18.19.0 or later, or Node.js 20.6.0 or later.Refer to [PR #584](https://github.com/elastic/elastic-otel-node/pull/584).
</dropdown>