﻿---
title: Elastic Distribution of OpenTelemetry Node.js release notes
description: Release notes for Elastic Distribution of OpenTelemetry Node.js.
url: https://www.elastic.co/docs/release-notes/edot/sdks/node
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Node
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Distribution of OpenTelemetry Node.js release notes
Review the changes, fixes, and more in each version of Elastic Distribution of OpenTelemetry Node.js (EDOT Node.js).
To check for breaking changes, see [EDOT Node.js Breaking Changes](https://www.elastic.co/docs/release-notes/edot/sdks/node/breaking-changes).
To check for security updates, go to [Security announcements for the Elastic stack](https://discuss.elastic.co/c/announcements/security-announcements/31).

## 1.8.0


### Fixes

- Fix the handling of the `deactivate_all_instrumentations` [central configuration](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/configuration#central-configuration) setting. If the value is `false`, it is now treated the same as if the setting had not been specified in central configuration. This means that `deactivate_all_instrumentations=false` and `deactivate_instrumentations=foo` will result in the "bar" instrumentation *not* being deactivated, which is the intended behavior. Before this change, `deactivate_all_instrumentations=false` would result in the `deactivate_instrumentations` setting being completely ignored. [#1236](https://github.com/elastic/elastic-otel-node/issues/1236)


### Chores

- Update all `@opentelemetry/*` upstream package dependencies to the latest releases:
  - [`v2.5.0` release](https://github.com/open-telemetry/opentelemetry-js/releases/tag/v2.5.0) from opentelemetry-js
- [`experimental/v0.211.0` release](https://github.com/open-telemetry/opentelemetry-js/releases/tag/experimental%2Fv0.211.0) from opentelemetry-js
- [opentelemetry-js-contrib releases](https://github.com/open-telemetry/opentelemetry-js-contrib/releases) up to 2026-01-22


## 1.7.0


### Features and enhancements

- Add support for TLS/mTLS configuration of the OpAMP client (used for [central configuration](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/configuration#central-configuration)). Three new environment variables can be used: `ELASTIC_OTEL_OPAMP_CERTIFICATE`, `ELASTIC_OTEL_OPAMP_CLIENT_CERTIFICATE`, and `ELASTIC_OTEL_OPAMP_CLIENT_KEY`. See [the Configure central configuration doc section](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/configuration#configure-central-configuration) for details. [#1044](https://github.com/elastic/elastic-otel-node/issues/1044)
- Improve the "preamble" log message at startup to include some details on envvars set that are relevant to the EDOT Node.js config. This uses an allowlist of non-sensitive envvars to avoid logging sensitive details. [#1018](https://github.com/elastic/elastic-otel-node/issues/1018)
- Add support for the `opamp_polling_interval` setting in Central Configuration. [#1128](https://github.com/elastic/elastic-otel-node/issues/1128)
  While this is supported in the EDOT Node.js SDK, it will only be present in
  the "Agent Configuration" UI of Kibana version 9.3 and later.


### Fixes

- Update `@opentelemetry/instrumentation-openai` dependency to version 0.7.0 to resolve a possible issue with TypeScript compilation. [opentelemetry-js-contrib#3240](https://github.com/open-telemetry/opentelemetry-js-contrib/issues/3240)


## 1.6.0


### Features and enhancements

- Add support for `ELASTIC_OTEL_OPAMP_HEADERS` environment variable for setting headers for OpAMP requests. This typically would be used to specify authorization for a given `ELASTIC_OTEL_OPAMP_ENDPOINT`, e.g.: `export ELASTIC_OTEL_OPAMP_HEADERS="Authorization=ApiKey sekrit"`. [#1069](https://github.com/elastic/elastic-otel-node/issues/1069)
- HTTP exporters now accept TLS configuration via the env vars `OTEL_EXPORTER_OTLP_CERTIFICATE`, `OTEL_EXPORTER_OTLP_CLIENT_KEY` and `OTEL_EXPORTER_OTLP_CLIENT_CERTIFICATE`. The signal specific vars (`OTEL_EXPORTER_OTLP_TRACES_CERTIFICATE`, ...) are also taken into account.
- Prepend EDOT Node.js product identifier in the `user-agent` for all HTTP and GRPC exporters. ([#1104](https://github.com/elastic/elastic-otel-node/pull/1104))
- Switch back to the upstream resource detector `@opentelemetry/resource-detector-gcp` which covers more environments thanks to Google's [contribution](https://github.com/open-telemetry/opentelemetry-js-contrib/pull/3007).
- Add support for dynamic configuration of the sampling rate of the default logger via the `sampling_rate` variable in Central Configuration. [#1070](https://github.com/elastic/elastic-otel-node/pull/1070)
  While this is supported in the EDOT Node.js SDK, it will only be present in
  the "Agent Configuration" UI of Kibana version 9.3 and later.


### Fixes

- Update to latest `@opentelemetry/*` dependencies ([#1104](https://github.com/elastic/elastic-otel-node/pull/1104)), which includes a couple of fixes:
  - a bug in `@opentelemetry/otlp-grpc-exporter-base@0.206.0` prevented to set the `user-agent` header in metadata. A [change in the exporter configuration](https://github.com/open-telemetry/opentelemetry-js/pull/5928) fixed it.
- the context manager and propagation setup is the first thing at the start of the SDK. This prevents detectors from [leaking telemetry](https://github.com/open-telemetry/opentelemetry-js-contrib/issues/2320) since they get the right context.


## 1.5.0


### Chores

- Update to the latest upstream OpenTelemetry JS dependencies. ([#1062](https://github.com/elastic/elastic-otel-node/pull/1062))
- Switch to trusted publishing ([https://docs.npmjs.com/trusted-publishers](https://docs.npmjs.com/trusted-publishers)) as a security precaution against supply-chain attacks.


## 1.4.0


### Features and enhancements

- The Elastic-authored `@elastic/opentelemetry-instrumentation-openai`
  instrumentation has been [upstreamed to OpenTelemetry](https://github.com/open-telemetry/opentelemetry-js-contrib/tree/main/packages/instrumentation-openai/).
  EDOT Node.js now uses the `@opentelemetry/instrumentation-openai` package
  to instrument `openai`. The newer package supports instrumenting openai@5 --
  the current major version.
  [#1015](https://github.com/elastic/elastic-otel-node/pull/1015)
  - If you were using `@elastic/opentelemetry-instrumentation-openai` with the
  `OTEL_NODE_ENABLED_INSTRUMENTATIONS` or `OTEL_NODE_ENABLED_INSTRUMENTATIONS`
  environment variables, you should switch to using `openai`. The old value
  will still work until the next major release.


### Fixes

- Update to latest `@opentelemetry/*` dependencies ([#1027](https://github.com/elastic/elastic-otel-node/pull/1027)), which includes a [fix](https://github.com/open-telemetry/opentelemetry-js/pull/5917) for a bug in `@opentelemetry/otlp-exporter-base@0.204.0` that could break bundling.


## 1.3.0


### Features and enhancements

- Added `@opentelemetry/instrumentation-oracledb` to the default set of instrumentations.
- New Central Configuration settings. Typically these settings are only useful
  for temporary debugging of telemetry.
  - `send_traces`: A boolean to disable/enable sending of trace telemetry (i.e. spans).
- `send_metrics`: The same, for the metrics signal.
- `send_logs`: The same, for the logs signal.
  While these are supported in EDOT Node.js, they will only be present in
  "Agent Configuration" UI of Kibana version 9.2 and later.
  [#928](https://github.com/elastic/elastic-otel-node/pull/928)
- New `ELASTIC_OTEL_CONTEXT_PROPAGATION_ONLY` configuration environment variable.
  Set this to `true` to disable sending of spans, but otherwise continue to
  do context propagation. This can be useful in limited conditions to support
  propagating trace-context through a service to downstream services for
  distributed tracing, but not collect spans from the service. (Note that this
  typically results in incomplete or broken traces in Kibana trace viewer.)
  [#928](https://github.com/elastic/elastic-otel-node/pull/928)


### Fixes


### Chores

- OTLP export requests (HTTP flavors only) will include an identifier for EDOT Node.js in the User-Agent header.
  [#982](https://github.com/elastic/elastic-otel-node/pull/982)


## 1.2.0


### Features and enhancements

- Initial support for Central Configuration: the ability to configure some aspects of EDOT Node.js in running instrumented applications from a central Kibana. This feature is in technical preview. [#834](https://github.com/elastic/elastic-otel-node/pull/834) [#886](https://github.com/elastic/elastic-otel-node/pull/886)
  This release includes support for the following settings: `logging_level`, `deactivate_all_instrumentations`, `deactivate_instrumentations`


### Chores

- Support for instrumenting `redis` version 4 has moved from `@opentelemetry/instrumentation-redis-4` to `@opentelemetry/instrumentation-redis`. If you are using the `OTEL_NODE_ENABLED_INSTRUMENTATIONS` or `OTEL_NODE_DISABLED_INSTRUMENTATIONS` environment variables to control instrumentation of `redis@4` you will need to change from using "redis-4" to "redis".


## 1.1.1


### Fixes

- Fix publishing so that the "hook.mjs" file is included.
  [#835](https://github.com/elastic/elastic-otel-node/pull/835)
  Without this fix, using `node --import @elastic/opentelemetry-node ...` will
  crash with:
  Cannot find module '.../node_modules/@elastic/opentelemetry-node/hook.mjs' imported from .../node_modules/@elastic/opentelemetry-node/import.mjs


## 1.1.0


### Features and enhancements

- Added the `ELASTIC_OTEL_HOST_METRICS_DISABLED` environment variable to control whether EDOT Node.js collects host metrics (`process.*`). This means users can turn off host metrics without affecting metrics from instrumentations. [#736](https://github.com/elastic/elastic-otel-node/pull/736)

The `ELASTIC_OTEL_METRICS_DISABLED` environment variable is now deprecated. Use `OTEL_METRICS_EXPORTER=none` to turn off any metrics exported by EDOT Node.js.
- Restored the `@elastic/opentelemetry-node/sdk` entry point. You can use `node --import ./telemetry.mjs app.js` rather than the typical zero-code
  `node --import @elastic/opentelemetry-node app.js` method for starting the SDK. [#718](https://github.com/elastic/elastic-otel-node/pull/718).

The `./telemetry.mjs` file uses APIs exported by `@elastic/opentelemetry-node/sdk`
to configure and start the OpenTelemetry Node.js SDK. See `examples/telemetry.mjs`.
<warning>
  Bootstrapping the Node SDK in code often requires using OpenTelemetry JS APIs that are not yet stable. These APIs might break in minor versions of `@elastic/opentelemetry-node`.
</warning>


## 1.0.0


### Features and enhancements

- Default to stable semantic conventions for HTTP instrumentation. [#669](https://github.com/elastic/elastic-otel-node/pull/669).
- Upgraded upstream OTel dependencies to SDK 2.0. This should be non-breaking
  for users of `node --import @elastic/opentelemetry-node my-app.js` to start
  EDOT Node.js for their application. [#663](https://github.com/elastic/elastic-otel-node/pull/663).
- Use `peerDependencies` for `@opentelemetry/api` dependency, and cap it to a  known-supported maximum version, according to [OTel JS guidance for implementors](https://github.com/open-telemetry/opentelemetry-js/issues/4832). [#606](https://github.com/elastic/elastic-otel-node/issues/606).


## 0.7.0


### Features and enhancements

- Improved ES module (ESM) instrumentation. [#584](https://github.com/elastic/elastic-otel-node/pull/584). As part of this change, using `--require @elastic/opentelemetry-node` will no longer set up a module hook for instrumenting ES modules; only using `--import @elastic/opentelemetry-node` will do so. Use `--import @elastic/opentelemetry-node` to start EDOT Node.js. Using `--require ...` is still valid when you know your application is only using CommonJS modules.
- Added `@opentelemetry/instrumentation-mysql` to the default set of instrumentations.
- Added `@opentelemetry/instrumentation-mysql2` to the default set of instrumentations.
- Added `@opentelemetry/instrumentation-cassandra-driver` to the default set of instrumentations.
- Test that the native instrumentation in `@elastic/elasticsearch@8.15.0` and later works.


## 0.6.0


### Features and enhancements

- Added `@elastic/opentelemetry-instrumentation-openai` to the default set of instrumentations.


## 0.5.0


### Features and enhancements

- Bumped `@opentelemetry/*` dependencies.


## 0.4.1


### Fixes

- Fixed release workflow. v0.4.0 was released without a GitHub releases
  entry.


## 0.4.0


### Features and enhancements

- A Docker image is now being published that can be used with the OpenTelemetry Operator's support for [auto-instrumentation injection](https://github.com/open-telemetry/opentelemetry-operator/#opentelemetry-auto-instrumentation-injection) ([#374](https://github.com/elastic/elastic-otel-node/pull/374)):
  - `docker.elastic.co/observability/elastic-otel-node:${version}` and `:latest`
  will be published for tagged releases
- `docker.elastic.co/observability/elastic-otel-node:edge` will be published
  for each push to "main".


## 0.3.0


### Features and enhancements

- Added the following instrumentations:
  ```
  @opentelemetry/instrumentation-connect
  @opentelemetry/instrumentation-cucumber
  @opentelemetry/instrumentation-dataloader
  @opentelemetry/instrumentation-dns
  @opentelemetry/instrumentation-generic-pool
  @opentelemetry/instrumentation-knex
  @opentelemetry/instrumentation-koa
  @opentelemetry/instrumentation-lru-memoizer
  @opentelemetry/instrumentation-memcached
  @opentelemetry/instrumentation-nestjs-core
  @opentelemetry/instrumentation-net
  @opentelemetry/instrumentation-redis
  @opentelemetry/instrumentation-restify
  @opentelemetry/instrumentation-router
  @opentelemetry/instrumentation-socket.io
  ```
- Bumped minimum supported Node.js version to v14.18.0.


## 0.2.0


### Features and enhancements

- Added the following `@opentelemetry/instrumentation-*` instrumentations: `hapi`, `aws-sdk`, `redis-4`, `grpc`, `pino`.
- Added cloud and container resource detectors, the same set included in `@opentelemetry/auto-instrumentations-node`. These are enabled by default. Use `OTEL_NODE_RESOURCE_DETECTORS` to set an explicit list of detectors.
- Added missing exporters for logs and metrics signals. This means that `OTEL_EXPORTER_OTLP_PROTOCOL=grpc` and `OTEL_EXPORTER_OTLP_PROTOCOL=http/json` now work. Before this change only the default `http/proto` OTLP export protocol would work by default.


## 0.1.3


### Fixes

- Correct another issue with "repository.url" setting in package.json, required for npm provenance generation.


## 0.1.2


### Fixes

Correct "repository.url" setting in package.json, required for npm provenance generation.

## 0.1.1


### Fixes

- Trimmed files included in published npm package.


## 0.1.0

First release of the Elastic Distribution of OpenTelemetry Node.js.