﻿---
title: Elastic Distribution of OpenTelemetry iOS release notes
description: Release notes for the Elastic Distribution of OpenTelemetry iOS (previously Elastic APM Agent for iOS).
url: https://www.elastic.co/docs/release-notes/edot/sdks/ios
products:
  - APM Agent
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Distribution of OpenTelemetry iOS
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Distribution of OpenTelemetry iOS release notes
Review the changes, fixes, and more in each version of Elastic Distribution of OpenTelemetry iOS.
To check for security updates, go to [Security announcements for the Elastic stack](https://discuss.elastic.co/c/announcements/security-announcements/31).

## 1.4.0


### Features and enhancements

- OpAMP support [#290](https://github.com/elastic/apm-agent-ios/pull/290)


### Fixes

- Respect custom exportUrl path [#310](https://github.com/elastic/apm-agent-ios/pull/310)


## 1.3.0


### Features and enhancements

- Updated OpenTelemetry-Swift to version 1.17.0
- Allow signal filters to be mutable [#266](https://github.com/elastic/apm-agent-ios/pull/266)
- Added mutableLogRecord so attributes can be appended during filtering [#271](https://github.com/elastic/apm-agent-ios/pull/271)
- Adds support for custom collector paths [#267](https://github.com/elastic/apm-agent-ios/pull/276)
- Signal interceptors [#283](https://github.com/elastic/apm-agent-ios/pull/283)


## 1.2.0


### Features and enhancements

- Bumped Reachability to version 5.2.4 [#245](https://github.com/elastic/apm-agent-ios/pull/245)
- Updated OpenTelemetry-Swift to version 1.12.1


## 1.1.0


### Features and enhancements

- Updated OpenTelemetry-Swift to version 1.11.0


## 1.0.5


### Fixes

- Fixes HTTP connection type [#239](https://github.com/elastic/apm-agent-ios/pull/239)


## 1.0.4


### Fixes

- Updated privacy manifest [#233](https://github.com/elastic/apm-agent-ios/pull/233)


## 1.0.3


### Features and enhancements

- Added options to use HTTP instead of GRPC for Exporters [#228](https://github.com/elastic/apm-agent-ios/pull/228)


### Fixes

- Fixed ntp clock logging to only occur once. [#229](https://github.com/elastic/apm-agent-ios/pull/229)


## 1.0.2


### Features and enhancements

- Added Privacy Manifest file [#217](https://github.com/elastic/apm-agent-ios/pull/217).


## 1.0.1


### Fixes

- Fixed memory leaks related to NTP usage [#212](https://github.com/elastic/apm-agent-ios/pull/212).


## 1.0.0


### Features and enhancements

- Added network status to all signals [#202](https://github.com/elastic/apm-agent-ios/pull/202).
- Added session.id to crash reports [#197](https://github.com/elastic/apm-agent-ios/pull/197).