﻿---
title: Elastic Distribution of OpenTelemetry .NET release notes
description: Release notes for Elastic Distribution of OpenTelemetry .NET.
url: https://www.elastic.co/docs/release-notes/edot/sdks/dotnet
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry .NET
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Distribution of OpenTelemetry .NET release notes
Review the changes, fixes, and more in each version of Elastic Distribution of OpenTelemetry .NET.
To check for security updates, go to [Security announcements for the Elastic stack](https://discuss.elastic.co/c/announcements/security-announcements/31).

## 1.3.0

<note>
  This release includes preparatory work for OpAMP configuration and central configuration. These options do not currently have any impact and should not be used.
</note>


### Features and enhancements

- Add initial config options to configure OpAmp client. [#372](https://github.com/elastic/elastic-otel-dotnet/pull/372)
- Redact and log the OpAmp header option. [#374](https://github.com/elastic/elastic-otel-dotnet/pull/374)
- Update k8s operator to use wolfi-base. [#383](https://github.com/elastic/elastic-otel-dotnet/pull/383)
- Update to latest upstream packages. [#385](https://github.com/elastic/elastic-otel-dotnet/pull/385)


## 1.2.2


### Fixes

- Fix file logging when configured in `appSettings`. [#370](https://github.com/elastic/elastic-otel-dotnet/pull/370)


## 1.2.1


### Fixes

- Ensure environment variable resource attributes apply after EDOT defaults. [#368](https://github.com/elastic/elastic-otel-dotnet/pull/368)


## 1.2.0


### Features and enhancements

- Upgrade to .NET 10 SDK [#339](https://github.com/elastic/elastic-otel-dotnet/pull/339)
- Update upstream OTel package dependencies. 1.14.0 for SDK and contrib, 1.13.0 for instrumentation. [#343](https://github.com/elastic/elastic-otel-dotnet/pull/343)
- Enhance diagnostic logging capabilities. [#348](https://github.com/elastic/elastic-otel-dotnet/pull/348)


### Fixes

- Fix version numbers in packaging of PowerShell module. [#297](https://github.com/elastic/elastic-otel-dotnet/pull/297)
- Ensure correct execution order for user-provided delegates. [#325](https://github.com/elastic/elastic-otel-dotnet/pull/325)


## 1.1.0


### Features and enhancements

- Update to 1.12.x upstream packages. [#287](https://github.com/elastic/elastic-otel-dotnet/pull/287)
- Treat `EventLevel.Verbose` as debug log level when subscribing to SDK events for diagnostics. [#288](https://github.com/elastic/elastic-otel-dotnet/pull/288)


## 1.0.2


### Features and enhancements

- Log after adding AspNetCore trace instrumentation. Improves the trace logging for diagnostic and support purposes. [#262](https://github.com/elastic/elastic-otel-dotnet/pull/262)


### Fixes

- No longer default to IncludeScopes. The upstream SDK isn't spec-compliant regarding not exporting duplicate attributes. As such, when using IncludeScopes in ASP.NET Core, log entries often include a duplicated RequestId attribute. The Elasticsearch` exporter component of the collector expects the data to comply with the spec and, for performance reasons, doesn't attempt to de-duplicate, resulting in export errors for the log record. EDOT .NET no longer enables IncludeScopes by default as a partial workaround. This will be re-enabled in a future release, once the risk of data loss is resolved upstream. [#265](https://github.com/elastic/elastic-otel-dotnet/pull/265)


## 1.0.1


### Features and enhancements

- Removed invalid prefix from minver command. [#261](https://github.com/elastic/elastic-otel-dotnet/pull/261)


## 1.0.0


### Features and enhancements

- Update docs for GA. [#256](https://github.com/elastic/elastic-otel-dotnet/pull/256)
- Simplify reflection to work on classic ASP.NET and singlefile publish. [#257](https://github.com/elastic/elastic-otel-dotnet/pull/257)
- Ignore warning for unstable dependencies. [#258](https://github.com/elastic/elastic-otel-dotnet/pull/258)
- Disable generateapichanges for release. [#259](https://github.com/elastic/elastic-otel-dotnet/pull/259)