﻿---
title: Elastic Distribution of OpenTelemetry Android release notes
description: Release notes for the Elastic Distribution of OpenTelemetry Android.
url: https://www.elastic.co/docs/release-notes/edot/sdks/android
products:
  - APM Agent
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Android
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Elastic Distribution of OpenTelemetry Android release notes
Review the changes, fixes, and more in each version of Elastic Distribution of OpenTelemetry Android.
To check for security updates, go to [Security announcements for the Elastic stack](https://discuss.elastic.co/c/announcements/security-announcements/31).

## 1.5.0

**Release date:** January 22, 2026

### Fixes

- Bumping upstream OTel dependencies


## 1.4.0

**Release date:** November 13, 2025

### Features and enhancements

- Bumping upstream OTel to 1.56.0: [#683](https://github.com/elastic/apm-agent-android/pull/683)


## 1.3.1

**Release date:** October 10, 2025

### Features and enhancements

- Avoid central config spans: [#598](https://github.com/elastic/apm-agent-android/pull/598)
- Adding support to close instrumentations when the agent is closed: [#601](https://github.com/elastic/apm-agent-android/pull/601)
- Otel core update
- Using upstream opamp for central config: [#622](https://github.com/elastic/apm-agent-android/pull/622)
- Removing READ_PHONE_STATE permission from manifest: [#651](https://github.com/elastic/apm-agent-android/pull/651)


## 1.2.0

**Release date:** July 29, 2025

### Features and enhancements

- [Tech-preview] Central configuration via OpAMP: [#565](https://github.com/elastic/apm-agent-android/pull/565)
- Setting min Kotlin compatibility to 1.9: [#579](https://github.com/elastic/apm-agent-android/pull/579)


## 1.1.0

**Release date:** June 16, 2025

### Features and enhancements

- Android instrumentation adapter: [#487](https://github.com/elastic/apm-agent-android/pull/487)
- Adding session sample rate setter: [#507](https://github.com/elastic/apm-agent-android/pull/507)
- Adding disk buffering config setter: [#509](https://github.com/elastic/apm-agent-android/pull/509)


## 1.0.0

**Release date:** April 2, 2025

### Features and enhancements

- [Breaking] New SDK API.
- [Breaking] New artifact coordinates for libs and plugins.
- [Breaking] Kibana Android dashboard has changed.
- Improved stability.
- Support for exporting to the EDOT Collector.,


## 0.20.0

**Release date:** July 29, 2024

### Features and enhancements

- Bumping upstream libs: [#340](https://github.com/elastic/apm-agent-android/pull/340)


### Fixes

- Addressing TrueTime issue #339: [#340](https://github.com/elastic/apm-agent-android/pull/340)


## 0.19.0

**Release date:** May 30, 2024

### Fixes

- Bytecode instrumentation issue in #323: [#324](https://github.com/elastic/apm-agent-android/pull/324)


## 0.18.0

**Release date:** May 24, 2024

### Fixes

- HTTP exporting fix: [#319](https://github.com/elastic/apm-agent-android/pull/319)


## 0.17.0

**Release date:** May 17, 2024

### Features and enhancements

- Adding consumer R8 rules to address R8 full mode: [#309](https://github.com/elastic/apm-agent-android/pull/309)


## 0.16.0

**Release date:** April 3, 2024

### Fixes

- Removing strict version constraint that prevented enforcing compileSdk > 33: [#292](https://github.com/elastic/apm-agent-android/pull/292)


## 0.15.0

**Release date:** March 11, 2024

### Features and enhancements

- Added configuration to set a base OpenTelemetry Resource object: [#276](https://github.com/elastic/apm-agent-android/pull/276)


## 0.14.0

**Release date:** February 2, 2024

### Features and enhancements

- Making OpenTelemetry Android the base project: [#268](https://github.com/elastic/apm-agent-android/pull/268)


## 0.13.1

**Release date:** January 18, 2024

### Fixes

- Fix for #254: [#261](https://github.com/elastic/apm-agent-android/pull/261)


## 0.13.0

**Release date:** December 12, 2023

### Features and enhancements

- Making internal logs configurable: [#245](https://github.com/elastic/apm-agent-android/pull/245)


### Fixes

- Fix #242: [#244](https://github.com/elastic/apm-agent-android/pull/244)


## 0.12.0

**Release date:** November 21, 2023

### Features and enhancements

- Adding exception event to failed http responses: [#237](https://github.com/elastic/apm-agent-android/pull/237)
- Upgrading Byte Buddy to 1.14.10: [#238](https://github.com/elastic/apm-agent-android/pull/238)


## 0.11.0

**Release date:** October 31, 2023

### Fixes

- Fix truetime duplicated classes: [#222](https://github.com/elastic/apm-agent-android/pull/222)


## 0.10.0

**Release date:** October 27, 2023

### Features and enhancements

- Adding setExportProtocol configuration to choose between HTTP and gRPC, defaulting to gRPC: [#213](https://github.com/elastic/apm-agent-android/pull/213)
- Upgrading Byte Buddy version to 1.14.9: [#207](https://github.com/elastic/apm-agent-android/pull/207)
- Setting minimum AGP version to 7.4.0 to use the Gradle plugin: [#207](https://github.com/elastic/apm-agent-android/pull/207)
- Removing Gradle’s warning on missing serverUrl param: [#209](https://github.com/elastic/apm-agent-android/pull/209)
- Adding http response content length attr to okhttp spans: [#211](https://github.com/elastic/apm-agent-android/pull/211)
- Marking okhttp spans as failed when receiving an error response code: [#212](https://github.com/elastic/apm-agent-android/pull/212)
- Bumping OTel SDK to 1.31.0 and adding new semconv dependency: [#217](https://github.com/elastic/apm-agent-android/pull/217)


## 0.9.0

**Release date:** October 16, 2023

### Features and enhancements

- Making Session ID generator configurable: [#178](https://github.com/elastic/apm-agent-android/pull/178)
- Adding sample rate support: [#179](https://github.com/elastic/apm-agent-android/pull/179)
- Adding support for AGP > 8: [#197](https://github.com/elastic/apm-agent-android/pull/197)
- Setting minimum AGP version to 7.4.0: [#197](https://github.com/elastic/apm-agent-android/pull/197)


## 0.8.0

**Release date:** August 23, 2023

### Features and enhancements

- Updating OpenTelemetry SDK to 1.27.0 where logs are stable: [#168](https://github.com/elastic/apm-agent-android/pull/168)
- Updating OpenTelemetry SDK to 1.28.0 where the new disk buffering lib is present: [#170](https://github.com/elastic/apm-agent-android/pull/170)
- Adding network connectivity attributes to logs: [#173](https://github.com/elastic/apm-agent-android/pull/173)
- Adding local persistence/caching support: [#174](https://github.com/elastic/apm-agent-android/pull/174)


## 0.7.0

**Release date:** June 2, 2023

### Features and enhancements

- Sending app’s versionCode in the `service.build` attribute: [#153](https://github.com/elastic/apm-agent-android/pull/153)
- Sending app’s lifecycle events: [#159](https://github.com/elastic/apm-agent-android/pull/159)
- Adding spans, logs and metrics filtering support: [#160](https://github.com/elastic/apm-agent-android/pull/160)


### Fixes

- Fix #164: [#165](https://github.com/elastic/apm-agent-android/pull/165)


## 0.6.0

**Release date:** April 5, 2023

### Features and enhancements

- Using minSdk 24: [#149](https://github.com/elastic/apm-agent-android/pull/149)
- Making OpenTelemetry processors and exporters configurable: [#151](https://github.com/elastic/apm-agent-android/pull/151)
- Making environment name configurable at runtime: [#152](https://github.com/elastic/apm-agent-android/pull/152)


## 0.5.0

**Release date:** April 3, 2023

### Features and enhancements

- Added server ApiKey auth support: [#141](https://github.com/elastic/apm-agent-android/pull/141)


## 0.4.0

**Release date:** March 30, 2023

### Features and enhancements

- Wrapping HTTP spans: [#106](https://github.com/elastic/apm-agent-android/pull/106)
- Tracking app launch time metrics: [#110](https://github.com/elastic/apm-agent-android/pull/110)
- Added runtime configuration options: [#122](https://github.com/elastic/apm-agent-android/pull/122)
- Added central configuration [recording](https://github.com/elastic/apm/blob/main/specs/agents/mobile/configuration.md#recording-configuration) option: [#136](https://github.com/elastic/apm-agent-android/pull/136)


## 0.1.0

**Release date:** December 12, 2022

### Features and enhancements

- OpenTelemetry agent set up.
- Automatic instrumentation of Android Activities and Fragments.
- Automatic instrumentation of OkHttp client calls.
- Filtering of http-related Spans