﻿---
title: Elastic Cloud Serverless deprecations
description: Review the deprecated functionality for Elastic Cloud Serverless. While deprecations have no immediate impact, we strongly encourage you update your implementation...
url: https://www.elastic.co/docs/release-notes/cloud-serverless/deprecations
---

# Elastic Cloud Serverless deprecations
Review the deprecated functionality for Elastic Cloud Serverless. While deprecations have no immediate impact, we strongly encourage you update your implementation.

## February 2, 2026

- Removes the URL limit from Kibana and deprecates the `storeInSessionStorage` setting. For more information, refer to [#242972](https://github.com/elastic/kibana/pull/242972).
- Removes the `--stats` flag on `build_api_docs`. For more information, refer to [#249305](https://github.com/elastic/kibana/pull/249305).


## January 5, 2026

- Removes the Kibana user from the root group. For more information, refer to [#244798](https://github.com/elastic/kibana/pull/244798).


## November 24, 2025

- Shows a callout for deprecated, in-use ILM policies. For more information, check [#243416](https://github.com/elastic/kibana/pull/243416).


## October 13, 2025

- Filters endpoint exceptions from the detection engine's execution logic. For more information, check [#233289](https://github.com/elastic/kibana/pull/233289).


## August 25, 2025

- Changes the `reporting_user` role to leverage reserved Kibana privileges. For more information, check [#132766](https://github.com/elastic/elasticsearch/pull/132766)


## June 30, 2025

- Removes Default Quick Prompts from the Security AI Assistant. For more information, check [#225536](https://github.com/elastic/kibana/pull/225536).


## June 2, 2025

- Removes the `allowByValueEmbeddables` setting from the Dashboard plugin. For more information, check [#221165](https://github.com/elastic/kibana/pull/221165).


## February 24, 2025

- Deprecates the Behavioral Analytics CRUD APIs [#122960](https://github.com/elastic/elasticsearch/pull/122960)


## February 3, 2025

- Renames the `integration-assistant` plugin to `automatic-import`. For more information, check [#207325](https://github.com/elastic/kibana/pull/207325).


## January 27, 2025

- Deprecates a subset of Elastic Security Serverless endpoint management APIs. For more information, check [#206903](https://github.com/elastic/kibana/pull/206903).


## January 13, 2025

- Removes all legacy risk engine code and features. For more information, check [#201810](https://github.com/elastic/kibana/pull/201810).


## January 6, 2025

- Disables the Elastic Observability Serverless log stream and settings pages. For more information, check [#203996](https://github.com/elastic/kibana/pull/203996).
- Removes Logs Explorer in Elastic Observability Serverless. For more information, check [#203685](https://github.com/elastic/kibana/pull/203685).


## December 16, 2024

- Deprecates the `discover:searchFieldsFromSource` setting. For more information, check [#202679](https://github.com/elastic/kibana/pull/202679).
- Disables scripted field creation in the Data Views management page. For more information, check [#202250](https://github.com/elastic/kibana/pull/202250).
- Removes all logic based on the following settings: `xpack.reporting.roles.enabled`, `xpack.reporting.roles.allow`. For more information, check  [#200834](https://github.com/elastic/kibana/pull/200834).
- Removes the legacy table from Discover. For more information, check [#201254](https://github.com/elastic/kibana/pull/201254).
- Deprecates ephemeral tasks from action and alerting plugins. For more information, check [#197421](https://github.com/elastic/kibana/pull/197421).