﻿---
title: Elastic Cloud Serverless breaking changes
description: 
url: https://www.elastic.co/docs/release-notes/cloud-serverless/breaking-changes
products:
  - Elastic Cloud Serverless
---

# Elastic Cloud Serverless breaking changes
## October 27, 2025

<dropdown title="Implement native synthetic source for normalized keywords">
  This adds a new mapping parameter `normalizer_skip_store_original_value` to keyword fields. When this parameter is set and `synthetic_source` is enabled, keyword fields with configured normalizers will not store the original non-normalized value in `_ignored_source` and will instead use the normalized value to reconstruct the source.
  This parameter enabled by default for the built-in `lowercase` normalizer and is disabled by default for other custom normalizers.**Impact:**Keyword fields using the `lowercase` normalizer will return the normalized value in the source when synthetic source is enabled.For more information, view [#136915](https://github.com/elastic/elasticsearch/pull/136915).
</dropdown>


## August 25, 2025

<dropdown title="Allows partial results by default in ES|QL">
  In earlier versions of Elasticsearch, ES|QL would fail the entire query if it encountered any error.
  ES|QL now returns partial results instead of failing when encountering errors.**Impact:**Callers should check the `is_partial` flag returned in the response to determine if the result is partial or complete.
  If returning partial results is not desired, this option can be overridden per request via an `allow_partial_results` parameter in the query URL or globally via the cluster setting `esql.query.allow_partial_results`.For more information, view [#125060](https://github.com/elastic/elasticsearch/pull/125060).
</dropdown>

<dropdown title="Enable exclude_source_vectors by default for new indices">
  The `exclude_source_vectors` setting is now enabled by default for newly created indices.
  This means that vector fields (for example, `dense_vector`) are no longer stored in the `_source` field by default, although they remain fully accessible through search and retrieval operations.
  Instead of being persisted in `_source`, vectors are now rehydrated on demand from the underlying
  index structures when needed.
  This reduces index size and improves performance for typical vector search workloads where the original vector values do not need to be part of the `_source`.
  If your use case requires vector fields to be stored in `_source`, you can disable this behavior by
  setting `exclude_source_vectors: false` at index creation time.**Impact:**Vector fields will no longer be stored in `_source` by default for new indices.
  Applications or tools that expect to see vector fields in `_source` (for raw document inspection)
  may need to be updated or configured to explicitly retain vectors using `exclude_source_vectors: false`.
  Retrieval of vector fields via search or the `_source` API remains fully supported.For more information, view [#131907](https://github.com/elastic/elasticsearch/pull/131907).
</dropdown>

<dropdown title="Don't enable norms for fields of type text when the index mode is LogsDB or TSDB">
  This changes the default behavior for norms on `text` fields in LogsDB and TSDB indices.
  Prior to this change, norms were enabled by default, with the option to disable them via manual configurations.
  After this change, norms will be disabled by default.
  Note, because we dont support enabling norms from a disabled state, users will not be able to enable norms on `text` fields in logsdb and tsdb indices.**Impact:**Text fields will no longer be normalized by default in LogsDB and TSDB indicies.For more information, view [#131317](https://github.com/elastic/elasticsearch/pull/131317).
</dropdown>


## August 11, 2025

<dropdown title="Improves advanced settings management APIs privilege checks">
  Roles with explicit read access to advanced settings but all access to `SavedObjectManagement` can no longer update settings via the internal advanced settings API.
  This update enforces explicit privileges instead of relying on saved object security checks.For more information, view [#230067](https://github.com/elastic/kibana/pull/230067).
</dropdown>


## June 23, 2025

<dropdown title="Disallows mixed quoted/unquoted patterns in FROM">
  Previously, the ES|QL grammar allowed users to individually quote constituent strings in index patterns such as `"remote_cluster":"index_name"`. This would allow users to write complex malformed index patterns that often slip through grammar and the subsequent validation.
  This could result in runtime errors that can be misleading.
  This change simplifies the grammar to early reject such malformed index patterns at the parsing stage, allowing users to write simpler queries and see more relevant and meaningful errors.**Impact:**Users can write queries with simpler index patterns and see more meaningful and relevant errors.
  For more information, view [#127636](https://github.com/elastic/elasticsearch/pull/127636).
</dropdown>