﻿---
title: Elastic Cloud Enterprise known issues
description: The following limitations and known problems apply to the latest release of ECE, or to earlier releases as noted. For troubleshooting help, you can also...
url: https://www.elastic.co/docs/release-notes/cloud-enterprise/known-issues
products:
  - Elastic Cloud Enterprise
---

# Elastic Cloud Enterprise known issues
The following limitations and known problems apply to the latest release of ECE, or to earlier releases as noted.
For troubleshooting help, you can also refer to the list of [Common issues](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/common-issues).

## Installation and configuration

- When you install Elastic Cloud Enterprise on a new host and assign it the allocator role from the command line with the `--roles "allocator"` parameter during installation, new deployments might not get created on the allocator. To resolve this issue, check [Allocators Are Not Being Used](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/common-issues#ece-issues-allocator-usage).
- Some change management tools that auto-reload firewall rules can cause networking issues. Specifically, Docker networking can fail on new containers after restarting the `iptables` service. To avoid networking failures, disable the automatic reloading of firewall rules.
- When you use OverlayFS with Kernel-LT 4.4.156 and later, there is a known regression that prevents Elastic Cloud Enterprise from completing the installation. This regression is fixed with Kernel-LT 4.9.
- If you install ECE on AWS, you likely need to [modify the cluster endpoint](https://www.elastic.co/docs/troubleshoot/deployments/cloud-enterprise/common-issues#ece-aws-private-ip), as the public hostname resolves to a different IP address externally than it does internally on the cluster.
- ECE is unable to support VMotion functionality in VMWare. To use ECE, you must disable VMotion.
- When you use virtualization resources, make sure that you avoid resource overallocation.


## Operating system and container engine

- Podman versions `5.2.2-11` and `5.2.2-13` are affected by a known [memory leak issue](https://github.com/containers/podman/issues/25473). To avoid this bug, use a later version. Refer to the official [Support matrix](https://www.elastic.co/support/matrix#elastic-cloud-enterprise) for more information.


## Security

- Changing the generated password for the `admin` user on the administration console deployment that backs the Cloud UI is not supported. This is the `admin` user on the `admin-console-elasticsearch` deployment that gets created during the ECE installation.
  <warning>
  Do not change the generated password for the `admin` user on the administration console deployment or you risk losing administrative access to your installation.
  </warning>
- When configuring Elastic Cloud Enterprise role-based access control:
  - Trying to use an invalid SAML provider can cause the security deployment to bootloop. The deployment falls back to the previous configuration, but if there are any issues between the UI and the actual configuration, remove or update the SAML provider profile. If the problem persists, review the deployment activity and logs.
- Regarding the `principal` user property, although the SAML specification does not have many restrictions on the type of value that is mapped, ECE requires that the mapped value is also a valid Elasticsearch native realm identifier. Specifically, this means the mapped identifier should not contain any commas or slashes, and should be otherwise URL friendly.
- PEM and PKCS11 formatted certificates are not supported.
- In versions from 2.6 to 2.10 included, some or all platform certificates are generated with a 398-day expiration. Installations that ran on these versions, even temporarily, must have their certificates rotated manually before expiry. For details, check [our KB article](https://ela.st/ece-certificate-rotation).
- The administration console may become unavailable when the route server certificate expires. Until the rotation of this certificate gets automated, you need to perform the rotation manually if you encounter this issue. For details, check [our KB article](https://ela.st/ece-route-server-cert-rotation).

Some additional limitations apply when securing your installation. To learn more, check [Secure Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/security).

## Deployments

- Pending plan changes for your deployment in the Cloud UI that exceed the available capacity will fail as expected, but might then require you to manually recover from the failure. (To recover, locate the details for the plan attempt and copy the diff; manually edit the diff to revert to the original plan and apply the modified plan into the **Advanced cluster configuration** panel.)
- ECE has a maximum limit of 320 seconds, so we recommend optimizing long-running queries in Elasticsearch.
- ECE hosts may unexpectedly re-ingest old log files into the Logging and Metrics (L&M) cluster. Upgrading to ECE 3.8+ significantly reduces the operational impact of this issue. Review [our KB article](https://support.elastic.co/knowledge/8debdfb7) for guidance and mitigation steps.


## Deployment templates

- In ECE 2.13, a known issue can prevent custom deployment templates from being created through the UI, when selecting instance configurations different from the default ones. This results in an error related to autoscaling displayed in the UI when you try to create the template. If you are affected by this issue, you can [contact Elastic Support](https://www.elastic.co/docs/troubleshoot#contact-us).


## Upgrading


### ECE version 4.x

- In versions 3.8.0, 3.8.1, 4.0.0, and 4.0.1, the `logging-and-metrics` system deployment upgrade (7.x to 8.x) and move to datastreams introduced a bug that generates new datastreams daily. This bug is fixed in versions 3.8.2 and 4.0.2. Review [our KB article](https://support.elastic.co/knowledge/022d8cd6) for more guidance.
- The fix for the above issue (in 3.8.2 and 4.0.2) added a rollover action to the default `ece_logs` and `ece_metrics` ILM policies. When upgrading to 3.8.2, 3.8.3, 4.0.2, or version onwards, this new policy can cause pre-existing indices to accumulate. Review [our KB article](https://support.elastic.co/knowledge/8b45ecdd) for more guidance.
- Terminated clusters or components may block ECE from upgrading to 4.0.0 and show `Cluster: [cluster id] of kind [enterprise_search / apm / kibana] is running on less than [8.0.0] {}` error message. Manually deleting the unnecessary deployment, or adding the terminated component back and upgrade it to 8.x version could mitigate the issue. Review [our KB article](https://support.elastic.co/knowledge/d37b1708) for more guidance.
- During an ECE upgrade, the process may fail if one component container on any ECE host does not stop within the default timeout period (5 seconds). When this occurs, rollback will be triggered. To mitigate the issue, reaching out to [Elastic Support](https://www.elastic.co/docs/troubleshoot#contact-us). This issue also affects ECE version 3.x. Review [our KB article](https://support.elastic.co/knowledge/b8e7e95e) for more guidance.
- The ECE upgrade logic creates copies of existing containers during the upgrade process, in the way of naming these containers suffixed with `_bak`. The upgrade process is supposed to remove those later, however, due to a hard-coded timeouts this might not happen, leaving `_bak` containers running on ECE hosts. This issue also affects ECE version 3.x. Review [our KB article](https://support.elastic.co/knowledge/c426653a) for more information and guidance.
- Upgrading system deployments in ECE might fail with `"caused_by": "no.found.constructor.validation.ValidationException: 1. allocator [x.x.x.x] from [move_allocators] section is unknown"` error message. Manually cleaning up the `move_allocators` setting from deployment - Advanced Edit UI could mitigate the issue. This issue also affects ECE version 3.x. Review [our KB article](https://support.elastic.co/knowledge/d6f891da) for more guidance.


### ECE version 3.x

- When upgrading to 3.8.0 or 3.8.1, system deployments are updated to the version specified in the [default system deployment versions](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/default-system-deployment-versions). If system deployments, such as logging-and-metrics, have been migrated to data tiers (e.g. hot/warm), the automatic upgrade of a 7.x cluster initiated by the ECE upgrader will fail. Additionally, since ECE 3.8 upgrades the logging-and-metrics deployment at the start of the process (prior to upgrading the ECE containers), it halts the ECE upgrade early and leaves the cluster in a partially upgraded state. Review [our KB article](https://support.elastic.co/knowledge/8b638049) for more details.
- On AWS installations, upgrading to version 3.8.0 or later can cause Metricbeat ingestion to fail in the `logging-and-metrics` system deployment if instance tag access is enabled **and** EC2 tag keys contain dots (for example, `key=csg.support`). This results in missing Admin Console data.  Workarounds include disabling tag access in the EC2 instances or overriding Metricbeat templates.  See related metrcibeat issue [46898](https://github.com/elastic/beats/issues/46898). Review [our KB article](https://support.elastic.co/knowledge/dbacbdff) and/or contact Elastic Support for guidance before upgrading.
- When upgrading to ECE 3.8, the automatic upgrade of the `admin-console-elasticsearch` system deployment may encounter failures due to issues such as mapping conflicts, or incompatible or outdated indices. Rebuilding the admin cluster indices from Zookeeper could mitigate the issue. Review [our KB article](https://support.elastic.co/knowledge/87ff2ae6) for more guidance.
- When upgrading to ECE 3.6, 3.7, or 3.8 from ECE 3.5 or earlier, a rollback triggered by an unsuccessful upgrade might cause all deployments to appear as "Unhealthy" in the admin console. Manually editing or removing the problematic field could mitigate the issue. Review [our KB article](https://support.elastic.co/knowledge/25faaefa) for more information and guidance.
- When upgrading ECE from a prior version to 3.6 and onwards, the `security` system deployment upgrade may fail with `The node_type field in the Elasticsearch topology is not supported in this version of elasticsearch` error. Manually converting the cluster topology from `node_type` to `node_roles` is required. Review [our KB article](https://support.elastic.co/knowledge/35523aa0) for more guidance.


### ECE version 2.x

- When upgrading from version 2.9.x (2.9.0, 2.9.1, 2.9.2) to a version between 2.10.0 and 2.11.0, you might get an error that indicates deployment aliases cannot be set [in the console](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/enable-custom-endpoint-aliases). As a workaround, you can fix it using the [dedicated API](https://www.elastic.co/docs/api/doc/cloud-enterprise/operation/operation-create-config-store-option) by setting the value of `config_option_id` to `enable-deployment-alias` and the value of request body to `{ "value": "false" }`.
- When upgrading to ECE version 2.7.0 the automatic upgrade of the `admin-console-elasticsearch` system deployment may fail, particularly on older installations of ECE that started with a 5.x cluster. If this happens, it is safe to leave the cluster at the latest 6.x Elasticsearch version until the automatic upgrade is fixed in the next version of ECE. Note that the `logging-and-metrics` system deployment should also remain on 6.x, only the `security` system deployment should be upgraded to the latest 7.x Elasticsearch version using the [dedicated API](https://www.elastic.co/docs/api/doc/cloud-enterprise/operation/operation-update-security-deployment).
- Starting with ECE version 2.6.0, deployment upgrades initiated from the UI can fail if there is no healthy instance of Kibana available. As a workaround, you can perform an advanced edit on the cluster to upgrade the cluster version. In the cluster configuration, each occurrence of `elasticsearch.version` can be updated to the version that you choose. For details, check [Advanced cluster configuration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/advanced-cluster-configuration).
- When upgrading to 2.4.0 or later, make sure that nothing listens on your proxy node over port 9000. If a Minio repository runs on the same ECE node, you’ll need to change the default listening port. If there is a port conflict, proxy fails and won’t boot.


## Elastic Stack on ECE


### Elastic Agent

- Due to a known Elastic Agent bug, Elastic Agent or Integrations Server components running on version 8.11.0 will not boot up within an Elastic Cloud Enterprise deployment. The issue affects Elastic Cloud Enterprise installations that are deployed with a Linux UID other than `1000`. We recommend upgrading your deployments and components to version 8.11.1 or above to fix this issue.


### Integrations Server

A bug in Elastic Stack versions 8.1 and later may lead to a full disk for Elastic APM users with tail-based sampling enabled. A fix has been merged and will be released in a future version.