﻿---
title: Elastic Cloud Enterprise breaking changes
description: Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade Elastic Cloud Enterprise, carefully...
url: https://www.elastic.co/docs/release-notes/cloud-enterprise/breaking-changes
products:
  - Elastic Cloud Enterprise
---

# Elastic Cloud Enterprise breaking changes
Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade Elastic Cloud Enterprise, carefully review the breaking changes and take the necessary steps to mitigate any issues. To learn how to upgrade, check [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-enterprise).
In addition, before [upgrading your deployments](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ece), review the [breaking changes](https://www.elastic.co/docs/release-notes) for any Elastic Stack applications that you're using.

## 4.0.0

<dropdown title="Removed support for 7.x stack versions">
  Elastic Cloud Enterprise no longer supports stack versions prior to 8.0.0. All deployments must be upgraded to stack version 8.0.0 or later, prior to upgrading to ECE 4.0.
</dropdown>

<dropdown title="Removed deprecated _upgrade endpoint">
  The `deployments/<deployment_id>/<resource-kind>/<ref_id>/_upgrade` endpoint was already deprecated and has now been removed. To upgrade a deployment using the API, you should instead use the [`/deployments/{deployment_id}`](https://www.elastic.co/docs/api/doc/cloud-enterprise/operation/operation-update-deployment) endpoint.
</dropdown>

<dropdown title="Removed Elasticsearch and Kibana URLs from supported settings">
  `ApmSystemSettings`, `IntegrationsServerSystemSettings`, `KibanaSystemSettings` and `EnterpriseSearchSystemSettings` no longer support `elasticsearchUrl` and `kibanaUrl` fields.
</dropdown>