﻿---
title: Beats deprecations
description: Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for...
url: https://www.elastic.co/docs/release-notes/beats/deprecations
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Beats deprecations
Over time, certain Elastic functionality becomes outdated and is replaced or removed. To help with the transition, Elastic deprecates functionality for a period before removal, giving you time to update your applications.
Review the deprecated functionality for Beats. While deprecations have no immediate impact, we strongly encourage you update your implementation after you upgrade. To learn how to upgrade, check out [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade).

## 9.3.0

**Filebeat**
<dropdown title="Change Azure Event Hub input processor version default from v1 to v2.">
  This PR is to change Filebeat azure eventhub input to use processor V2 as default instead of V1. Since weve decided to retire processor v1, we plan to set processor v2 as the default option in the next release, and completely remove v1 in the following release.For more information, check [#47292](https://github.com/elastic/beats/pull/47292).**Impact**Users of the Azure Event Hub input who were relying on processor v1 as the default behavior will now automatically use processor v2, which may have different behavior or performance characteristics.**Action**Users who want to continue using processor v1 should explicitly set `processor_version: v1` in their configuration.
  However, v1 will be completely removed in a future release, so users should plan to migrate to v2.
  Users who were not explicitly specifying a processor version will now use v2 by default and should test their configuration accordingly.
</dropdown>


## 9.2.5

_No deprecations._

## 9.2.4

_No deprecations._

## 9.2.3

_No deprecations._

## 9.2.2

_No deprecations._

## 9.2.1

_No deprecations._

## 9.2.0

_No deprecations._

## 9.1.9

_No deprecations._

## 9.1.8

_No deprecations._

## 9.1.7

_No deprecations._

## 9.1.6

_No deprecations._

## 9.1.5

_No deprecations._

## 9.1.4

_No deprecations._

## 9.1.3

_No deprecations._

## 9.1.2

_No deprecations._

## 9.1.1

_No deprecations._

## 9.1.0

_No deprecations._

## 9.0.8

_No deprecations._

## 9.0.7

_No deprecations._

## 9.0.6

_No deprecations._

## 9.0.5

_No deprecations._

## 9.0.4

_No deprecations._

## 9.0.3

_No deprecations._

## 9.0.2

_No deprecations._

## 9.0.1

_No deprecations._

## 9.0.0

_No deprecations._