﻿---
title: Beats breaking changes
description: Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade, carefully review the Beats breaking...
url: https://www.elastic.co/docs/release-notes/beats/breaking-changes
products:
  - Beats
applies_to:
  - Elastic Stack: Generally available
---

# Beats breaking changes
Breaking changes can impact your Elastic applications, potentially disrupting normal operations. Before you upgrade, carefully review the Beats breaking changes and take the necessary steps to mitigate any issues. To learn how to upgrade, check [Upgrade](https://www.elastic.co/docs/deploy-manage/upgrade).

## 9.3.0

_No breaking changes._

## 9.2.5

_No breaking changes._

## 9.2.4

_No breaking changes._

## 9.2.3

_No breaking changes._

## 9.2.2

**All**
<dropdown title="Remove otel.component.id and otel.component.kind from beat receiver events.">
  In a previous version, we added the `otel.component.id` and `otel.component.kind` fields, but after running the relevant benchmarks we found that there was not enough value to justify the cost of sending the extra data in every event.For more information, check [#47729](https://github.com/elastic/beats/pull/47729)[#47600](https://github.com/elastic/beats/issues/47600).**Impact**These fields were not publicly documented and were not part of an API. However, if you do rely on them, they will no longer be available.
</dropdown>


## 9.2.1

_No breaking changes._

## 9.2.0

**Filebeat**
<dropdown title="Change `aws.cloudwatch.*` field in awscloudwatch input to nested object.">
  For more information, check [#46357](https://github.com/elastic/beats/pull/46357).
</dropdown>


## 9.1.9

**All**
<dropdown title="Remove otel.component.id and otel.component.kind from beat receiver events.">
  For more information, check [#47729](https://github.com/elastic/beats/pull/47729)[#47600](https://github.com/elastic/beats/issues/47600).**Impact**If previously using the `otel.component.id` or `otel.component.kind` to track Beats receiver events, the fields are no longer used.
</dropdown>


## 9.1.8

_No breaking changes._

## 9.1.7

_No breaking changes._

## 9.1.6

_No breaking changes._

## 9.1.5

**Filebeat**
<dropdown title="Journald input now converts byte-encoded messages to string.">
  For more information, check [40479](https://github.com/elastic/beats/issues/40479) [46415](https://github.com/elastic/beats/pull/46415).
</dropdown>


## 9.1.4

_No breaking changes._

## 9.1.3

**Metricbeat**
<dropdown title="API used by index summary metricset changed.">
  Changed index summary metricset to use `_nodes/stats` API instead of `_stats` API to avoid data gaps.For more information, check [#45049](https://github.com/elastic/beats/pull/45049).
</dropdown>


## 9.1.2

_No breaking changes._

## 9.1.1

**All Beats**
<dropdown title="Update user agent used by Beats HTTP clients.">
  The default user agent was updated to distinguish between all beat modes:
  - **Standalone** indicates that the beat is not running under agent.
  - **Unmanaged** indicates that the beat is running under agent but not managed by Fleet.
  - **Managed** indicates that the beat is running under agent and managed by Fleet.
  Users relying on specific user agents could be impacted.For more information, check [#45251](https://github.com/elastic/beats/pull/45251).
</dropdown>


## 9.1.0

**All Beats**
<dropdown title="The default data and logs path for the Windows service installation has changed.">
  The base folder has changed from `C:\ProgramData\` to `C:\ProgramFiles\`
  because the latter has stricter permissions. The state
  and logs are now stored in `C:\Program Files\<Beat Name>-Data`.When the installation script runs, it looks for the previous default
  data path. If the path is found, data is moved to the new path.
  The installation script accepts the parameter `-ForceLegacyPath` to
  force using the legacy data path.In a PowerShell prompt, use `Get-Help install-service-<Beat Name>.ps1 -detailed` to get detailed help.See 'Quick start -> Installation script' from each Beat for more
  details.
</dropdown>

**Filebeat**
<dropdown title="'close.on_state_change.removed' defaults to `true` on Windows and `false` on the rest of the platforms.">
  To keep the previous behaviour, add `close.on_state_change.removed: true` on every Filestream input.Even after the file is removed, the file handles will stay open until
  it is closed due to
  inactivity. See [`close.on_state_change.inactive`](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-filestream#filebeat-input-filestream-close-inactive)
  for more details.For more information, check [#38523](https://github.com/elastic/beats/issues/38523)
</dropdown>


## 9.0.8

**Filebeat**
<dropdown title="Journald input now converts byte-encoded messages to string.">
  For more information, check [40479](https://github.com/elastic/beats/issues/40479) [46415](https://github.com/elastic/beats/pull/46415).
</dropdown>


## 9.0.7

_No breaking changes._

## 9.0.6

**All Beats**
<dropdown title="The default data and logs path for the Windows service installation has changed.">
  The base folder has changed from `C:\ProgramData\` to
  `C:\ProgramFiles\` because the latter has stricter permissions. The state
  and logs are now stored in `C:\Program Files\<Beat Name>-Data`.When the installation script runs, it looks for the previous default
  data path. If the path is found, data is moved to the new path.
  The installation script accepts the parameter `-ForceLegacyPath` to
  force using the legacy data path.In a PowerShell prompt, use `Get-Help install-service-<Beat Name>.ps1 -detailed` to get detailed help.See 'Quick start -> Installation script' from each Beat for more
  details.
</dropdown>


## 9.0.4

**Metricbeat**
<dropdown title="Change index summary metricset to use `_nodes/stats` API instead of `_stats` API to avoid data gaps.">
  For more information, check  [#45049](https://github.com/elastic/beats/pull/45049).
</dropdown>


## 9.0.3

_No breaking changes._

## 9.0.2

_No breaking changes._

## 9.0.1

_No breaking changes._

## 9.0.0

<dropdown title="Set default Kafka version to 2.1.0 in Kafka output and Filebeat.">
  For more information, check [#41662](https://github.com/elastic/beats/pull/41662).
</dropdown>

<dropdown title="Replaced default Ubuntu-based images with UBI-minimal-based ones.">
  For more information, check  [#42150](https://github.com/elastic/beats/pull/42150).
</dropdown>

<dropdown title="Removed support for a single "-" to precede multi-letter command line arguments.  Use "--" instead.">
  For more information, check [#42117](https://github.com/elastic/beats/issues/42117) [#42209](https://github.com/elastic/beats/pull/42209).
</dropdown>

<dropdown title="Filebeat fails to start if there is any input with a duplicated ID. It logs the duplicated IDs and the offending inputs configurations.">
  For more information, check [#41731](https://github.com/elastic/beats/pull/41731).
</dropdown>

<dropdown title="Filestream inputs with duplicated IDs will fail to start. An error is logged showing the ID and the full input configuration.">
  For more information, check [#41938](https://github.com/elastic/beats/issues/41938) [#41954](https://github.com/elastic/beats/pull/41954).
</dropdown>

<dropdown title="Filestream inputs can define "allow_deprecated_id_duplication: true" to run keep the previous behaviour of running inputs with duplicated IDs.">
  For more information, check [#41938](https://github.com/elastic/beats/issues/41938) [#41954](https://github.com/elastic/beats/pull/41954).
</dropdown>

<dropdown title="Filestream inputs now starts ingesting files only if they are 1024 bytes or larger because the default file identity has changed from native to fingerprint.">
  At startup Filebeat automatically updates the state from known, active files (i.e: files that are still present on the disk and have not changed path since Filebeat was stopped) to use the new file identity. If Filebeat cannot migrate the state to the new file identity, the file will be re-ingested. To preserve the behaviour from 8.x, set `file_identity.native: ~` and `prospector.scanner.fingerprint.enabled: false`.Refer to the file identity documentation for more details. You can also check [#40197](https://github.com/elastic/beats/issues/40197) [#41762](https://github.com/elastic/beats/pull/41762).
</dropdown>

<dropdown title="Filebeat fails to start when its configuration contains usage of the deprecated log or container inputs. However, they can still be used when "allow_deprecated_use: true" is set in their configuration.">
  For more information, check [#42295](https://github.com/elastic/beats/pull/42295).
</dropdown>

<dropdown title="Upgrade osquery version to 5.13.1.">
  For more information, check [#40849](https://github.com/elastic/beats/pull/40849).
</dropdown>

<dropdown title="Use base-16 for reporting serial_number value in TLS fields in line with the ECS recommendation.">
  For more information, check [#41542](https://github.com/elastic/beats/pull/41542).
</dropdown>

<dropdown title="Default to use raw API and delete older XML implementation.">
  For more information, check [#42275](https://github.com/elastic/beats/pull/42275).
</dropdown>

<dropdown title="The Beats logger and file output rotate files when necessary. The beat now forces a file rotation when unexpectedly writing to a file through a symbolic link.">
</dropdown>

<dropdown title="Remove kibana.settings metricset since the API was removed in 8.0 in Metricbeat.">
  For more information, check [#30592](https://github.com/elastic/beats/issues/30592). [#42937](https://github.com/elastic/beats/pull/42937).
</dropdown>

<dropdown title="Removed support for the Enterprise Search module in Metricbeat.">
  For more information, check [#42915](https://github.com/elastic/beats/pull/42915).
</dropdown>

<dropdown title="Allow faccessat(2) in seccomp.">
  For more information, check [#43322](https://github.com/elastic/beats/pull/43322).
</dropdown>